/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewChildElementHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Adding New Child Element...";

    public Object execute(ExecutionEvent aEvent) {
        final IR4EUIModelElement element = this.getParentElement(aEvent);
        if (element != null) {
            try {
                List<ReviewComponent> tempModelComponents = element.createChildModelDataElement();
                for (final ReviewComponent tempModelComponent : tempModelComponents) {
                    R4EUIPlugin.Ftracer.traceInfo("Adding child to element " + element.getName());
                    Job job = new Job(COMMAND_MESSAGE){
                        public String familyName;
                        {
                            super($anonymous0);
                            this.familyName = R4EUIConstants.R4E_UI_JOB_FAMILY;
                        }

                        public boolean belongsTo(Object family) {
                            return this.familyName.equals(family);
                        }

                        public IStatus run(IProgressMonitor monitor) {
                            monitor.beginTask(NewChildElementHandler.COMMAND_MESSAGE, -1);
                            R4EUIModelController.setJobInProgress(true);
                            IR4EUIModelElement newElement = null;
                            try {
                                newElement = element.createChildren(tempModelComponent);
                                R4EUIModelController.setJobInProgress(false);
                                UIUtils.setNavigatorViewFocus(newElement, -1);
                            }
                            catch (ResourceHandlingException e) {
                                UIUtils.displayResourceErrorDialog(e);
                                try {
                                    element.removeChildren(newElement, true);
                                }
                                catch (ResourceHandlingException e1) {
                                    UIUtils.displayResourceErrorDialog(e1);
                                }
                                catch (OutOfSyncException e1) {
                                    UIUtils.displaySyncErrorDialog(e1);
                                }
                                catch (CompatibilityException e1) {
                                    UIUtils.displayCompatibilityErrorDialog(e1);
                                }
                            }
                            catch (CompatibilityException e) {
                                UIUtils.displayCompatibilityErrorDialog(e);
                                try {
                                    element.removeChildren(newElement, true);
                                }
                                catch (ResourceHandlingException e1) {
                                    UIUtils.displayResourceErrorDialog(e1);
                                }
                                catch (OutOfSyncException e1) {
                                    UIUtils.displaySyncErrorDialog(e1);
                                }
                                catch (CompatibilityException e1) {
                                    UIUtils.displayCompatibilityErrorDialog(e1);
                                }
                            }
                            catch (OutOfSyncException e) {
                                UIUtils.displaySyncErrorDialog(e);
                                try {
                                    element.removeChildren(newElement, true);
                                }
                                catch (ResourceHandlingException e1) {
                                    UIUtils.displayResourceErrorDialog(e1);
                                }
                                catch (OutOfSyncException e1) {
                                    UIUtils.displaySyncErrorDialog(e1);
                                }
                                catch (CompatibilityException e1) {
                                    UIUtils.displayCompatibilityErrorDialog(e1);
                                }
                            }
                            R4EUIModelController.setJobInProgress(false);
                            monitor.done();
                            return Status.OK_STATUS;
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                }
            }
            catch (ResourceHandlingException e) {
                UIUtils.displayResourceErrorDialog(e);
            }
        }
        return null;
    }

    private IR4EUIModelElement getParentElement(ExecutionEvent event) {
        IStructuredSelection selection;
        Widget triggerObject = ((Event)event.getTrigger()).widget;
        IR4EUIModelElement element = null;
        element = triggerObject instanceof ToolItem ? R4EUIModelController.getRootElement() : (!(selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event)).isEmpty() ? (IR4EUIModelElement)selection.getFirstElement() : R4EUIModelController.getRootElement());
        return element;
    }
}

