/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.reviews.r4e.report.impl.IR4EReport;
import org.eclipse.mylyn.reviews.r4e.report.impl.R4EReportFactory;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewGroup;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.ui.handlers.HandlerUtil;

public class ReportElementHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Generating Report for Elements...";

    public Object execute(final ExecutionEvent event) {
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = R4EUIConstants.R4E_UI_JOB_FAMILY;
            }

            public boolean belongsTo(Object family) {
                return this.familyName.equals(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(ReportElementHandler.COMMAND_MESSAGE, -1);
                R4EUIModelController.setJobInProgress(true);
                ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                    IR4EUIModelElement element = null;
                    IStructuredSelection structSelection = (IStructuredSelection)selection;
                    Iterator iter = structSelection.iterator();
                    String groupFile = null;
                    ArrayList<File> listSelectedReviews = new ArrayList<File>();
                    while (iter.hasNext()) {
                        element = (IR4EUIModelElement)iter.next();
                        if (!(element instanceof R4EUIReviewBasic)) continue;
                        R4EUIReviewBasic extentElement = (R4EUIReviewBasic)element;
                        if (groupFile == null) {
                            groupFile = ((R4EUIReviewGroup)extentElement.getParent()).getGroupFile();
                            R4EUIPlugin.Ftracer.traceInfo("Info: Group file: " + groupFile);
                        }
                        R4EUIPlugin.Ftracer.traceInfo("Review name element " + extentElement.getReview().getName());
                        listSelectedReviews.add(new File(extentElement.getReview().getName()));
                    }
                    IR4EReport reportGen = R4EReportFactory.getInstance();
                    reportGen.setReviewListSelection(listSelectedReviews.toArray(new File[listSelectedReviews.size()]));
                    reportGen.handleReportGeneration(groupFile, monitor);
                }
                monitor.done();
                R4EUIModelController.setJobInProgress(false);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

