/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.frame.core.model.Comment;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomaly;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EComment;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.core.model.RModelFactory;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.ICommentInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIComment;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.AnomalyBasicProperties;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class R4EUIAnomalyBasic
extends R4EUIModelElement {
    public static final String ANOMALY_ICON_FILE = "icons/obj16/anmly_obj.gif";
    private static final String NEW_CHILD_ELEMENT_COMMAND_NAME = "New Comment...";
    private static final String NEW_CHILD_ELEMENT_COMMAND_TOOLTIP = "Add a New Comment to the Current Anomaly";
    private static final String REMOVE_ELEMENT_COMMAND_NAME = "Disable Anomaly";
    private static final String REMOVE_ELEMENT_COMMAND_TOOLTIP = "Disable (and Optionally Remove) this Anomaly from its parent file or review";
    private static final String RESTORE_ELEMENT_COMMAND_NAME = "Restore Anomaly";
    private static final String RESTORE_ELEMENT_COMMAND_TOOLTIP = "Restore this disabled Anomaly";
    private static final int ANOMALY_LABEL_TITLE_LENGTH = 20;
    private static final String CREATE_COMMENT_MESSAGE = "Creating New Comment...";
    protected final R4EAnomaly fAnomaly;
    private final List<R4EUIComment> fComments;
    private final IR4EUIPosition fPosition;

    public R4EUIAnomalyBasic(IR4EUIModelElement aParent, R4EAnomaly aAnomaly, IR4EUIPosition aPosition) {
        super(aParent, R4EUIAnomalyBasic.buildAnomalyName(aAnomaly, aPosition));
        this.fReadOnly = aParent.isReadOnly();
        this.fAnomaly = aAnomaly;
        this.fComments = new ArrayList<R4EUIComment>();
        this.setImage(ANOMALY_ICON_FILE);
        this.fPosition = aPosition;
    }

    @Override
    public String getToolTip() {
        return R4EUIAnomalyBasic.buildAnomalyToolTip(this.fAnomaly);
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IR4EUIModelElement.class.equals((Object)adapter)) {
            return this;
        }
        if (IPropertySource.class.equals((Object)adapter)) {
            return new AnomalyBasicProperties(this);
        }
        return null;
    }

    public R4EAnomaly getAnomaly() {
        return this.fAnomaly;
    }

    public IR4EUIPosition getPosition() {
        return this.fPosition;
    }

    @Override
    public List<ReviewComponent> createChildModelDataElement() {
        ArrayList<ReviewComponent> tempComments = new ArrayList<ReviewComponent>();
        R4EUIModelController.setJobInProgress(true);
        ICommentInputDialog dialog = R4EUIDialogFactory.getInstance().getCommentInputDialog();
        int result = dialog.open();
        if (result == 0) {
            R4EComment tempComment = RModelFactory.eINSTANCE.createR4EComment();
            tempComment.setDescription(dialog.getCommentValue());
            tempComments.add((ReviewComponent)tempComment);
        }
        R4EUIModelController.setJobInProgress(false);
        return tempComments;
    }

    @Override
    public void setModelData(ReviewComponent aModelComponent) throws ResourceHandlingException, OutOfSyncException {
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fAnomaly, R4EUIModelController.getReviewer());
        this.fAnomaly.setTitle(((R4EAnomaly)aModelComponent).getTitle());
        this.fAnomaly.setDescription(((R4EAnomaly)aModelComponent).getDescription());
        this.fAnomaly.setType(((R4EAnomaly)aModelComponent).getType());
        this.fAnomaly.setRank(((R4EAnomaly)aModelComponent).getRank());
        this.fAnomaly.setDueDate(((R4EAnomaly)aModelComponent).getDueDate());
        this.fAnomaly.setRuleID(((R4EAnomaly)aModelComponent).getRuleID());
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    public static String buildAnomalyName(R4EAnomaly aAnomaly, IR4EUIPosition aPosition) {
        return aPosition == null ? R4EUIAnomalyBasic.adjustTitleLength(aAnomaly) : String.valueOf(aPosition.toString()) + "->" + R4EUIAnomalyBasic.adjustTitleLength(aAnomaly);
    }

    protected static String adjustTitleLength(R4EAnomaly aAnomaly) {
        String anomalyTitle = aAnomaly.getTitle();
        if (anomalyTitle == null) {
            return "";
        }
        if (anomalyTitle.length() > 20) {
            return String.valueOf(anomalyTitle.substring(0, 20)) + "...";
        }
        return anomalyTitle;
    }

    public static String buildAnomalyToolTip(R4EAnomaly aAnomaly) {
        return String.valueOf(aAnomaly.getUser().getId()) + ": " + aAnomaly.getDescription();
    }

    @Override
    public void setEnabled(boolean aEnabled) throws ResourceHandlingException, OutOfSyncException {
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fAnomaly, R4EUIModelController.getReviewer());
        this.fAnomaly.setEnabled(true);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    @Override
    public boolean isEnabled() {
        return this.fAnomaly.isEnabled();
    }

    @Override
    public IR4EUIModelElement[] getChildren() {
        return this.fComments.toArray(new R4EUIComment[this.fComments.size()]);
    }

    @Override
    public boolean hasChildren() {
        return this.fComments.size() > 0;
    }

    @Override
    public void close() {
        R4EUIComment comment = null;
        int commentsSize = this.fComments.size();
        int i = 0;
        while (i < commentsSize) {
            comment = this.fComments.get(i);
            comment.close();
            ++i;
        }
        this.fComments.clear();
        this.fOpen = false;
    }

    @Override
    public void open() {
        EList comments = this.fAnomaly.getComments();
        if (comments != null) {
            R4EComment r4eComment = null;
            int commentsSize = comments.size();
            int i = 0;
            while (i < commentsSize) {
                r4eComment = (R4EComment)comments.get(i);
                if (r4eComment.isEnabled() || R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
                    this.addChildren(new R4EUIComment((IR4EUIModelElement)this, r4eComment));
                }
                ++i;
            }
        }
        this.fOpen = true;
    }

    @Override
    public void addChildren(IR4EUIModelElement aChildToAdd) {
        this.fComments.add((R4EUIComment)aChildToAdd);
    }

    @Override
    public IR4EUIModelElement createChildren(ReviewComponent aModelComponent) throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
        String user = R4EUIModelController.getReviewer();
        R4EParticipant participant = null;
        participant = this.getParent().getParent().getParent().getParent() instanceof R4EUIReviewBasic ? ((R4EUIReviewBasic)this.getParent().getParent().getParent().getParent()).getParticipant(user, true) : ((R4EUIReviewBasic)this.getParent().getParent()).getParticipant(user, true);
        R4EComment comment = R4EUIModelController.FModelExt.createR4EComment(participant, this.fAnomaly);
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)comment, R4EUIModelController.getReviewer());
        comment.setDescription(((Comment)aModelComponent).getDescription());
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        R4EUIComment addedChild = new R4EUIComment((IR4EUIModelElement)this, comment);
        this.addChildren(addedChild);
        return addedChild;
    }

    public boolean createComment(boolean aRejectionComment) {
        final ICommentInputDialog dialog = R4EUIDialogFactory.getInstance().getCommentInputDialog();
        final R4EUIAnomalyBasic commentParent = this;
        final int[] result = new int[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                result[0] = dialog.open();
            }
        });
        if (result[0] == 0) {
            Job job = new Job(CREATE_COMMENT_MESSAGE){
                public String familyName;
                {
                    super($anonymous0);
                    this.familyName = R4EUIConstants.R4E_UI_JOB_FAMILY;
                }

                public boolean belongsTo(Object family) {
                    return this.familyName.equals(family);
                }

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        R4EUIReviewBasic uiReview = R4EUIModelController.getActiveReview();
                        R4EParticipant participant = uiReview.getParticipant(R4EUIModelController.getReviewer(), true);
                        R4EComment comment = R4EUIModelController.FModelExt.createR4EComment(participant, R4EUIAnomalyBasic.this.fAnomaly);
                        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)comment, R4EUIModelController.getReviewer());
                        comment.setDescription(dialog.getCommentValue());
                        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        R4EUIComment uiComment = new R4EUIComment(commentParent, comment);
                        R4EUIAnomalyBasic.this.addChildren(uiComment);
                        R4EUIModelController.setJobInProgress(false);
                        UIUtils.setNavigatorViewFocus(uiComment, -1);
                    }
                    catch (ResourceHandlingException e) {
                        UIUtils.displayResourceErrorDialog(e);
                    }
                    catch (OutOfSyncException e) {
                        UIUtils.displaySyncErrorDialog(e);
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        } else if (aRejectionComment) {
            return false;
        }
        return true;
    }

    @Override
    public void removeChildren(IR4EUIModelElement aChildToRemove, boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        R4EUIComment removedElement = this.fComments.get(this.fComments.indexOf(aChildToRemove));
        R4EComment modelComment = removedElement.getComment();
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelComment, R4EUIModelController.getReviewer());
        modelComment.setEnabled(false);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        if (!R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
            this.fComments.remove(removedElement);
        }
    }

    @Override
    public void removeAllChildren(boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        for (R4EUIComment comment : this.fComments) {
            this.removeChildren(comment, aFileRemove);
        }
    }

    @Override
    public void restore() throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
        super.restore();
        for (String participant : this.fAnomaly.getAssignedTo()) {
            R4EUIModelController.getActiveReview().getParticipant(participant, true);
        }
    }

    @Override
    public boolean isOpenEditorCmd() {
        if (!(this.getParent().getParent() instanceof R4EUIFileContext)) {
            return false;
        }
        return this.isEnabled() && ((R4EUIFileContext)this.getParent().getParent()).getTargetFileVersion() != null;
    }

    @Override
    public boolean isNewChildElementCmd() {
        return this.isEnabled() && !this.isReadOnly() && !((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    @Override
    public String getNewChildElementCmdName() {
        return NEW_CHILD_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getNewChildElementCmdTooltip() {
        return NEW_CHILD_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isRemoveElementCmd() {
        return this.isEnabled() && !this.isReadOnly() && !((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    @Override
    public String getRemoveElementCmdName() {
        return REMOVE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getRemoveElementCmdTooltip() {
        return REMOVE_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isRestoreElementCmd() {
        if (!this.getParent().getParent().isEnabled()) {
            return false;
        }
        return !this.isEnabled() && !this.isReadOnly() && !((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    @Override
    public String getRestoreElementCmdName() {
        return RESTORE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getRestoreElementCmdTooltip() {
        return RESTORE_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isSendEmailCmd() {
        return this.isEnabled();
    }

    public boolean isTitleEnabled() {
        return R4EUIModelController.getActiveReview() != null && (this.fAnomaly.getRuleID() == null || this.fAnomaly.getRuleID().equals(""));
    }

    public boolean isClassEnabled() {
        return R4EUIModelController.getActiveReview() != null && (this.fAnomaly.getRuleID() == null || this.fAnomaly.getRuleID().equals(""));
    }

    public boolean isRankEnabled() {
        return R4EUIModelController.getActiveReview() != null && (this.fAnomaly.getRuleID() == null || this.fAnomaly.getRuleID().equals(""));
    }

    public boolean isDueDateEnabled() {
        return true;
    }
}

