/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EDelta;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EItem;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.ContentsProperties;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class R4EUIContent
extends R4EUIModelElement {
    private static final String REMOVE_ELEMENT_COMMAND_NAME = "Disable Content";
    private static final String REMOVE_ELEMENT_COMMAND_TOOLTIP = "Disable (and Optionally Remove) this Content from its Parent Container";
    private static final String RESTORE_ELEMENT_COMMAND_NAME = "Restore Content";
    private static final String RESTORE_ELEMENT_COMMAND_TOOLTIP = "Restore this disabled Content";
    private final R4EDelta fContent;
    private final IR4EUIPosition fPosition;

    protected R4EUIContent(IR4EUIModelElement aParent, R4EDelta aDelta, IR4EUIPosition aPosition) {
        super(aParent, aPosition.toString());
        this.fReadOnly = aParent.isReadOnly();
        this.fContent = aDelta;
        this.fPosition = aPosition;
        try {
            this.getParent().getParent().setUserReviewed(false, false, true);
        }
        catch (OutOfSyncException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
        }
        catch (ResourceHandlingException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
        }
    }

    @Override
    public String getToolTip() {
        return "Added By: " + ((R4EItem)this.fContent.eContainer().eContainer()).getAddedBy().getId();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IR4EUIModelElement.class.equals((Object)adapter)) {
            return this;
        }
        if (IPropertySource.class.equals((Object)adapter)) {
            return new ContentsProperties(this);
        }
        return null;
    }

    public R4EDelta getContent() {
        return this.fContent;
    }

    public IR4EUIPosition getPosition() {
        return this.fPosition;
    }

    @Override
    public void setUserReviewed(boolean aReviewed, boolean aSetChildren, boolean aUpdateModel) throws ResourceHandlingException, OutOfSyncException {
        if (this.fUserReviewed != aReviewed) {
            this.fUserReviewed = aReviewed;
            if (this.fUserReviewed) {
                if (aUpdateModel) {
                    this.addContentReviewed();
                }
                this.getParent().getParent().checkToSetUserReviewed(aUpdateModel);
            } else {
                if (aUpdateModel) {
                    this.removeContentReviewed();
                }
                this.getParent().getParent().setUserReviewed(this.fUserReviewed, false, aUpdateModel);
            }
        }
    }

    @Override
    public void setChildUserReviewed(boolean aReviewed, boolean aUpdateModel) throws ResourceHandlingException, OutOfSyncException {
        if (this.fUserReviewed != aReviewed) {
            this.fUserReviewed = aReviewed;
            if (aUpdateModel) {
                if (aReviewed) {
                    this.addContentReviewed();
                } else {
                    this.removeContentReviewed();
                }
            }
            this.fUserReviewed = aReviewed;
        }
    }

    private void addContentReviewed() throws ResourceHandlingException, OutOfSyncException {
        R4EUIReviewBasic review = (R4EUIReviewBasic)this.getParent().getParent().getParent().getParent();
        R4EParticipant user = review.getParticipant(R4EUIModelController.getReviewer(), true);
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)user, user.getId());
        user.getReviewedContent().add((Object)this.fContent.getId());
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    private void removeContentReviewed() throws ResourceHandlingException, OutOfSyncException {
        R4EUIReviewBasic review = (R4EUIReviewBasic)this.getParent().getParent().getParent().getParent();
        R4EParticipant user = review.getParticipant(R4EUIModelController.getReviewer(), false);
        if (user != null) {
            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)user, user.getId());
            user.getReviewedContent().remove((Object)this.fContent.getId());
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        }
    }

    @Override
    public void setEnabled(boolean aEnabled) throws ResourceHandlingException, OutOfSyncException {
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fContent, R4EUIModelController.getReviewer());
        this.fContent.setEnabled(true);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    @Override
    public boolean isEnabled() {
        return this.fContent.isEnabled();
    }

    @Override
    public void addAssignees(List<R4EParticipant> aParticipants) {
        try {
            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fContent, R4EUIModelController.getReviewer());
            EList assignedParticipants = this.fContent.getAssignedTo();
            for (R4EParticipant participant : aParticipants) {
                assignedParticipants.add((Object)participant.getId());
                ((R4EUIReviewBasic)this.getParent().getParent().getParent().getParent()).getParticipant(participant.getId(), true);
            }
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        }
        catch (ResourceHandlingException e1) {
            UIUtils.displayResourceErrorDialog(e1);
        }
        catch (OutOfSyncException e1) {
            UIUtils.displaySyncErrorDialog(e1);
        }
    }

    @Override
    public void removeAssignees(List<R4EParticipant> aParticipants) {
        try {
            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fContent, R4EUIModelController.getReviewer());
            EList assignedParticipants = this.fContent.getAssignedTo();
            for (R4EParticipant participant : aParticipants) {
                assignedParticipants.remove((Object)participant.getId());
            }
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        }
        catch (ResourceHandlingException e1) {
            UIUtils.displayResourceErrorDialog(e1);
        }
        catch (OutOfSyncException e1) {
            UIUtils.displaySyncErrorDialog(e1);
        }
    }

    @Override
    public void restore() throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
        super.restore();
        for (String participant : this.fContent.getAssignedTo()) {
            R4EUIModelController.getActiveReview().getParticipant(participant, true);
        }
    }

    @Override
    public boolean isAssigned(String aUsername, boolean aCheckChildren) {
        return this.fContent.isEnabled() && this.fContent.getAssignedTo().contains((Object)aUsername);
    }

    @Override
    public boolean isAddLinkedAnomalyCmd() {
        return this.isEnabled() && !this.isReadOnly() && !((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    @Override
    public boolean isOpenEditorCmd() {
        return this.isEnabled() && ((R4EUIFileContext)this.getParent().getParent()).getTargetFileVersion() != null;
    }

    @Override
    public boolean isChangeUserReviewStateCmd() {
        return this.isEnabled() && !this.isReadOnly() && !((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    @Override
    public boolean isAssignToCmd() {
        return this.isEnabled() && !this.isReadOnly() && !((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    @Override
    public boolean isUnassignToCmd() {
        return this.isEnabled() && !this.isReadOnly() && !((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED) && this.fContent.getAssignedTo().size() > 0;
    }

    @Override
    public boolean isRemoveElementCmd() {
        return this.isEnabled() && !this.isReadOnly() && !((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    @Override
    public String getRemoveElementCmdName() {
        return REMOVE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getRemoveElementCmdTooltip() {
        return REMOVE_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isRestoreElementCmd() {
        if (!this.getParent().getParent().isEnabled()) {
            return false;
        }
        return !this.isEnabled() && !this.isReadOnly() && !((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    @Override
    public String getRestoreElementCmdName() {
        return RESTORE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getRestoreElementCmdTooltip() {
        return RESTORE_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isSendEmailCmd() {
        return this.isEnabled();
    }
}

