/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomaly;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileContext;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.IRFSRegistry;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.RFSRegistryFactory;
import org.eclipse.mylyn.reviews.r4e.core.rfs.spi.ReviewsFileStorageException;
import org.eclipse.mylyn.reviews.r4e.core.utils.ResourceUtils;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContent;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContentsContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIDeltaContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUISelectionContainer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.FileContextProperties;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class R4EUIFileContext
extends R4EUIModelElement {
    public static final String FILE_CONTEXT_ICON_FILE = "icons/obj16/filectx_obj.gif";
    public static final String REMOVED_OVERLAY_ICON_FILE = "icons/ovr16/removr_tsk.png";
    public static final String ADDED_OVERLAY_ICON_FILE = "icons/ovr16/addovr_tsk.png";
    protected final R4EFileContext fFile;
    private R4EUIContentsContainer fContentsContainer = null;
    private R4EUIAnomalyContainer fAnomalyContainer = null;
    protected List<R4EAnomaly> fAnomalies = null;

    public R4EUIFileContext(IR4EUIModelElement aParent, R4EFileContext aFile, int aParentItemType) {
        super(aParent, "");
        this.fReadOnly = aParent.isReadOnly();
        if (aFile.getTarget() != null) {
            this.setName(aFile.getTarget().getName());
        } else if (aFile.getBase() != null) {
            this.setName(aFile.getBase().getName());
        }
        this.fContentsContainer = aParentItemType == 1 ? new R4EUIDeltaContainer(this, "Deltas") : new R4EUISelectionContainer(this, "Selections");
        this.addChildren(new R4EUIAnomalyContainer(this, "Anomalies"));
        this.fFile = aFile;
        this.setImage(FILE_CONTEXT_ICON_FILE);
    }

    @Override
    public String getToolTip() {
        return R4EUIFileContext.getNavigatorTooltip(this.fFile.getTarget(), this.fFile.getBase());
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IR4EUIModelElement.class.equals((Object)adapter)) {
            return this;
        }
        if (IPropertySource.class.equals((Object)adapter)) {
            return new FileContextProperties(this);
        }
        return null;
    }

    public List<R4EAnomaly> getAnomalies() {
        return this.fAnomalies;
    }

    public R4EFileVersion getBaseFileVersion() {
        return this.fFile.getBase();
    }

    public R4EFileVersion getTargetFileVersion() {
        return this.fFile.getTarget();
    }

    public Image getRemovedImage() {
        return UIUtils.loadIcon(REMOVED_OVERLAY_ICON_FILE);
    }

    public Image getAddedImage() {
        return UIUtils.loadIcon(ADDED_OVERLAY_ICON_FILE);
    }

    public R4EFileContext getFileContext() {
        return this.fFile;
    }

    @Override
    public void setUserReviewed(boolean aReviewed, boolean aSetChildren, boolean aUpdateModel) throws ResourceHandlingException, OutOfSyncException {
        if (this.fUserReviewed != aReviewed) {
            this.fUserReviewed = aReviewed;
            if (this.fUserReviewed) {
                if (aUpdateModel) {
                    this.addContentReviewed();
                }
                this.getParent().checkToSetUserReviewed(aUpdateModel);
            } else {
                if (aUpdateModel) {
                    this.removeContentReviewed();
                }
                this.getParent().setUserReviewed(this.fUserReviewed, false, aUpdateModel);
            }
            if (aSetChildren) {
                int length = this.fContentsContainer.getChildren().length;
                int i = 0;
                while (i < length) {
                    this.fContentsContainer.getChildren()[i].setChildUserReviewed(aReviewed, aUpdateModel);
                    ++i;
                }
            }
        }
    }

    public static String getNavigatorTooltip(R4EFileVersion aTarget, R4EFileVersion aBase) {
        StringBuilder tooltip = new StringBuilder();
        tooltip.append("Base Version: ");
        if (aBase != null) {
            tooltip.append(aBase.getVersionID());
        } else {
            tooltip.append("(not present)");
        }
        tooltip.append(R4EUIConstants.LINE_FEED);
        tooltip.append("Target Version: ");
        if (aTarget != null) {
            tooltip.append(aTarget.getVersionID());
        } else {
            tooltip.append("(not present)");
        }
        return tooltip.toString();
    }

    @Override
    public void setChildUserReviewed(boolean aReviewed, boolean aUpdateModel) throws ResourceHandlingException, OutOfSyncException {
        if (this.fUserReviewed != aReviewed) {
            this.fUserReviewed = aReviewed;
            if (aUpdateModel) {
                if (aReviewed) {
                    this.addContentReviewed();
                } else {
                    this.removeContentReviewed();
                }
            }
            int length = this.fContentsContainer.getChildren().length;
            int i = 0;
            while (i < length) {
                this.fContentsContainer.getChildren()[i].setChildUserReviewed(aReviewed, aUpdateModel);
                ++i;
            }
            this.fUserReviewed = aReviewed;
        }
    }

    @Override
    public void checkToSetUserReviewed(boolean aUpdateModel) throws ResourceHandlingException, OutOfSyncException {
        boolean allChildrenReviewed = true;
        int length = this.fContentsContainer.getChildren().length;
        int i = 0;
        while (i < length) {
            if (!this.fContentsContainer.getChildren()[i].isUserReviewed()) {
                allChildrenReviewed = false;
            }
            ++i;
        }
        if (allChildrenReviewed) {
            this.fUserReviewed = true;
            if (aUpdateModel) {
                this.addContentReviewed();
            }
            this.getParent().checkToSetUserReviewed(aUpdateModel);
        }
    }

    private void addContentReviewed() throws ResourceHandlingException, OutOfSyncException {
        R4EUIReviewBasic review = (R4EUIReviewBasic)this.getParent().getParent();
        R4EParticipant user = review.getParticipant(R4EUIModelController.getReviewer(), true);
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)user, user.getId());
        user.getReviewedContent().add((Object)this.fFile.getId());
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    private void removeContentReviewed() throws ResourceHandlingException, OutOfSyncException {
        R4EUIReviewBasic review = (R4EUIReviewBasic)this.getParent().getParent();
        R4EParticipant user = review.getParticipant(R4EUIModelController.getReviewer(), false);
        if (user != null) {
            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)user, user.getId());
            user.getReviewedContent().remove((Object)this.fFile.getId());
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        }
    }

    @Override
    public void setEnabled(boolean aEnabled) throws ResourceHandlingException, OutOfSyncException {
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fFile, R4EUIModelController.getReviewer());
        this.fFile.setEnabled(true);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    @Override
    public boolean isEnabled() {
        return this.fFile.isEnabled();
    }

    @Override
    public void addAssignees(List<R4EParticipant> aParticipants) {
        try {
            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fFile, R4EUIModelController.getReviewer());
            EList assignedParticipants = this.fFile.getAssignedTo();
            for (R4EParticipant participant : aParticipants) {
                assignedParticipants.add((Object)participant.getId());
                ((R4EUIReviewBasic)this.getParent().getParent()).getParticipant(participant.getId(), true);
            }
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        }
        catch (ResourceHandlingException e1) {
            UIUtils.displayResourceErrorDialog(e1);
        }
        catch (OutOfSyncException e1) {
            UIUtils.displaySyncErrorDialog(e1);
        }
        for (R4EUIContent content : this.fContentsContainer.fContents) {
            content.addAssignees(aParticipants);
        }
    }

    @Override
    public void removeAssignees(List<R4EParticipant> aParticipants) {
        try {
            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fFile, R4EUIModelController.getReviewer());
            EList assignedParticipants = this.fFile.getAssignedTo();
            for (R4EParticipant participant : aParticipants) {
                assignedParticipants.remove((Object)participant.getId());
            }
            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        }
        catch (ResourceHandlingException e1) {
            UIUtils.displayResourceErrorDialog(e1);
        }
        catch (OutOfSyncException e1) {
            UIUtils.displaySyncErrorDialog(e1);
        }
        if (this.fContentsContainer != null) {
            for (R4EUIContent content : this.fContentsContainer.fContents) {
                content.removeAssignees(aParticipants);
            }
        }
    }

    public int getNumChanges() {
        IR4EUIModelElement[] children;
        R4EUIContentsContainer container = this.getContentsContainerElement();
        if (container != null && (children = container.getChildren()) != null) {
            return children.length;
        }
        return 0;
    }

    public int getNumReviewedChanges() {
        int numReviewedChanges = 0;
        IR4EUIModelElement[] iR4EUIModelElementArray = this.fContentsContainer.getChildren();
        int n = iR4EUIModelElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IR4EUIModelElement changes = iR4EUIModelElementArray[n2];
            if (((R4EUIContent)changes).isUserReviewed()) {
                ++numReviewedChanges;
            }
            ++n2;
        }
        return numReviewedChanges;
    }

    public int getNumAnomalies() {
        IR4EUIModelElement[] children;
        R4EUIAnomalyContainer container = this.getAnomalyContainerElement();
        if (container != null && (children = container.getChildren()) != null) {
            return children.length;
        }
        return 0;
    }

    @Override
    public IR4EUIModelElement[] getChildren() {
        ArrayList<R4EUIModelElement> newList = new ArrayList<R4EUIModelElement>();
        if (this.fContentsContainer.getChildren().length > 0) {
            newList.add(this.fContentsContainer);
        }
        if (this.fAnomalyContainer.getChildren().length > 0) {
            newList.add(this.fAnomalyContainer);
        }
        return newList.toArray(new IR4EUIModelElement[newList.size()]);
    }

    public R4EUIContentsContainer getContentsContainerElement() {
        return this.fContentsContainer;
    }

    public R4EUIAnomalyContainer getAnomalyContainerElement() {
        return this.fAnomalyContainer;
    }

    @Override
    public boolean hasChildren() {
        return (this.fContentsContainer.getChildren().length != 0 || this.fAnomalyContainer.getChildren().length != 0) && R4EUIModelController.getNavigatorView().isDefaultDisplay();
    }

    @Override
    public void close() {
        this.fContentsContainer.close();
        this.fAnomalyContainer.close();
        this.fOpen = false;
    }

    @Override
    public void open() {
        R4EFileVersion targetFileVersion;
        IRFSRegistry revRegistry = null;
        try {
            revRegistry = RFSRegistryFactory.getRegistry((R4EReview)((R4EUIReviewBasic)this.getParent().getParent()).getReview());
        }
        catch (ReviewsFileStorageException e1) {
            R4EUIPlugin.Ftracer.traceInfo("Exception: " + e1.toString() + " (" + e1.getMessage() + ")");
            R4EUIPlugin.getDefault().logInfo("Exception: " + e1.toString(), (Exception)((Object)e1));
        }
        R4EFileVersion baseFileVersion = this.fFile.getBase();
        if (baseFileVersion != null) {
            try {
                IFile baseFile = ResourceUtils.toIFile((String)baseFileVersion.getPlatformURI());
                baseFileVersion.setResource((IResource)baseFile);
            }
            catch (FileNotFoundException e) {
                R4EUIPlugin.Ftracer.traceInfo("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                baseFileVersion.setResource(null);
            }
            baseFileVersion.setFileRevision(null);
            if (revRegistry != null) {
                try {
                    IFileRevision fileRev = revRegistry.getIFileRevision(null, baseFileVersion);
                    baseFileVersion.setFileRevision(fileRev);
                }
                catch (ReviewsFileStorageException e) {
                    R4EUIPlugin.Ftracer.traceInfo("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }
        }
        if ((targetFileVersion = this.fFile.getTarget()) != null) {
            try {
                IFile targetFile = ResourceUtils.toIFile((String)targetFileVersion.getPlatformURI());
                targetFileVersion.setResource((IResource)targetFile);
            }
            catch (FileNotFoundException e) {
                R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                targetFileVersion.setResource(null);
            }
            targetFileVersion.setFileRevision(null);
            if (revRegistry != null) {
                try {
                    IFileRevision fileRev = revRegistry.getIFileRevision(null, targetFileVersion);
                    targetFileVersion.setFileRevision(fileRev);
                }
                catch (ReviewsFileStorageException e) {
                    R4EUIPlugin.Ftracer.traceInfo("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }
        }
        if (this.fFile.getDeltas().size() > 0) {
            try {
                this.fContentsContainer.open();
            }
            catch (FileNotFoundException e) {
                R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), e);
            }
            catch (ResourceHandlingException e) {
                UIUtils.displayResourceErrorDialog(e);
            }
            catch (CompatibilityException e) {
                UIUtils.displayCompatibilityErrorDialog(e);
            }
        }
        if (this.fFile.getTarget() != null) {
            this.fAnomalies = R4EUIModelController.getAnomaliesForFile(this.fFile.getTarget().getLocalVersionID());
            if (this.fAnomalies != null && this.fAnomalies.size() > 0) {
                this.fAnomalyContainer.open();
            }
        }
        this.fOpen = true;
    }

    @Override
    public void addChildren(IR4EUIModelElement aChildToAdd) {
        if (aChildToAdd instanceof R4EUISelectionContainer) {
            this.fContentsContainer = (R4EUISelectionContainer)aChildToAdd;
        } else if (aChildToAdd instanceof R4EUIDeltaContainer) {
            this.fContentsContainer = (R4EUIDeltaContainer)aChildToAdd;
        } else if (aChildToAdd instanceof R4EUIAnomalyContainer) {
            this.fAnomalyContainer = (R4EUIAnomalyContainer)aChildToAdd;
        } else {
            return;
        }
    }

    @Override
    public void removeChildren(IR4EUIModelElement aChildToRemove, boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        if (aChildToRemove instanceof R4EUIContentsContainer) {
            this.fContentsContainer.removeAllChildren(aFileRemove);
        } else if (aChildToRemove instanceof R4EUIAnomalyContainer) {
            this.fAnomalyContainer.removeAllChildren(aFileRemove);
        }
    }

    @Override
    public void removeAllChildren(boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        this.removeChildren(this.fContentsContainer, aFileRemove);
        this.removeChildren(this.fAnomalyContainer, aFileRemove);
    }

    @Override
    public void restore() throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
        super.restore();
        for (String participant : this.fFile.getAssignedTo()) {
            R4EUIModelController.getActiveReview().getParticipant(participant, true);
        }
        IR4EUIModelElement[] iR4EUIModelElementArray = this.fContentsContainer.getChildren();
        int n = iR4EUIModelElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IR4EUIModelElement content = iR4EUIModelElementArray[n2];
            content.restore();
            ++n2;
        }
    }

    public void verifyUserReviewed() {
        this.fContentsContainer.verifyUserReviewed();
    }

    @Override
    public boolean isAssigned(String aUsername, boolean aCheckChildren) {
        if (this.fFile.isEnabled()) {
            if (this.fFile.getAssignedTo().contains((Object)aUsername)) {
                return true;
            }
            if (aCheckChildren) {
                IR4EUIModelElement[] iR4EUIModelElementArray = this.fContentsContainer.getChildren();
                int n = iR4EUIModelElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IR4EUIModelElement content = iR4EUIModelElementArray[n2];
                    if (content.isAssigned(aUsername, aCheckChildren)) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    public boolean isFileVersionsComparable() {
        return this.fFile.getBase() == null && this.fFile.getTarget() == null || this.fFile.getBase() == null || this.fFile.getTarget() == null || !this.fFile.getBase().getLocalVersionID().equals(this.fFile.getTarget().getLocalVersionID());
    }

    @Override
    public boolean isOpenEditorCmd() {
        return this.isEnabled() && (this.getTargetFileVersion() != null || this.getBaseFileVersion() != null);
    }

    @Override
    public boolean isChangeUserReviewStateCmd() {
        return this.isEnabled() && !this.isReadOnly() && !((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    @Override
    public boolean isAssignToCmd() {
        return this.isEnabled() && !this.isReadOnly() && !((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED);
    }

    @Override
    public boolean isUnassignToCmd() {
        if (this.isEnabled() && !this.isReadOnly() && !((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED) && this.fFile.getAssignedTo().size() > 0) {
            return true;
        }
        IR4EUIModelElement[] iR4EUIModelElementArray = this.fContentsContainer.getChildren();
        int n = iR4EUIModelElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IR4EUIModelElement content = iR4EUIModelElementArray[n2];
            if (content.isUnassignToCmd()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isSendEmailCmd() {
        return true;
    }
}

