/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed;

import java.text.SimpleDateFormat;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EItem;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewItem;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed.ModelElementTabPropertySection;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ReviewItemTabPropertySection
extends ModelElementTabPropertySection {
    private Text fAuthorText = null;
    private Text fAuthorRepText = null;
    private List fProjectIdList = null;
    private Text fRepositoryText = null;
    private Text fDateSubmitted = null;
    protected Text fDescriptionText = null;
    private Composite fAssignedToComposite;
    private Text fAssignedToText;
    private Button fAssignedToButton;
    private Button fUnassignedFromButton;

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory widgetFactory = aTabbedPropertySheetPage.getWidgetFactory();
        Composite composite = widgetFactory.createFlatFormComposite(parent);
        FormData data = null;
        widgetFactory.setBorderStyle(0);
        this.fAuthorText = widgetFactory.createText(composite, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.fAuthorText.setEditable(false);
        this.fAuthorText.setToolTipText("The Participant that Adds this Review Item");
        this.fAuthorText.setLayoutData((Object)data);
        CLabel authorLabel = widgetFactory.createCLabel(composite, "Added By: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fAuthorText, -5);
        data.top = new FormAttachment((Control)this.fAuthorText, 0, 0x1000000);
        authorLabel.setToolTipText("The Participant that Adds this Review Item");
        authorLabel.setLayoutData((Object)data);
        this.fAuthorRepText = widgetFactory.createText(composite, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fAuthorText, 4);
        this.fAuthorRepText.setEditable(false);
        this.fAuthorRepText.setToolTipText("The Email of the Participant that Created the Change");
        this.fAuthorRepText.setLayoutData((Object)data);
        CLabel authorRepLabel = widgetFactory.createCLabel(composite, "Email: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fAuthorRepText, -5);
        data.top = new FormAttachment((Control)this.fAuthorRepText, 0, 0x1000000);
        authorRepLabel.setToolTipText("The Email of the Participant that Created the Change");
        authorRepLabel.setLayoutData((Object)data);
        this.fProjectIdList = widgetFactory.createList(composite, 8);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fAuthorRepText, 4);
        this.fProjectIdList.setToolTipText("The Projects the Children Files of this Review Items belong to");
        this.fProjectIdList.setLayoutData((Object)data);
        CLabel projectIdLabel = widgetFactory.createCLabel(composite, "Project Id: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fProjectIdList, -5);
        data.top = new FormAttachment((Control)this.fProjectIdList, 0, 0x1000000);
        projectIdLabel.setToolTipText("The Projects the Children Files of this Review Items belong to");
        projectIdLabel.setLayoutData((Object)data);
        this.fRepositoryText = widgetFactory.createText(composite, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fProjectIdList, 4);
        this.fRepositoryText.setEditable(false);
        this.fRepositoryText.setToolTipText("The Change ID for this Change, as tagged by the Revision Control System (if applicable)");
        this.fRepositoryText.setLayoutData((Object)data);
        CLabel repositoryLabel = widgetFactory.createCLabel(composite, "Change Id: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fRepositoryText, -5);
        data.top = new FormAttachment((Control)this.fRepositoryText, 0, 0x1000000);
        repositoryLabel.setToolTipText("The Change ID for this Change, as tagged by the Revision Control System (if applicable)");
        repositoryLabel.setLayoutData((Object)data);
        this.fDateSubmitted = widgetFactory.createText(composite, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fRepositoryText, 4);
        this.fDateSubmitted.setEditable(false);
        this.fDateSubmitted.setToolTipText("The Date this Change was put under Source Control  (if applicable)");
        this.fDateSubmitted.setLayoutData((Object)data);
        CLabel dateSubmittedLabel = widgetFactory.createCLabel(composite, "Date Submitted: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fDateSubmitted, -5);
        data.top = new FormAttachment((Control)this.fDateSubmitted, 0, 0x1000000);
        dateSubmittedLabel.setToolTipText("The Date this Change was put under Source Control  (if applicable)");
        dateSubmittedLabel.setLayoutData((Object)data);
        widgetFactory.setBorderStyle(2048);
        this.fDescriptionText = widgetFactory.createText(composite, "", 2);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fDateSubmitted, 4);
        this.fDescriptionText.setToolTipText("A Brief Dexcription of this Review Item.  This can be entered by the User or it could be coming from the Version Control System");
        this.fDescriptionText.setLayoutData((Object)data);
        this.fDescriptionText.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (!ReviewItemTabPropertySection.this.fRefreshInProgress && ReviewItemTabPropertySection.this.fDescriptionText.getForeground().equals((Object)UIUtils.ENABLED_FONT_COLOR)) {
                    try {
                        String currentUser = R4EUIModelController.getReviewer();
                        R4EItem modelItem = ((R4EUIReviewItem)ReviewItemTabPropertySection.this.fProperties.getElement()).getItem();
                        String newValue = ReviewItemTabPropertySection.this.fDescriptionText.getText().trim();
                        if (!newValue.equals(modelItem.getDescription())) {
                            Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelItem, currentUser);
                            modelItem.setDescription(newValue);
                            R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        }
                        ReviewItemTabPropertySection.this.fDescriptionText.setText(newValue);
                    }
                    catch (ResourceHandlingException e1) {
                        UIUtils.displayResourceErrorDialog(e1);
                    }
                    catch (OutOfSyncException e1) {
                        UIUtils.displaySyncErrorDialog(e1);
                    }
                }
            }
        });
        UIUtils.addTabbedPropertiesTextResizeListener(this.fDescriptionText);
        CLabel descriptionLabel = widgetFactory.createCLabel(composite, "Description: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fDescriptionText, -5);
        data.top = new FormAttachment((Control)this.fDescriptionText, 0, 0x1000000);
        descriptionLabel.setToolTipText("A Brief Dexcription of this Review Item.  This can be entered by the User or it could be coming from the Version Control System");
        descriptionLabel.setLayoutData((Object)data);
        this.fAssignedToComposite = widgetFactory.createComposite(composite);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fDescriptionText, 4);
        this.fAssignedToComposite.setToolTipText("Participant assigned to Review this element.");
        this.fAssignedToComposite.setLayoutData((Object)data);
        this.fAssignedToComposite.setLayout((Layout)new GridLayout(3, false));
        this.fAssignedToText = widgetFactory.createText(this.fAssignedToComposite, "");
        this.fAssignedToText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fAssignedToText.setEditable(false);
        this.fAssignedToButton = widgetFactory.createButton(this.fAssignedToComposite, "Add...", 0);
        this.fAssignedToButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fAssignedToButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ((R4EUIReviewItem)ReviewItemTabPropertySection.this.fProperties.getElement()).addAssignees(UIUtils.getAssignParticipants());
                ReviewItemTabPropertySection.this.refresh();
                R4EUIModelController.getNavigatorView().getTreeViewer().refresh();
            }
        });
        this.fUnassignedFromButton = widgetFactory.createButton(this.fAssignedToComposite, "Remove...", 0);
        this.fUnassignedFromButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fUnassignedFromButton.addListener(13, new Listener(){

            public void handleEvent(Event aEvent) {
                ((R4EUIReviewItem)ReviewItemTabPropertySection.this.fProperties.getElement()).removeAssignees(UIUtils.getUnassignParticipants(ReviewItemTabPropertySection.this.fProperties.getElement()));
                ReviewItemTabPropertySection.this.refresh();
                R4EUIModelController.getNavigatorView().getTreeViewer().refresh();
            }
        });
        CLabel assignedToLabel = widgetFactory.createCLabel(composite, "Assigned to: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fAssignedToComposite, -5);
        data.top = new FormAttachment((Control)this.fAssignedToComposite, 0, 0x1000000);
        assignedToLabel.setToolTipText("Participant assigned to Review this element.");
        assignedToLabel.setLayoutData((Object)data);
    }

    public void refresh() {
        if (this.fProperties == null) {
            return;
        }
        this.fRefreshInProgress = true;
        R4EItem modelItem = ((R4EUIReviewItem)this.fProperties.getElement()).getItem();
        this.fAuthorText.setText(modelItem.getAddedById());
        if (modelItem.getAuthorRep() != null) {
            this.fAuthorRepText.setText(modelItem.getAuthorRep());
        } else {
            try {
                R4EParticipant participant = R4EUIModelController.getActiveReview().getParticipant(modelItem.getAddedById(), false);
                if (participant != null) {
                    this.fAuthorRepText.setText(participant.getEmail());
                } else {
                    this.fAuthorRepText.setText("");
                }
            }
            catch (ResourceHandlingException e) {
                R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                this.fAuthorRepText.setText("");
            }
        }
        this.fProjectIdList.setItems((String[])modelItem.getProjectURIs().toArray());
        this.fRepositoryText.setText(modelItem.getRepositoryRef() != null ? modelItem.getRepositoryRef() : "");
        if (modelItem.getSubmitted() != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss");
            this.fDateSubmitted.setText(dateFormat.format(modelItem.getSubmitted()));
        } else {
            this.fDateSubmitted.setText("");
        }
        if (modelItem.getDescription() != null) {
            this.fDescriptionText.setText(modelItem.getDescription());
        } else {
            this.fDescriptionText.setText("");
        }
        EList assignedParticipants = modelItem.getAssignedTo();
        this.fAssignedToText.setText(UIUtils.formatAssignedParticipants((EList<String>)assignedParticipants));
        this.setEnabledFields();
        this.fRefreshInProgress = false;
    }

    protected void setEnabledFields() {
        if (R4EUIModelController.isJobInProgress() || this.fProperties.getElement().isReadOnly() || ((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED) || !this.fProperties.getElement().isEnabled()) {
            this.fAuthorText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fAuthorRepText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fRepositoryText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fDateSubmitted.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fProjectIdList.setEnabled(false);
            this.fDescriptionText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fDescriptionText.setEditable(false);
            this.fAssignedToText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fAssignedToButton.setEnabled(false);
            this.fUnassignedFromButton.setEnabled(false);
        } else {
            this.fAuthorText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fAuthorRepText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fRepositoryText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fDateSubmitted.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fProjectIdList.setEnabled(true);
            this.fDescriptionText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fDescriptionText.setEditable(true);
            this.fAssignedToText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fAssignedToButton.setEnabled(true);
            if (this.fAssignedToText.getText().length() > 0) {
                this.fUnassignedFromButton.setEnabled(true);
            } else {
                this.fUnassignedFromButton.setEnabled(false);
            }
        }
    }
}

