/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.utils;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class OverlayImageIcon
extends CompositeImageDescriptor {
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    private final Image fBaseImage;
    private final Image fOverlayImage;
    private final Point fSizeOfBaseImage;
    private final int fLocation;

    public OverlayImageIcon(Image aBaseImage, Image aOverlayImage, int aLocation) {
        this.fBaseImage = aBaseImage;
        this.fOverlayImage = aOverlayImage;
        this.fSizeOfBaseImage = new Point(this.fBaseImage.getBounds().width, this.fBaseImage.getBounds().height);
        this.fLocation = aLocation;
    }

    protected void drawCompositeImage(int aWidth, int aHeight) {
        this.drawImage(this.fBaseImage.getImageData(), 0, 0);
        switch (this.fLocation) {
            case 0: {
                this.drawImage(this.fOverlayImage.getImageData(), 0, 0);
                break;
            }
            case 1: {
                this.drawImage(this.fOverlayImage.getImageData(), this.fSizeOfBaseImage.x - this.fOverlayImage.getImageData().width, 0);
                break;
            }
            case 2: {
                this.drawImage(this.fOverlayImage.getImageData(), 0, this.fSizeOfBaseImage.y - this.fOverlayImage.getImageData().height);
                break;
            }
            default: {
                this.drawImage(this.fOverlayImage.getImageData(), this.fSizeOfBaseImage.x - this.fOverlayImage.getImageData().width, this.fSizeOfBaseImage.y - this.fOverlayImage.getImageData().height);
            }
        }
    }

    protected Point getSize() {
        return this.fSizeOfBaseImage;
    }

    public Image getImage() {
        return this.createImage();
    }
}

