/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.editors;

import java.net.URI;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class R4EFileRevisionEditorInput
extends PlatformObject
implements IWorkbenchAdapter,
IStorageEditorInput {
    private final R4EFileVersion fFileVersion;

    public R4EFileRevisionEditorInput(R4EFileVersion aFileVersion) {
        Assert.isNotNull((Object)aFileVersion);
        this.fFileVersion = aFileVersion;
    }

    public IStorage getStorage() {
        try {
            if (this.fFileVersion.getFileRevision() != null) {
                return this.fFileVersion.getFileRevision().getStorage(null);
            }
        }
        catch (CoreException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
        }
        return null;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.fFileVersion.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        try {
            if (this.fFileVersion.getFileRevision() != null) {
                return this.fFileVersion.getFileRevision().getStorage(null).getFullPath().toString();
            }
        }
        catch (CoreException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
        }
        return null;
    }

    public Object getAdapter(Class aAdapter) {
        if (IWorkbenchAdapter.class.equals((Object)aAdapter)) {
            return this;
        }
        if (IStorage.class.equals((Object)aAdapter)) {
            try {
                return this.fFileVersion.getFileRevision().getStorage(null);
            }
            catch (CoreException e) {
                R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
            }
        }
        return super.getAdapter(aAdapter);
    }

    public boolean equals(Object aObject) {
        if (aObject == this) {
            return true;
        }
        if (aObject instanceof R4EFileRevisionEditorInput) {
            R4EFileRevisionEditorInput other = (R4EFileRevisionEditorInput)((Object)aObject);
            return other.fFileVersion.equals(this.fFileVersion);
        }
        return false;
    }

    public int hashCode() {
        if (this.fFileVersion.getFileRevision() != null) {
            return this.fFileVersion.getFileRevision().hashCode();
        }
        return this.fFileVersion.hashCode();
    }

    public R4EFileVersion getFileVersion() {
        return this.fFileVersion;
    }

    public URI getURI() {
        if (this.fFileVersion.getFileRevision() != null) {
            return this.fFileVersion.getFileRevision().getURI();
        }
        return null;
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return this.fFileVersion.getFileRevision().getName();
    }

    public Object getParent(Object o) {
        return null;
    }
}

