/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.EditorProxy;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContent;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorTreeViewer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorView;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.UIJob;

public class SelectPreviousHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Selecting Previous Element...";

    public Object execute(ExecutionEvent aEvent) {
        final List<IR4EUIModelElement> selectedElements = UIUtils.getCommandUIElements();
        UIJob job = new UIJob(COMMAND_MESSAGE){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ReviewNavigatorView view;
                IR4EUIModelElement previousElement;
                monitor.beginTask(SelectPreviousHandler.COMMAND_MESSAGE, 1);
                if (selectedElements != null && !selectedElements.isEmpty() && (previousElement = SelectPreviousHandler.this.getPreviousElement((ReviewNavigatorTreeViewer)(view = R4EUIModelController.getNavigatorView()).getTreeViewer())) != null) {
                    R4EUIPlugin.Ftracer.traceInfo("Select previous element " + previousElement.getName());
                    StructuredSelection previousSelection = new StructuredSelection((Object)previousElement);
                    view.getTreeViewer().setSelection((ISelection)previousSelection);
                    if (previousElement instanceof R4EUIFileContext || previousElement instanceof R4EUIContent || previousElement instanceof R4EUIAnomalyBasic) {
                        EditorProxy.openEditor(view.getSite().getPage(), (ISelection)previousSelection, false);
                    }
                }
                monitor.worked(1);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    private IR4EUIModelElement getPreviousElement(ReviewNavigatorTreeViewer aTreeViewer) {
        TreeItem[] item = aTreeViewer.getTree().getSelection();
        if (item.length == 0) {
            return null;
        }
        TreeItem previousItem = aTreeViewer.getPrevious(item[0]);
        return (IR4EUIModelElement)previousItem.getData();
    }
}

