/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.control;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.reviews.frame.ui.annotation.IReviewAnnotation;
import org.eclipse.mylyn.reviews.frame.ui.annotation.impl.ReviewAnnotationInformationControl;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.content.R4EAnnotation;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.content.R4EAnnotationText;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.content.R4ECommentAnnotation;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.control.R4EAnnotationContentProvider;
import org.eclipse.mylyn.reviews.r4e.ui.internal.annotation.control.R4EAnnotationTypeSorter;
import org.eclipse.mylyn.reviews.r4e.ui.internal.commands.ModelContributionItems;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4ECompareEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileRevisionEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorLabelProvider;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.ITextEditor;

public class R4EAnnotationInformationControl
extends ReviewAnnotationInformationControl {
    private IInformationControlCreator fPresenterControlCreator = null;
    private IInformationControlCreator fHoverControlCreator = null;
    private Composite fComposite;
    private TreeViewer fAnnotationTree = null;
    private IWorkbenchPart fPreSelectionActivePart = null;
    private boolean fAutomaticSelection = false;

    public R4EAnnotationInformationControl(Shell aParentShell, String aStatusFieldText) {
        super(aParentShell, aStatusFieldText);
    }

    public R4EAnnotationInformationControl(Shell aParentShell, ToolBarManager aToolBarManager) {
        super(aParentShell, aToolBarManager);
    }

    public void dispose() {
        this.fAnnotationTree.getTree().dispose();
        if (this.fComposite != null) {
            this.fComposite.dispose();
        }
        super.dispose();
    }

    protected void disposeDeferredCreatedContent() {
        ToolBarManager toolBarManager;
        if (this.fComposite != null) {
            Control[] children;
            Control[] controlArray = children = this.fComposite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                element.dispose();
                ++n2;
            }
        }
        if ((toolBarManager = this.getToolBarManager()) != null) {
            toolBarManager.removeAll();
        }
    }

    protected void deferredCreateContent() {
        this.addAnnotationsInformation();
        this.setColorAndFont((Control)this.fComposite, this.fComposite.getParent().getForeground(), this.fComposite.getParent().getBackground(), JFaceResources.getDialogFont());
        this.fComposite.layout(true);
    }

    protected void createContent(Composite aParent) {
        GridLayout layoutParent = new GridLayout(1, false);
        layoutParent.verticalSpacing = 0;
        layoutParent.marginWidth = 0;
        layoutParent.marginHeight = 0;
        aParent.setLayout((Layout)layoutParent);
        this.fComposite = new Composite(aParent, 0);
        GridData data = new GridData(4, 4, true, true);
        this.fComposite.setLayoutData((Object)data);
        GridLayout layoutComposite = new GridLayout(1, false);
        layoutComposite.verticalSpacing = 0;
        layoutComposite.marginWidth = 0;
        layoutComposite.marginHeight = 0;
        this.fComposite.setLayout((Layout)layoutComposite);
    }

    public Point computeSizeHint() {
        Point newSize = super.computeSizeHint();
        if (newSize.x > 600) {
            newSize.x = 600;
        } else if (newSize.x < 200) {
            newSize.x = 200;
        }
        if (newSize.y > 450) {
            newSize.y = 450;
        }
        return newSize;
    }

    protected void updateToolbar(Object aSourceElement) {
        ToolBarManager toolBarManager = this.getToolBarManager();
        if (toolBarManager != null) {
            toolBarManager.removeAll();
            this.addToolbarElementCommands(toolBarManager, aSourceElement);
            toolBarManager.getControl().setData("ANNOTATION_TOOLBAR", (Object)new Boolean(true));
            toolBarManager.update(true);
            Point size = this.computeSizeHint();
            this.setSize(Math.max(size.x, this.getShell().getSize().x), Math.max(size.y, this.getShell().getSize().y));
            this.getShell().redraw();
        }
    }

    protected void addToolbarElementCommands(ToolBarManager aToolBarManager, Object aSourceElement) {
        IContributionItem[] items;
        ModelContributionItems r4eItemsManager = new ModelContributionItems();
        IContributionItem[] iContributionItemArray = items = r4eItemsManager.getContributionItems((IR4EUIModelElement)aSourceElement);
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            aToolBarManager.add(item);
            ++n2;
        }
    }

    protected void addAnnotationsInformation() {
        this.fAnnotationTree = new TreeViewer(this.fComposite, 66314);
        this.fAnnotationTree.setContentProvider((IContentProvider)new R4EAnnotationContentProvider());
        this.fAnnotationTree.setSorter((ViewerSorter)new R4EAnnotationTypeSorter());
        this.fAnnotationTree.setLabelProvider((IBaseLabelProvider)new ReviewNavigatorLabelProvider(){

            public void update(ViewerCell aCell) {
                Object cellContents = aCell.getElement();
                if (cellContents instanceof IReviewAnnotation) {
                    aCell.setText(((IReviewAnnotation)cellContents).getText());
                    Image image = this.getImage((Annotation)cellContents);
                    if (image != null) {
                        aCell.setImage(image);
                    }
                } else if (cellContents instanceof R4EAnnotationText) {
                    aCell.setText(((R4EAnnotationText)cellContents).getText());
                }
            }

            private Image getImage(Annotation aAnnotation) {
                ImageRegistry registry;
                Image image;
                AnnotationPreference preference;
                if (aAnnotation instanceof R4ECommentAnnotation) {
                    return UIUtils.loadIcon(((R4ECommentAnnotation)aAnnotation).getSourceElement().getImageLocation());
                }
                AnnotationPreferenceLookup lookup = EditorsPlugin.getDefault().getAnnotationPreferenceLookup();
                if (lookup != null && (preference = lookup.getAnnotationPreference(aAnnotation)) != null && (image = (registry = EditorsPlugin.getDefault().getImageRegistry()).get(aAnnotation.getType())) != null) {
                    return image;
                }
                return null;
            }
        });
        this.fAnnotationTree.setInput((Object)this.fInput);
        this.fAnnotationTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent aEvent) {
                if (aEvent.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)aEvent.getSelection()).getFirstElement() != null) {
                    Object selectedObject = ((IStructuredSelection)aEvent.getSelection()).getFirstElement();
                    while (selectedObject != null && !(selectedObject instanceof R4EAnnotation)) {
                        selectedObject = ((R4EAnnotationText)selectedObject).getParent();
                    }
                    if (selectedObject != null) {
                        this.selectElementInNavigator((R4EAnnotation)((Object)selectedObject));
                    }
                }
            }

            private void selectElementInNavigator(R4EAnnotation aSelectedAnnotation) {
                IR4EUIModelElement element = aSelectedAnnotation.getSourceElement();
                if (element != null) {
                    R4EAnnotationInformationControl.this.updateToolbar(element);
                    if (R4EUIModelController.getNavigatorView() != null) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        R4EAnnotationInformationControl.this.fPreSelectionActivePart = page.getActivePart();
                        R4EUIModelController.getNavigatorView().updateView(element, 0, false);
                    }
                    if (!R4EAnnotationInformationControl.this.fAutomaticSelection) {
                        this.setHighlightText(aSelectedAnnotation);
                    }
                    R4EAnnotationInformationControl.this.fAutomaticSelection = false;
                }
            }

            private void setHighlightText(R4EAnnotation aAnnotation) {
                IEditorInput input;
                if (R4EAnnotationInformationControl.this.fPreSelectionActivePart != null && R4EAnnotationInformationControl.this.fPreSelectionActivePart instanceof IEditorPart && (input = ((IEditorPart)R4EAnnotationInformationControl.this.fPreSelectionActivePart).getEditorInput()) != null) {
                    Position position;
                    if (input instanceof R4ECompareEditorInput) {
                        UIUtils.selectElementInEditor((R4ECompareEditorInput)input);
                    } else if ((input instanceof R4EFileEditorInput || input instanceof R4EFileRevisionEditorInput) && (position = aAnnotation.getPosition()) != null) {
                        int offset = position.getOffset();
                        int length = position.getLength();
                        if (R4EAnnotationInformationControl.this.fPreSelectionActivePart instanceof ITextEditor) {
                            ((ITextEditor)R4EAnnotationInformationControl.this.fPreSelectionActivePart).selectAndReveal(offset, length);
                            TextSelection selectedText = new TextSelection(offset, length);
                            ((ITextEditor)R4EAnnotationInformationControl.this.fPreSelectionActivePart).getSelectionProvider().setSelection((ISelection)selectedText);
                        }
                    }
                }
            }
        });
        this.fAnnotationTree.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent aEvent) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        Point size = R4EAnnotationInformationControl.this.computeSizeHint();
                        R4EAnnotationInformationControl.this.setSize(size.x, size.y);
                    }
                });
            }

            public void treeCollapsed(TreeExpansionEvent aEvent) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        Point size = R4EAnnotationInformationControl.this.computeSizeHint();
                        R4EAnnotationInformationControl.this.setSize(size.x, size.y);
                    }
                });
            }
        });
        GridData data = new GridData(4, 4, true, true);
        this.fAnnotationTree.getTree().setLayoutData((Object)data);
        if (this.fInput != null && this.fInput.getAnnotations().size() == 1) {
            this.fAutomaticSelection = true;
            StructuredSelection selection = new StructuredSelection(this.fInput.getAnnotations().get(0));
            this.fAnnotationTree.setSelection((ISelection)selection, true);
            this.fAnnotationTree.expandToLevel(2);
        }
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new PresenterControlCreator();
        }
        return this.fPresenterControlCreator;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new HoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.fHoverControlCreator;
    }

    private static final class HoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private final IInformationControlCreator fPresenterControlCreator;

        public HoverControlCreator(IInformationControlCreator aPresenterControlCreator) {
            this.fPresenterControlCreator = aPresenterControlCreator;
        }

        public IInformationControl doCreateInformationControl(Shell aParent) {
            return new R4EAnnotationInformationControl(aParent, EditorsUI.getTooltipAffordanceString()){

                public IInformationControlCreator getInformationPresenterControlCreator() {
                    return HoverControlCreator.this.fPresenterControlCreator;
                }
            };
        }

        public boolean canReuse(IInformationControl aControl) {
            if (!super.canReuse(aControl)) {
                return false;
            }
            if (aControl instanceof IInformationControlExtension4) {
                ((IInformationControlExtension4)aControl).setStatusText(EditorsUI.getTooltipAffordanceString());
            }
            return true;
        }
    }

    private static final class PresenterControlCreator
    extends AbstractReusableInformationControlCreator
    implements IWidgetTokenKeeper {
        private PresenterControlCreator() {
        }

        public IInformationControl doCreateInformationControl(Shell aParent) {
            return new R4EAnnotationInformationControl(aParent, new ToolBarManager(0x800000));
        }

        public boolean requestWidgetToken(IWidgetTokenOwner aOwner) {
            return false;
        }
    }
}

