/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomalyState;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyExtended;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedAnomaly;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewExtended;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;

public class PreviousStateHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Regressing element to its Previous State...";

    public Object execute(ExecutionEvent aEvent) {
        final ISelection selection = R4EUIModelController.getNavigatorView().getTreeViewer().getSelection();
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = R4EUIConstants.R4E_UI_JOB_FAMILY;
            }

            public boolean belongsTo(Object family) {
                return this.familyName.equals(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                    monitor.beginTask(PreviousStateHandler.COMMAND_MESSAGE, ((IStructuredSelection)selection).size());
                    R4EUIModelController.setJobInProgress(true);
                    IR4EUIModelElement element2 = null;
                    for (IR4EUIModelElement element2 : (IStructuredSelection)selection) {
                        R4EAnomalyState newState;
                        R4EReviewPhase newPhase;
                        R4EUIPlugin.Ftracer.traceInfo("Regressing State for element " + element2.getName());
                        if (element2 instanceof R4EUIReviewExtended) {
                            newPhase = ((R4EUIReviewExtended)element2).getPreviousPhase();
                            UIUtils.changeReviewPhase(element2, newPhase);
                        } else if (element2 instanceof R4EUIReviewBasic) {
                            newPhase = ((R4EUIReviewBasic)element2).getPhaseFromString("STARTED");
                            UIUtils.changeReviewPhase(element2, newPhase);
                        } else if (element2 instanceof R4EUIPostponedAnomaly) {
                            try {
                                if (((R4EUIPostponedAnomaly)element2).checkCompatibility()) {
                                    newState = ((R4EUIPostponedAnomaly)element2).getPreviousState();
                                    UIUtils.changeAnomalyState(element2, newState);
                                }
                            }
                            catch (ResourceHandlingException e) {
                                UIUtils.displayResourceErrorDialog(e);
                            }
                            catch (CompatibilityException e) {
                                UIUtils.displayCompatibilityErrorDialog(e);
                            }
                        } else if (element2 instanceof R4EUIAnomalyExtended) {
                            newState = ((R4EUIAnomalyExtended)element2).getPreviousState();
                            UIUtils.changeAnomalyState(element2, newState);
                        }
                        monitor.worked(1);
                        if (!monitor.isCanceled()) continue;
                        R4EUIModelController.setJobInProgress(false);
                        UIUtils.setNavigatorViewFocus(element2, 0);
                        return Status.CANCEL_STATUS;
                    }
                    R4EUIModelController.setJobInProgress(false);
                    UIUtils.setNavigatorViewFocus(element2, 0);
                }
                R4EUIModelController.setJobInProgress(false);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

