/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.editors;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileContextCompareEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileRevisionEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EReviewItemCompareEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIComment;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContent;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewItem;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUITextPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorProxy {
    private static final String DEFAULT_EDITOR_NAME = "org.eclipse.ui.DefaultTextEditor";

    public static IEditorPart openEditor(IWorkbenchPage aPage, ISelection aSelection, boolean aForceSingleEditor) {
        IEditorPart editor = null;
        if (aSelection.isEmpty() || !(aSelection instanceof IStructuredSelection)) {
            return editor;
        }
        IR4EUIModelElement element2 = null;
        IR4EUIPosition position = null;
        R4EUIFileContext context = null;
        for (IR4EUIModelElement element2 : (IStructuredSelection)aSelection) {
            if (!(element2 instanceof IR4EUIModelElement)) continue;
            if (element2 instanceof R4EUIAnomalyBasic) {
                position = ((R4EUIAnomalyBasic)element2).getPosition();
            } else if (element2 instanceof R4EUIComment) {
                position = ((R4EUIAnomalyBasic)((R4EUIComment)element2).getParent()).getPosition();
            } else if (element2 instanceof R4EUIContent) {
                position = ((R4EUIContent)element2).getPosition();
            }
            while (!(element2 instanceof R4EUIFileContext)) {
                if ((element2 = ((IR4EUIModelElement)element2).getParent()) != null) continue;
                return editor;
            }
            context = (R4EUIFileContext)element2;
            if (context.getBaseFileVersion() == null || context.getTargetFileVersion() == null || context.getBaseFileVersion().getVersionID().equals(context.getTargetFileVersion().getVersionID())) {
                aForceSingleEditor = true;
            }
            editor = context.isFileVersionsComparable() && !aForceSingleEditor ? EditorProxy.openCompareEditor(aPage, context) : EditorProxy.openSingleEditor(aPage, context, position);
        }
        return editor;
    }

    public static IEditorPart openReviewItemCompareEditor(IWorkbenchPage aPage, R4EUIReviewItem aTargetItem, R4EUIReviewItem aBaseItem) {
        R4EReviewItemCompareEditorInput input = null;
        IEditorPart editor = EditorProxy.findReusableReviewItemCompareEditor(aPage, aTargetItem, aBaseItem);
        if (editor != null) {
            aPage.activate((IWorkbenchPart)editor);
            if (!UIUtils.selectElementInEditor((R4EReviewItemCompareEditorInput)editor.getEditorInput())) {
                if (editor instanceof IReusableEditor) {
                    aPage.reuseEditor((IReusableEditor)editor, (IEditorInput)new R4EReviewItemCompareEditorInput(aTargetItem, aBaseItem));
                    return editor;
                }
                aPage.closeEditor(editor, true);
            } else {
                return editor;
            }
        }
        input = new R4EReviewItemCompareEditorInput(aTargetItem, aBaseItem);
        R4EUIPlugin.Ftracer.traceInfo("Open compare editor on Review Items " + (aTargetItem != null ? aTargetItem.getItem().getId() : "") + " (Target) and " + (aBaseItem != null ? aBaseItem.getItem().getId() : "") + " (Base)");
        try {
            editor = aPage.openEditor((IEditorInput)input, "org.eclipse.compare.CompareEditor", OpenStrategy.activateOnOpen());
        }
        catch (PartInitException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
        }
        return editor;
    }

    private static IEditorPart openSingleEditor(IWorkbenchPage aPage, R4EUIFileContext aContext, IR4EUIPosition aPosition) {
        R4EFileVersion version;
        IEditorPart editor = null;
        if (aContext.getTargetFileVersion() != null) {
            version = aContext.getTargetFileVersion();
        } else if (aContext.getBaseFileVersion() != null) {
            version = aContext.getBaseFileVersion();
        } else {
            String error = "Base and target file version not found for this review item";
            R4EUIPlugin.Ftracer.traceError("Exception: " + error);
            CoreException exception = new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", error));
            UIUtils.displayCoreErrorDialog(exception, false);
            return editor;
        }
        try {
            PlatformObject editorInput = null;
            editorInput = CommandUtils.useWorkspaceResource(version) ? new R4EFileEditorInput(version) : new R4EFileRevisionEditorInput(version);
            String id = EditorProxy.getEditorId(editorInput.getName(), EditorProxy.getContentType(editorInput.getName(), editorInput.getStorage().getContents()));
            editor = aPage.openEditor((IEditorInput)editorInput, id, OpenStrategy.activateOnOpen());
            ITextOperationTarget target = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
            if (target instanceof SourceViewer) {
                SourceViewer sourceViewer = (SourceViewer)target;
                UIUtils.getSingleAnnotationSupport(sourceViewer, aContext);
            }
            if (editor instanceof ITextEditor && aPosition instanceof R4EUITextPosition) {
                int offset = ((R4EUITextPosition)aPosition).getOffset();
                int length = ((R4EUITextPosition)aPosition).getLength();
                ((ITextEditor)editor).setHighlightRange(offset, length, true);
                TextSelection selectedText = new TextSelection(offset, length);
                ((ITextEditor)editor).getSelectionProvider().setSelection((ISelection)selectedText);
            }
        }
        catch (CoreException e) {
            UIUtils.displayCoreErrorDialog(e);
        }
        return editor;
    }

    private static IEditorPart openCompareEditor(IWorkbenchPage aPage, R4EUIFileContext aContext) {
        R4EFileContextCompareEditorInput input = null;
        IEditorPart editor = EditorProxy.findReusableFileContextCompareEditor(aPage, aContext.getTargetFileVersion(), aContext.getBaseFileVersion());
        if (editor != null) {
            aPage.activate((IWorkbenchPart)editor);
            if (!UIUtils.selectElementInEditor((R4EFileContextCompareEditorInput)editor.getEditorInput())) {
                if (editor instanceof IReusableEditor) {
                    aPage.reuseEditor((IReusableEditor)editor, (IEditorInput)new R4EFileContextCompareEditorInput(aContext));
                    return editor;
                }
                aPage.closeEditor(editor, true);
            } else {
                return editor;
            }
        }
        input = new R4EFileContextCompareEditorInput(aContext);
        R4EUIPlugin.Ftracer.traceInfo("Open compare editor on files " + (aContext.getTargetFileVersion() != null ? aContext.getTargetFileVersion().getName() : "") + " (Target) and " + (aContext.getBaseFileVersion() != null ? aContext.getBaseFileVersion().getName() : "") + " (Base)");
        try {
            editor = aPage.openEditor((IEditorInput)input, "org.eclipse.compare.CompareEditor", OpenStrategy.activateOnOpen());
        }
        catch (PartInitException e) {
            R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), (Exception)((Object)e));
        }
        return editor;
    }

    public static IEditorPart findReusableFileContextCompareEditor(IWorkbenchPage aPage, R4EFileVersion aTargetFile, R4EFileVersion aBaseFile) {
        IEditorReference[] editorRefs = aPage.getEditorReferences();
        IEditorPart part = null;
        R4EFileContextCompareEditorInput input = null;
        IEditorReference[] iEditorReferenceArray = editorRefs;
        int n = editorRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorRef = iEditorReferenceArray[n2];
            part = editorRef.getEditor(false);
            if (part != null && part instanceof IReusableEditor && R4EFileContextCompareEditorInput.class.isInstance(part.getEditorInput())) {
                input = (R4EFileContextCompareEditorInput)part.getEditorInput();
                R4EFileVersion leftVersion = input.getCurrentDiffNode().getTargetVersion();
                R4EFileVersion rightVersion = input.getCurrentDiffNode().getBaseVersion();
                if (leftVersion == null && rightVersion == null) {
                    return null;
                }
                if (leftVersion == null && aTargetFile == null && rightVersion != null && aBaseFile != null && rightVersion.equals(aBaseFile)) {
                    return part;
                }
                if (rightVersion == null && aBaseFile == null && leftVersion != null && aTargetFile != null && leftVersion.equals(aTargetFile)) {
                    return part;
                }
                if (leftVersion != null && rightVersion != null && aBaseFile != null && aTargetFile != null && CommandUtils.isSameFileVersion(leftVersion, aTargetFile) && CommandUtils.isSameFileVersion(rightVersion, aBaseFile)) {
                    return part;
                }
            }
            ++n2;
        }
        return null;
    }

    public static IEditorPart findReusableReviewItemCompareEditor(IWorkbenchPage aPage, R4EUIReviewItem aTargetItem, R4EUIReviewItem aBaseItem) {
        IEditorReference[] editorRefs = aPage.getEditorReferences();
        IEditorPart part = null;
        R4EReviewItemCompareEditorInput input = null;
        IEditorReference[] iEditorReferenceArray = editorRefs;
        int n = editorRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorRef = iEditorReferenceArray[n2];
            part = editorRef.getEditor(false);
            if (part != null && part instanceof IReusableEditor && R4EReviewItemCompareEditorInput.class.isInstance(part.getEditorInput())) {
                input = (R4EReviewItemCompareEditorInput)part.getEditorInput();
                if ((aBaseItem == null || aBaseItem.equals(input.getBaseReviewItem())) && aTargetItem.equals(input.getTargetReviewItem())) {
                    return part;
                }
            }
            ++n2;
        }
        return null;
    }

    public static IEditorPart getReviewItemCompareEditorPart(IWorkbenchPage aPage, R4EUIReviewItem aItem) {
        IEditorReference[] editorRefs = aPage.getEditorReferences();
        IEditorPart part = null;
        R4EReviewItemCompareEditorInput input = null;
        IEditorReference[] iEditorReferenceArray = editorRefs;
        int n = editorRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorRef = iEditorReferenceArray[n2];
            part = editorRef.getEditor(false);
            if (part != null && part instanceof IReusableEditor && R4EReviewItemCompareEditorInput.class.isInstance(part.getEditorInput()) && (aItem.equals((input = (R4EReviewItemCompareEditorInput)part.getEditorInput()).getTargetReviewItem()) || aItem.equals(input.getBaseReviewItem()))) {
                return part;
            }
            ++n2;
        }
        return null;
    }

    public static IEditorPart findReusableEditor(IWorkbenchPage aPage, R4EFileVersion aFileVersion) {
        IEditorReference[] editorRefs = aPage.getEditorReferences();
        IEditorPart part = null;
        IEditorReference[] iEditorReferenceArray = editorRefs;
        int n = editorRefs.length;
        int n2 = 0;
        while (n2 < n) {
            R4EFileVersion fileVersion;
            PlatformObject input;
            IEditorReference editorRef = iEditorReferenceArray[n2];
            part = editorRef.getEditor(false);
            if (part != null && (R4EFileEditorInput.class.isInstance(part.getEditorInput()) ? (input = (R4EFileEditorInput)part.getEditorInput()) != null && (fileVersion = input.getFileVersion()) != null && aFileVersion != null && CommandUtils.isSameFileVersion(fileVersion, aFileVersion) : R4EFileRevisionEditorInput.class.isInstance(part.getEditorInput()) && (input = (R4EFileRevisionEditorInput)part.getEditorInput()) != null && (fileVersion = input.getFileVersion()) != null && aFileVersion != null && CommandUtils.isSameFileVersion(fileVersion, aFileVersion))) {
                return part;
            }
            ++n2;
        }
        return null;
    }

    private static String getEditorId(String aFileName, IContentType aType) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(aFileName, aType);
        String id = null;
        id = descriptor == null || descriptor.isOpenExternal() ? DEFAULT_EDITOR_NAME : descriptor.getId();
        return id;
    }

    private static IContentType getContentType(String aFileName, InputStream aContents) {
        IContentType type = null;
        if (aContents != null) {
            try {
                type = Platform.getContentTypeManager().findContentTypeFor(aContents, aFileName);
            }
            catch (IOException e) {
                R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), e);
            }
        }
        if (type == null) {
            type = Platform.getContentTypeManager().findContentTypeFor(aFileName);
        }
        return type;
    }
}

