/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.configuration;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.launching.EclipseApplicationLaunchConfiguration;
import org.eclipse.rcptt.internal.launching.aut.LaunchInfoCache;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchMonitor;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformInitializer;
import org.eclipse.rcptt.internal.launching.ext.Q7TargetPlatformManager;
import org.eclipse.rcptt.launching.configuration.Activator;
import org.eclipse.rcptt.launching.configuration.LaunchConfigurationUtils;
import org.eclipse.rcptt.launching.events.AutEventManager;
import org.eclipse.rcptt.launching.ext.BundleStart;
import org.eclipse.rcptt.launching.ext.OriginalOrderProperties;
import org.eclipse.rcptt.launching.ext.Q7ExternalLaunchDelegate;
import org.eclipse.rcptt.launching.ext.Q7LaunchDelegateUtils;
import org.eclipse.rcptt.launching.internal.target.TargetPlatformHelper;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.rcptt.launching.target.TargetPlatformManager;
import org.eclipse.rcptt.tesla.core.TeslaLimits;

public class Q7LaunchConfigurationDelegate
extends EclipseApplicationLaunchConfiguration {
    private static final String SECURE_STORAGE_FILE_NAME = "secure_storage";
    private ILaunch launch;

    private ILaunchConfiguration getTargetConfiguration(ILaunchConfiguration configuration) throws CoreException {
        return LaunchConfigurationUtils.findLaunchConfiguration(configuration.getAttribute("target-configuration", ""), "org.eclipse.pde.ui.RuntimeWorkbench");
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block7: {
            this.launch = launch;
            monitor.beginTask("", 2);
            Q7ExtLaunchMonitor waiter = new Q7ExtLaunchMonitor(launch);
            try {
                ILaunchConfiguration targetConfig = this.getTargetConfiguration(configuration);
                String targetConfigName = targetConfig.getName();
                ILaunchConfigurationWorkingCopy configurationWc = configuration.getWorkingCopy();
                configurationWc.setAttributes(targetConfig.getAttributes());
                configurationWc.setAttribute("target-configuration", targetConfigName);
                configurationWc.doSave();
                super.launch(configuration, mode, launch, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                waiter.wait(monitor, TeslaLimits.getAUTStartupTimeout() / 1000);
            }
            catch (CoreException e) {
                waiter.handle((Exception)((Object)e));
                if (e.getStatus().getSeverity() != 8) {
                    throw e;
                }
                waiter.dispose();
                break block7;
            }
            catch (RuntimeException e) {
                try {
                    waiter.handle((Exception)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    waiter.dispose();
                    throw throwable;
                }
            }
            waiter.dispose();
        }
        monitor.done();
    }

    protected void manageLaunch(ILaunch launch) {
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        try {
            Job.getJobManager().join((Object)"q7.clean.bundle.pool.job", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (Exception e1) {
            Q7ExtLaunchingPlugin.status((String)"Failed to wait for bundle pool clear job", (Throwable)e1);
        }
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)configuration);
        String targetName = String.valueOf(configuration.getName()) + " with RCPTT";
        ITargetPlatformHelper helper = Q7TargetPlatformManager.getHelper((String)targetName);
        if (helper == null && (helper = TargetPlatformManager.findTarget((String)targetName, (IProgressMonitor)new SubProgressMonitor(monitor, 1), (boolean)false)) != null && !helper.isResolved()) {
            helper.resolve(monitor);
            if (helper.getStatus().isOK()) {
                Q7TargetPlatformManager.setHelper((String)targetName, (ITargetPlatformHelper)helper);
            }
        }
        if (helper == null || ((TargetPlatformHelper)helper).getTarget() == null) {
            helper = TargetPlatformManager.getCurrentTargetPlatformCopy((String)targetName);
            helper.resolve(monitor);
            IStatus rv = Q7TargetPlatformInitializer.initialize((ITargetPlatformHelper)helper, (IProgressMonitor)monitor);
            if (!rv.isOK()) {
                Activator.getDefault().getLog().log(rv);
            }
            helper.save();
            Q7TargetPlatformManager.setHelper((String)targetName, (ITargetPlatformHelper)helper);
        }
        if (helper != null) {
            info.target = helper;
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    public String[] getVMArguments(ILaunchConfiguration config) throws CoreException {
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)config);
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(super.getVMArguments(config)));
        args.add("-Dq7id=" + this.launch.getAttribute("org.eclipse.rcptt.launching.ATTR_AUT_LAUNCH_ID"));
        args.add("-Dq7EclPort=" + AutEventManager.INSTANCE.getPort());
        IPluginModelBase hook = ((TargetPlatformHelper)info.target).getWeavingHook();
        if (hook == null) {
            throw new CoreException(Q7ExtLaunchingPlugin.status((String)"No org.eclipse.equinox.weaving.hook plugin"));
        }
        args.add("-Dosgi.framework.extensions=reference:file:" + hook.getInstallLocation());
        info.vmArgs = args.toArray(new String[args.size()]);
        return info.vmArgs;
    }

    public String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)configuration);
        if (info.programArgs != null) {
            return info.programArgs;
        }
        ArrayList<String> programArgs = new ArrayList<String>();
        programArgs.addAll(Arrays.asList(super.getProgramArguments(configuration)));
        try {
            File config = new File(this.getConfigDir(configuration), "config.ini");
            OriginalOrderProperties props = new OriginalOrderProperties();
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(config));
            props.load((InputStream)in);
            in.close();
            String targetPlatformProfilePath = ((ITargetPlatformHelper)info.target).getTargetPlatformProfilePath();
            if (targetPlatformProfilePath != null) {
                props.setProperty("osgi.install.area", targetPlatformProfilePath);
            }
            props.setProperty("osgi.bundles", Q7LaunchDelegateUtils.computeOSGiBundles((Map)Q7ExternalLaunchDelegate.getBundlesToLaunch((LaunchInfoCache.CachedInfo)info).latestVersionsOnly));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(config));
            props.store((OutputStream)out, "Configuration File");
            out.close();
        }
        catch (IOException e) {
            throw new CoreException(Q7ExtLaunchingPlugin.status((Throwable)e));
        }
        String override = configuration.getAttribute("override-secure-storage", null);
        if (override == null || "true".equals(override)) {
            programArgs.add("-eclipse.keyring");
            programArgs.add(String.valueOf(this.getConfigDir(configuration).toString()) + '/' + SECURE_STORAGE_FILE_NAME);
        }
        info.programArgs = programArgs.toArray(new String[programArgs.size()]);
        return programArgs.toArray(new String[programArgs.size()]);
    }

    protected void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        super.preLaunchCheck(configuration, launch, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        LaunchInfoCache.CachedInfo info = LaunchInfoCache.getInfo((ILaunchConfiguration)configuration);
        TargetPlatformHelper target = (TargetPlatformHelper)info.target;
        Q7ExternalLaunchDelegate.BundlesToLaunchCollector collector = new Q7ExternalLaunchDelegate.BundlesToLaunchCollector();
        for (Map.Entry entry : Q7LaunchDelegateUtils.getEclipseApplicationModels((EclipseApplicationLaunchConfiguration)this).entrySet()) {
            collector.addInstallationBundle((IPluginModelBase)entry.getKey(), BundleStart.fromModelString((String)((String)entry.getValue())));
        }
        for (ITargetLocation extra : target.getQ7Target().getExtras()) {
            if (!Q7ExternalLaunchDelegate.isQ7BundleContainer((ITargetLocation)extra)) continue;
            TargetBundle[] targetBundleArray = extra.getBundles();
            int n = targetBundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                TargetBundle bundle = targetBundleArray[n2];
                collector.addExtraBundle(bundle);
                ++n2;
            }
        }
        Q7ExternalLaunchDelegate.BundlesToLaunch bundles = collector.getResult();
        Q7ExternalLaunchDelegate.setBundlesToLaunch((LaunchInfoCache.CachedInfo)info, (Q7ExternalLaunchDelegate.BundlesToLaunch)bundles);
        Q7LaunchDelegateUtils.setDelegateFields((EclipseApplicationLaunchConfiguration)this, (Map)bundles.fModels, (Map)bundles.fAllBundles);
    }
}

