/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.internal.launching.ext.Q7UpdateSiteExtensions;
import org.eclipse.rcptt.launching.injection.InjectionConfiguration;
import org.eclipse.rcptt.launching.injection.InjectionFactory;
import org.eclipse.rcptt.launching.injection.UpdateSite;
import org.eclipse.rcptt.launching.internal.target.PDEHelper;
import org.eclipse.rcptt.launching.internal.target.TargetPlatformHelper;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;

public class Q7TargetPlatformInitializer {
    private static final String GMF = "gmf";
    private static final String DRAW2D = "draw2d";
    private static final String GEF = "gef";
    private static final String EMF_FEATURE_GROUP = "org.eclipse.emf.feature.group";
    private static final String EMF_VALIDATION_FEATURE_GROUP = "org.eclipse.emf.validation.feature.group";
    private static final String EMF_TRANSACTION_FEATURE_GROUP = "org.eclipse.emf.transaction.feature.group";
    private static final String EMF_WORKSPACE_FEATURE_GROUP = "org.eclipse.emf.workspace.feature.group";
    public static final String P2_GROUP_FEATURE = "org.eclipse.equinox.p2.type.group";
    public static final String P2_CATEGORY_FEATURE = "org.eclipse.equinox.p2.type.category";

    private static final IStatus createError(String message) {
        return Q7TargetPlatformInitializer.createError(message, null);
    }

    private static final IStatus createError(String message, Throwable error) {
        if (message == null && error != null) {
            message = error.getMessage();
        }
        return new Status(4, "org.eclipse.rcptt.launching.ext", message, error);
    }

    public static IStatus initialize(ITargetPlatformHelper target, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Initialize AUT configuration", 100);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        IStatus rv = target.getStatus();
        if (rv.matches(12)) {
            return rv;
        }
        Map<String, Version> map = target.getVersions();
        Q7Info q7Info = Q7TargetPlatformInitializer.getInfo(target, map);
        monitor.worked(20);
        try {
            IMetadataRepository repository = PDEHelper.safeLoadRepository(q7Info.q7, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
            if (repository == null) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Q7TargetPlatformInitializer.createError("Failed to load repository from " + q7Info.q7);
            }
            InjectionConfiguration injectionConfiguration = Q7TargetPlatformInitializer.createInjectionConfiguration((IProgressMonitor)new NullProgressMonitor(), q7Info, map);
            MultiStatus rv2 = new MultiStatus("org.eclipse.rcptt.launching.ext", 0, "Runtime injection failed for target platform " + target, null);
            if (injectionConfiguration != null) {
                rv2.add(target.applyInjection(injectionConfiguration, (IProgressMonitor)new SubProgressMonitor(monitor, 60)));
                if (rv2.matches(8)) {
                    return rv2;
                }
            }
            if (!rv2.isOK()) {
                return rv2;
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    public static InjectionConfiguration createInjectionConfiguration(IProgressMonitor monitor, Q7Info q7Info, Map<String, Version> map) {
        boolean hasEMF = map.containsKey("EMF");
        boolean hasEMFWorkspace = map.containsKey("EMF Workspace");
        boolean hasEMFTransaction = map.containsKey("EMF Transaction");
        boolean hasEMFValidation = map.containsKey("EMF Validation");
        map.containsKey("GMF");
        InjectionConfiguration injectionConfiguration = InjectionFactory.eINSTANCE.createInjectionConfiguration();
        UpdateSite q7Site = InjectionFactory.eINSTANCE.createUpdateSite();
        q7Site.setUri(q7Info.q7.toString());
        injectionConfiguration.getEntries().add((Object)q7Site);
        UpdateSite aspectsSite = InjectionFactory.eINSTANCE.createUpdateSite();
        aspectsSite.setUri(q7Info.aspectj.toString());
        injectionConfiguration.getEntries().add((Object)aspectsSite);
        UpdateSite q7Deps = InjectionFactory.eINSTANCE.createUpdateSite();
        q7Deps.setUri(q7Info.deps.toString());
        if (!(hasEMF && hasEMFWorkspace && hasEMFTransaction && hasEMFValidation)) {
            if (!hasEMFWorkspace) {
                q7Deps.getUnits().add((Object)EMF_WORKSPACE_FEATURE_GROUP);
            }
            if (!hasEMFTransaction) {
                q7Deps.getUnits().add((Object)EMF_TRANSACTION_FEATURE_GROUP);
            }
            if (!hasEMFValidation) {
                q7Deps.getUnits().add((Object)EMF_VALIDATION_FEATURE_GROUP);
            }
            if (!hasEMF) {
                q7Deps.getUnits().add((Object)EMF_FEATURE_GROUP);
            }
        }
        injectionConfiguration.getEntries().add((Object)q7Deps);
        for (URI extraURI : q7Info.extra) {
            if (monitor.isCanceled()) {
                return null;
            }
            UpdateSite site = InjectionFactory.eINSTANCE.createUpdateSite();
            site.setUri(extraURI.toString());
            site.setAllUnits(true);
            injectionConfiguration.getEntries().add((Object)site);
        }
        return injectionConfiguration;
    }

    private static List<String> collectQ7InstallIDs(IProgressMonitor monitor, boolean hasGEF, boolean hasGMF, IMetadataRepository repository) {
        IQueryResult result = repository.query(QueryUtil.ALL_UNITS, monitor);
        ArrayList<String> q7Units = new ArrayList<String>();
        for (IInstallableUnit unit : result.toSet()) {
            if (Q7TargetPlatformInitializer.hasProperty(unit, P2_GROUP_FEATURE, "true") || Q7TargetPlatformInitializer.hasProperty(unit, P2_CATEGORY_FEATURE, "true")) continue;
            String unitId = unit.getId();
            if (!hasGEF && (unitId.contains(GEF) || unitId.contains(DRAW2D) || unitId.contains(GMF)) || !hasGMF && unitId.contains(GMF)) continue;
            q7Units.add(unitId);
        }
        return q7Units;
    }

    public static void logError(TargetPlatformHelper info) {
        Q7ExtLaunchingPlugin.log((IStatus)new MultiStatus("org.eclipse.rcptt.launching.ext", 0, new IStatus[]{info.getStatus()}, "Target platform initialization error", null));
    }

    public static Q7Info getInfo(ITargetPlatformHelper target, Map<String, Version> versions) throws CoreException {
        Map<String, Version> map = versions;
        MultiStatus status = new MultiStatus("org.eclipse.rcptt.launching.ext", 0, "Invalid eclipse product location: " + target.getTargetPlatformProfilePath(), null);
        Version platform = map.get("Version");
        Version osgi = map.get("OSGI");
        if (platform == null) {
            status.add(Q7TargetPlatformInitializer.createError("Failed to detect platform version"));
        }
        if (osgi == null) {
            status.add(Q7TargetPlatformInitializer.createError("Failed to detect OSGI version"));
        }
        if (!status.isOK()) {
            throw new CoreException((IStatus)status);
        }
        return Q7TargetPlatformInitializer.collectQ7Information(platform, osgi);
    }

    public static Q7Info collectQ7Information(Version platform, Version osgi) {
        Collection<Q7UpdateSiteExtensions.Q7RuntimeInfo> updates = Q7UpdateSiteExtensions.getDefault().getRuntimes();
        URI q7 = null;
        URI aspectj = null;
        URI deps = null;
        ImmutableList.Builder extra = ImmutableList.builder();
        for (Q7UpdateSiteExtensions.Q7RuntimeInfo q7RuntimeInfo : updates) {
            boolean platformValid = q7RuntimeInfo.version.isIncluded(platform);
            boolean osgiValid = q7RuntimeInfo.version.isIncluded(osgi);
            if (platformValid) {
                if ("runtime".equals(q7RuntimeInfo.kind)) {
                    if (q7 != null) {
                        throw new IllegalStateException("Multiple runtime providers for platform " + platform);
                    }
                    q7 = q7RuntimeInfo.path;
                } else if ("dependency".equals(q7RuntimeInfo.kind)) {
                    if (deps != null) {
                        throw new IllegalStateException("Multiple dependencies providers for platform " + platform);
                    }
                    deps = q7RuntimeInfo.path;
                } else if ("extra".equals(q7RuntimeInfo.kind)) {
                    extra.add((Object)q7RuntimeInfo.path);
                }
            }
            if (!osgiValid || !"aspectj".equals(q7RuntimeInfo.kind)) continue;
            aspectj = q7RuntimeInfo.path;
        }
        if (q7 == null) {
            throw new NullPointerException("Can't find runtime for platform " + platform);
        }
        if (deps == null) {
            throw new NullPointerException("Can't find dependencies for platform " + platform);
        }
        if (aspectj == null) {
            throw new NullPointerException("Can't find aspectj for osgi " + osgi);
        }
        return new Q7Info(q7, aspectj, deps, (List<URI>)extra.build());
    }

    public static boolean hasProperty(IInstallableUnit unit, String prop, String value) {
        return unit.getProperties().containsKey(prop) && ((String)unit.getProperties().get(prop)).equals(value);
    }

    public static InjectionConfiguration getAspectJInjection(Q7Info q7Info, IProgressMonitor progressMonitor) throws CoreException {
        InjectionConfiguration injectionConfiguration = InjectionFactory.eINSTANCE.createInjectionConfiguration();
        UpdateSite aspectsSite = InjectionFactory.eINSTANCE.createUpdateSite();
        aspectsSite.setUri(q7Info.aspectj.toString());
        injectionConfiguration.getEntries().add((Object)aspectsSite);
        return injectionConfiguration;
    }

    public static class Q7Info {
        public final URI q7;
        public final URI aspectj;
        public final URI deps;
        public final List<URI> extra;

        public Q7Info(URI q7, URI aspectj, URI deps, List<URI> extra) {
            Preconditions.checkArgument((q7 != null ? 1 : 0) != 0);
            Preconditions.checkArgument((aspectj != null ? 1 : 0) != 0);
            Preconditions.checkArgument((deps != null ? 1 : 0) != 0);
            this.q7 = q7;
            this.aspectj = aspectj;
            this.deps = deps;
            this.extra = extra == null ? Collections.emptyList() : extra;
        }
    }
}

