/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runner.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rcptt.runner.HeadlessRunnerPlugin;
import org.eclipse.rcptt.runner.RunnerConfiguration;
import org.eclipse.rcptt.runner.util.AutThread;
import org.eclipse.rcptt.runner.util.TestResult;

public class ResultsHandler {
    public List<TestResult> results = new ArrayList<TestResult>();
    private Map<AutThread, Integer> timeoutCount = new HashMap<AutThread, Integer>();
    private RunnerConfiguration conf;
    private final boolean autRestartOnFailures;

    public ResultsHandler(RunnerConfiguration conf, boolean restartAUTOnFailures) {
        this.conf = conf;
        this.autRestartOnFailures = restartAUTOnFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompleted(TestResult result, AutThread thread) throws CoreException, InterruptedException {
        Integer timeoutC = null;
        List<TestResult> list = this.results;
        synchronized (list) {
            this.results.add(result.withAdditionalInfo(this.conf, thread));
            if (thread != null) {
                timeoutC = this.timeoutCount.get(thread);
                if (timeoutC == null) {
                    timeoutC = 0;
                }
                timeoutC = result.timeout ? Integer.valueOf(timeoutC + 1) : Integer.valueOf(0);
                this.timeoutCount.put(thread, timeoutC);
            }
        }
        if (result.connectionUnavailable) {
            ResultsHandler.restartAutWithMessage(thread, "Connection to AUT is not available.");
        } else if (this.autRestartOnFailures && result.failed) {
            ResultsHandler.restartAutWithMessage(thread, "Test is failed and restartAUTOnFailure=true test option is specified.");
        } else if (timeoutC != null && timeoutC >= this.conf.timeoutRestart) {
            this.timeoutCount.put(thread, 0);
            ResultsHandler.restartAutWithMessage(thread, "Possible AUT hang detected, " + timeoutC + " tests are failed because of timeout.");
        }
    }

    private static void restartAutWithMessage(AutThread thread, String msg) throws CoreException, InterruptedException {
        ResultsHandler.log("\n\n" + msg + " Restarting AUT.\n\n", null);
        thread.restart();
    }

    static void log(String msg, Throwable e) {
        HeadlessRunnerPlugin.getDefault().info(msg, e);
        System.out.println(msg);
    }
}

