/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.typehierarchy.HistoryAction;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class HistoryListAction
extends Action {
    private TypeHierarchyViewPart fView;

    public HistoryListAction(TypeHierarchyViewPart view) {
        this.fView = view;
        this.setText(TypeHierarchyMessages.HistoryListAction_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.history_list_action");
    }

    public void run() {
        List<IJavaElement[]> historyEntries = this.fView.getHistoryEntries();
        IJavaElement[][] entries = (IJavaElement[][])historyEntries.toArray((T[])new IJavaElement[historyEntries.size()][]);
        HistoryListDialog dialog = new HistoryListDialog(JavaPlugin.getActiveWorkbenchShell(), entries);
        if (dialog.open() == 0) {
            this.fView.setHistoryEntries(dialog.getRemaining());
            this.fView.setInputElements(dialog.getResult());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HistoryListDialog
    extends StatusDialog {
        private ListDialogField<IJavaElement[]> fHistoryList;
        private IStatus fHistoryStatus;
        private IJavaElement[] fResult;

        private HistoryListDialog(Shell shell, IJavaElement[][] elements) {
            super(shell);
            this.setTitle(TypeHierarchyMessages.HistoryListDialog_title);
            String[] buttonLabels = new String[]{TypeHierarchyMessages.HistoryListDialog_remove_button};
            IListAdapter<IJavaElement[]> adapter = new IListAdapter<IJavaElement[]>(){

                @Override
                public void customButtonPressed(ListDialogField<IJavaElement[]> field, int index) {
                    HistoryListDialog.this.doCustomButtonPressed();
                }

                @Override
                public void selectionChanged(ListDialogField<IJavaElement[]> field) {
                    HistoryListDialog.this.doSelectionChanged();
                }

                @Override
                public void doubleClicked(ListDialogField<IJavaElement[]> field) {
                    HistoryListDialog.this.doDoubleClicked();
                }
            };
            JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(1088){

                public StyledString getStyledText(Object element) {
                    IJavaElement[] elem = (IJavaElement[])element;
                    if (elem.length == 1) {
                        return HistoryAction.getSingleElementLabel(elem[0]);
                    }
                    return new StyledString(HistoryAction.getElementLabel(elem));
                }

                public String getText(Object element) {
                    IJavaElement[] elem = (IJavaElement[])element;
                    return HistoryAction.getElementLabel(elem);
                }

                public Image getImage(Object element) {
                    IJavaElement[] elem = (IJavaElement[])element;
                    return super.getImage(elem[0]);
                }
            };
            this.fHistoryList = new ListDialogField<IJavaElement[]>(adapter, buttonLabels, (ILabelProvider)labelProvider);
            this.fHistoryList.setLabelText(TypeHierarchyMessages.HistoryListDialog_label);
            this.fHistoryList.setElements(Arrays.asList(elements));
            StructuredSelection sel = elements.length > 0 ? new StructuredSelection(elements[0]) : new StructuredSelection();
            this.fHistoryList.selectElements((ISelection)sel);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite inner = new Composite(composite, 0);
            inner.setFont(parent.getFont());
            inner.setLayoutData((Object)new GridData(1808));
            LayoutUtil.doDefaultLayout(inner, new DialogField[]{this.fHistoryList}, true, 0, 0);
            LayoutUtil.setHeightHint(this.fHistoryList.getListControl(null), this.convertHeightInCharsToPixels(12));
            LayoutUtil.setHorizontalGrabbing(this.fHistoryList.getListControl(null));
            HistoryListDialog.applyDialogFont((Control)composite);
            return composite;
        }

        private void doCustomButtonPressed() {
            this.fHistoryList.removeElements(this.fHistoryList.getSelectedElements());
        }

        private void doDoubleClicked() {
            if (this.fHistoryStatus.isOK()) {
                this.okPressed();
            }
        }

        private void doSelectionChanged() {
            StatusInfo status = new StatusInfo();
            List<IJavaElement[]> selected = this.fHistoryList.getSelectedElements();
            if (selected.size() != 1) {
                status.setError("");
                this.fResult = null;
            } else {
                this.fResult = selected.get(0);
            }
            this.fHistoryList.enableButton(0, this.fHistoryList.getSize() > selected.size() && selected.size() != 0);
            this.fHistoryStatus = status;
            this.updateStatus(status);
        }

        public IJavaElement[] getResult() {
            return this.fResult;
        }

        public List<IJavaElement[]> getRemaining() {
            List<IJavaElement[]> elems = this.fHistoryList.getElements();
            return elems;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.ui.history_list_dialog_context");
        }
    }
}

