/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.protocol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.tesla.core.protocol.BooleanResponse;
import org.eclipse.rcptt.tesla.core.protocol.IUIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.MultiSelectionItem;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.SetSelection;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.core.protocol.raw.ResponseStatus;

public class UISetSelector {
    private IUIPlayer player;
    private Element parent;
    private List<String> path;
    private List<List<String>> additionalSelections;

    public UISetSelector(IUIPlayer player) {
        this.player = player;
    }

    protected UISetSelector(UISetSelector sel) {
        this(sel.player);
        this.parent = sel.parent;
        if (sel.path != null) {
            this.path = new ArrayList<String>(sel.path);
        }
        if (sel.additionalSelections != null) {
            this.additionalSelections = new ArrayList<List<String>>(sel.additionalSelections);
        }
    }

    public UISetSelector parent(Element parent) {
        if (parent == null && this.parent == null) {
            return this;
        }
        UISetSelector ns = this.createClone();
        ns.parent = parent;
        return ns;
    }

    public UISetSelector path(String ... path) {
        UISetSelector ns = this.createClone();
        ns.path = path != null ? Arrays.asList(path) : null;
        return ns;
    }

    public UISetSelector pathList(List<String> path) {
        UISetSelector ns = this.createClone();
        ns.path = path;
        return ns;
    }

    public UISetSelector part(String path) {
        if (path == null) {
            return this;
        }
        UISetSelector ns = this.createClone();
        if (ns.path == null) {
            ns.path = new ArrayList<String>();
        }
        ns.path.add(path);
        return ns;
    }

    public UISetSelector additional(String ... path) {
        if (path == null || path.length == 0) {
            return this;
        }
        UISetSelector ns = this.createClone();
        if (ns.additionalSelections == null) {
            ns.additionalSelections = new ArrayList<List<String>>();
        }
        ns.additionalSelections.add(Arrays.asList(path));
        return ns;
    }

    public UISetSelector additionalPathList(List<String> path) {
        if (path == null || path.isEmpty()) {
            return this;
        }
        UISetSelector ns = this.createClone();
        if (ns.additionalSelections == null) {
            ns.additionalSelections = new ArrayList<List<String>>();
        }
        ns.additionalSelections.add(path);
        return ns;
    }

    public boolean select() {
        return this.select(null, null, false);
    }

    public boolean select(boolean all) {
        return this.select(null, null, all);
    }

    public boolean select(Integer index) {
        return this.select(null, index, false);
    }

    public boolean select(String pattern) {
        return this.select(pattern, null, false);
    }

    public boolean select(String pattern, Integer index, boolean all) {
        SetSelection sel = this.createSetSelection();
        this.initSetSelection(sel, all);
        Response executeCommand = this.player.safeExecuteCommand(sel);
        if (executeCommand == null) {
            return true;
        }
        if (executeCommand.getStatus().equals((Object)ResponseStatus.FAILED)) {
            return false;
        }
        return ((BooleanResponse)executeCommand).isResult();
    }

    protected UISetSelector createClone() {
        return new UISetSelector(this);
    }

    protected SetSelection createSetSelection() {
        return ProtocolFactory.eINSTANCE.createSetSelection();
    }

    protected void initSetSelection(SetSelection sel, boolean all) {
        if (this.path != null) {
            sel.getPath().addAll(this.path);
        }
        sel.setElement(this.parent != null ? (Element)EcoreUtil.copy((EObject)this.parent) : null);
        EList<MultiSelectionItem> list = sel.getAdditionalItems();
        if (this.additionalSelections != null) {
            for (List<String> item : this.additionalSelections) {
                MultiSelectionItem msItem = ProtocolFactory.eINSTANCE.createMultiSelectionItem();
                msItem.getPath().addAll(item);
                list.add((Object)msItem);
            }
        }
        sel.setAll(all);
    }
}

