/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.delete;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.Resources;
import org.eclipse.ltk.internal.core.refactoring.resource.DeleteResourcesProcessor;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.BackReferencesProjectScope;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.refactoring.ResourceAccessChange;
import org.eclipse.rcptt.ui.refactoring.delete.DeleteContextReferenceChange;
import org.eclipse.rcptt.ui.refactoring.delete.DeleteTestReferenceChange;
import org.eclipse.rcptt.ui.refactoring.delete.DeleteVerificationReferenceChange;
import org.eclipse.rcptt.ui.utils.WriteAccessChecker;
import org.eclipse.ui.internal.UIPlugin;

public class DeleteQ7ElementProcessor
extends DeleteResourcesProcessor {
    private final IResource[] resources;
    private final Map<IQ7NamedElement, IQ7Element[]> references = new HashMap<IQ7NamedElement, IQ7Element[]>();
    private int referencesCount;
    private boolean deleteReferences = true;

    public DeleteQ7ElementProcessor(IResource[] resources) {
        super(resources);
        this.resources = resources;
        try {
            UIPlugin.getDefault().getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)new ReferenceCollector());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int countReferences(IResource[] resources, IResource[] toDelete) {
        int counter = 0;
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7Element element;
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile && resource.isAccessible() && RcpttCore.isQ7File((IPath)resource.getFullPath()) && (element = RcpttCore.create((IResource)resource)) != null) {
                counter += this.resolveReferences(element, toDelete);
            }
            if (resource instanceof IContainer && resource.isAccessible()) {
                try {
                    IResource[] members = ((IContainer)resource).members();
                    counter += this.countReferences(members, toDelete);
                }
                catch (CoreException e) {
                    Q7UIPlugin.log(e);
                }
            }
            ++n2;
        }
        return counter;
    }

    private List<IQ7NamedElement> computeRealUsage(IQ7NamedElement[] persistedUsage, IQ7NamedElement[] unsavedUsage, IResource[] ignoredResources) {
        IQ7NamedElement e;
        ArrayList<IQ7NamedElement> result = new ArrayList<IQ7NamedElement>(persistedUsage.length + unsavedUsage.length);
        HashSet<IPath> unsavedSet = new HashSet<IPath>();
        IQ7NamedElement[] iQ7NamedElementArray = unsavedUsage;
        int n = unsavedUsage.length;
        int n2 = 0;
        while (n2 < n) {
            e = iQ7NamedElementArray[n2];
            unsavedSet.add(e.getPath());
            ++n2;
        }
        if (persistedUsage != null) {
            iQ7NamedElementArray = persistedUsage;
            n = persistedUsage.length;
            n2 = 0;
            while (n2 < n) {
                e = iQ7NamedElementArray[n2];
                if (!this.isToBeDeleted(e.getResource(), ignoredResources) && !unsavedSet.contains(e.getPath())) {
                    result.add(e);
                }
                ++n2;
            }
        }
        iQ7NamedElementArray = unsavedUsage;
        n = unsavedUsage.length;
        n2 = 0;
        while (n2 < n) {
            e = iQ7NamedElementArray[n2];
            if (!this.isToBeDeleted(e.getResource(), ignoredResources)) {
                result.add(e);
            }
            ++n2;
        }
        return result;
    }

    private int resolveReferences(IQ7Element element, IResource[] ignore) {
        if (element instanceof IContext) {
            try {
                IContext ctx = (IContext)element;
                List<IQ7NamedElement> realUsage = this.computeRealUsage(Q7SearchCore.findContextUsage((String)ctx.getID(), (ISearchScope)new BackReferencesProjectScope(element.getQ7Project()), (IProgressMonitor)new NullProgressMonitor()), ModelManager.getModelManager().findContextUsageInWorkingCopies(ctx.getID(), (ISearchScope)new BackReferencesProjectScope(element.getQ7Project())), ignore);
                if (realUsage.size() > 0) {
                    this.references.put((IQ7NamedElement)ctx, (IQ7Element[])realUsage.toArray(new IQ7NamedElement[realUsage.size()]));
                }
                return realUsage.size();
            }
            catch (ModelException e) {
                Q7UIPlugin.log(e);
            }
        } else if (element instanceof IVerification) {
            try {
                IQ7NamedElement namedElement = (IQ7NamedElement)element;
                List<IQ7NamedElement> realUsage = this.computeRealUsage(Q7SearchCore.findVerificationUsage((String)namedElement.getID(), (ISearchScope)new BackReferencesProjectScope(element.getQ7Project()), (IProgressMonitor)new NullProgressMonitor()), ModelManager.getModelManager().findVerificationUsageInWorkingCopies(namedElement.getID(), (ISearchScope)new BackReferencesProjectScope(element.getQ7Project())), ignore);
                if (realUsage.size() > 0) {
                    this.references.put(namedElement, (IQ7Element[])realUsage.toArray(new IQ7NamedElement[realUsage.size()]));
                }
                return realUsage.size();
            }
            catch (ModelException e) {
                Q7UIPlugin.log(e);
            }
        } else if (element instanceof ITestCase || element instanceof ITestSuite) {
            try {
                ITestSuite[] testSuites = Q7SearchCore.findAllTestSuites((ISearchScope)new BackReferencesProjectScope(element.getQ7Project()));
                List<Object> realUsage = new ArrayList();
                String elementID = ((IQ7NamedElement)element).getID();
                ITestSuite[] iTestSuiteArray = testSuites;
                int n = testSuites.length;
                int n2 = 0;
                while (n2 < n) {
                    ITestSuite suite = iTestSuiteArray[n2];
                    IQ7NamedElement[] iQ7NamedElementArray = Q7SearchCore.getTestSuiteContent((ITestSuite)suite);
                    int n3 = iQ7NamedElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IQ7NamedElement testSuiteElement = iQ7NamedElementArray[n4];
                        if (testSuiteElement instanceof IQ7NamedElement && elementID.equals(testSuiteElement.getID()) && !this.isToBeDeleted(suite.getResource(), ignore)) {
                            realUsage.add(suite);
                        }
                        ++n4;
                    }
                    ++n2;
                }
                IQ7NamedElement[] unsavedUsage = element instanceof ITestCase ? ModelManager.getModelManager().findTestCaseUsageInWorkingCopies(elementID, (ISearchScope)new BackReferencesProjectScope(element.getQ7Project())) : ModelManager.getModelManager().findTestSuiteUsageInWorkingCopies(elementID, (ISearchScope)new BackReferencesProjectScope(element.getQ7Project()));
                if ((realUsage = this.computeRealUsage(realUsage.toArray(new IQ7NamedElement[0]), unsavedUsage, ignore)).size() > 0) {
                    this.references.put((IQ7NamedElement)element, (IQ7Element[])realUsage.toArray(new IQ7NamedElement[realUsage.size()]));
                }
                return realUsage.size();
            }
            catch (ModelException e) {
                Q7UIPlugin.log(e);
            }
        }
        return 0;
    }

    private boolean isToBeDeleted(IResource resource, IResource[] toDelete) {
        if (resource != null) {
            IPath resourcePath = resource.getFullPath();
            IResource[] iResourceArray = toDelete;
            int n = toDelete.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resourceToDelete = iResourceArray[n2];
                if (resourceToDelete.getFullPath().isPrefixOf(resourcePath)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public IResource[] getResources() {
        return this.resources;
    }

    public Object[] getReferencedElements() {
        Set<IQ7NamedElement> keys = this.references.keySet();
        if (keys != null) {
            return keys.toArray();
        }
        return null;
    }

    public Object[] getReferencingElements(Object object) {
        return this.references.get(object);
    }

    public int getReferencesCount() {
        return this.referencesCount;
    }

    public boolean isDeleteReferences() {
        return this.deleteReferences;
    }

    public void setDeleteReferences(boolean deleteReferences) {
        this.deleteReferences = deleteReferences;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus status = super.checkInitialConditions(pm);
        if (!status.isOK()) {
            return status;
        }
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (Map.Entry<IQ7NamedElement, IQ7Element[]> entry : this.references.entrySet()) {
            IQ7Element[] iQ7ElementArray = entry.getValue();
            int n = iQ7ElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IQ7Element element = iQ7ElementArray[n2];
                resources.add(element.getResource());
                ++n2;
            }
        }
        return RefactoringStatus.create((IStatus)Resources.checkInSync((IResource[])resources.toArray(new IResource[resources.size()])));
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (this.deleteReferences) {
            pm.beginTask("", this.references.size() + 1);
            try {
                Change deleteChange = super.createChange(pm);
                pm.worked(1);
                CompositeChange change = new CompositeChange(Messages.DeleteContextProcessor_ChangeName);
                change.markAsSynthetic();
                for (Map.Entry<IQ7NamedElement, IQ7Element[]> entry : this.references.entrySet()) {
                    IQ7Element[] iQ7ElementArray = entry.getValue();
                    int n = iQ7ElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IQ7Element element = iQ7ElementArray[n2];
                        IQ7Element parent = element.getParent();
                        this.checkParentResourceAccess(change, parent.getResource());
                        if (WriteAccessChecker.isReadOnly(element)) {
                            change.add((Change)new ResourceAccessChange(element.getResource(), true));
                        }
                        if (entry.getKey() instanceof IContext) {
                            IContext ctx = (IContext)entry.getKey();
                            change.add((Change)new DeleteContextReferenceChange(element, ctx, ctx.getID()));
                        } else if (entry.getKey() instanceof IVerification) {
                            IVerification verification = (IVerification)entry.getKey();
                            change.add((Change)new DeleteVerificationReferenceChange(element, verification, verification.getID()));
                        } else {
                            change.add((Change)new DeleteTestReferenceChange((ITestSuite)element, entry.getKey()));
                        }
                        pm.worked(1);
                        ++n2;
                    }
                }
                IResource[] iResourceArray = this.resources;
                int n = this.resources.length;
                int n3 = 0;
                while (n3 < n) {
                    IResource recource = iResourceArray[n3];
                    IContainer parent = recource.getParent();
                    if (parent != null && WriteAccessChecker.isReadOnly((IResource)parent)) {
                        change.add((Change)new ResourceAccessChange((IResource)parent, true));
                    }
                    ++n3;
                }
                change.add(deleteChange);
                CompositeChange compositeChange = change;
                return compositeChange;
            }
            finally {
                pm.done();
            }
        }
        CompositeChange deleteChange = (CompositeChange)super.createChange(pm);
        CompositeChange change = new CompositeChange(deleteChange.getName());
        IResource[] iResourceArray = this.resources;
        int n = this.resources.length;
        int n4 = 0;
        while (n4 < n) {
            IResource recource = iResourceArray[n4];
            IContainer parent = recource.getParent();
            this.checkParentResourceAccess(change, (IResource)parent);
            ++n4;
        }
        change.merge(deleteChange);
        return change;
    }

    private void checkParentResourceAccess(CompositeChange change, IResource parent) {
        if (parent != null && WriteAccessChecker.isReadOnly(parent)) {
            boolean exists = false;
            ResourceAccessChange changeParent = new ResourceAccessChange(parent, true);
            Change[] changeArray = change.getChildren();
            int n = changeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Change child = changeArray[n2];
                if (child.getModifiedElement().equals(changeParent.getModifiedElement())) {
                    exists = true;
                    break;
                }
                ++n2;
            }
            if (!exists) {
                change.add((Change)changeParent);
            }
        }
    }

    private class ReferenceCollector
    implements IRunnableWithProgress {
        private ReferenceCollector() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(Messages.DeleteContextWizard_ProgressText, -1);
            DeleteQ7ElementProcessor.this.referencesCount = DeleteQ7ElementProcessor.this.countReferences(DeleteQ7ElementProcessor.this.resources, DeleteQ7ElementProcessor.this.resources);
            monitor.done();
        }
    }
}

