/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runner.util;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.launching.launcher.VMHelper;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.aut.BaseAutLaunch;
import org.eclipse.rcptt.internal.launching.ext.JDTUtils;
import org.eclipse.rcptt.internal.launching.ext.OSArchitecture;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.internal.launching.ext.UpdateVMArgs;
import org.eclipse.rcptt.launching.Aut;
import org.eclipse.rcptt.launching.AutLaunchState;
import org.eclipse.rcptt.launching.AutManager;
import org.eclipse.rcptt.launching.ext.Q7LaunchDelegateUtils;
import org.eclipse.rcptt.launching.ext.Q7LaunchingUtil;
import org.eclipse.rcptt.launching.rap.RAPLaunchConfig;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.rcptt.launching.utils.AUTLaunchArgumentsHelper;
import org.eclipse.rcptt.runner.HeadlessRunner;
import org.eclipse.rcptt.runner.HeadlessRunnerPlugin;
import org.eclipse.rcptt.runner.PrintStreamMonitor;
import org.eclipse.rcptt.runner.RunnerConfiguration;
import org.eclipse.rcptt.runner.ScenarioRunnable;
import org.eclipse.rcptt.runner.util.AUTsManager;
import org.eclipse.rcptt.runner.util.TargetPlatformChecker;
import org.eclipse.rcptt.util.StringUtils;

public class AutThread
extends Thread {
    public BaseAutLaunch launch;
    public final int autId;
    public int restartId = 0;
    private String outFilePath;
    private boolean cancel = false;
    private final List<ScenarioRunnable> runnables;
    private ScenarioRunnable currentRunnable = null;
    private final AUTsManager manager;
    private final RunnerConfiguration conf;
    private final TargetPlatformChecker tpc;

    public AutThread(List<ScenarioRunnable> r, AUTsManager manager, RunnerConfiguration conf, TargetPlatformChecker tpc) {
        super("AUT-Worker-" + manager.autCounter.get());
        this.autId = manager.autCounter.getAndIncrement();
        this.outFilePath = String.format("%s%d_console.log", conf.autConsolePrefix == null ? ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().getParentFile().getAbsolutePath() : conf.autConsolePrefix, this.autId);
        this.runnables = r;
        this.manager = manager;
        this.conf = conf;
        this.tpc = tpc;
    }

    private void checkAut() throws InterruptedException, CoreException {
        if (this.launch == null) {
            throw new RuntimeException("AUT is not available");
        }
        if (!AutLaunchState.ACTIVE.equals((Object)this.launch.getState())) {
            HeadlessRunnerPlugin.getDefault().info("AUT is not active, restarting..");
            this.restart();
        } else {
            long startTime = System.currentTimeMillis();
            while (true) {
                try {
                    this.launch.ping();
                }
                catch (CoreException coreException) {
                    long currentTime = System.currentTimeMillis();
                    if (currentTime > startTime + (long)(this.conf.waitAutTimeout * 1000)) {
                        HeadlessRunnerPlugin.getDefault().info("AUT is not answering, restarting..");
                        this.restart();
                        break;
                    }
                    AutThread.sleep(100L);
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.runnables.isEmpty() && !this.cancel) {
                this.checkAut();
                List<ScenarioRunnable> list = this.runnables;
                synchronized (list) {
                    this.currentRunnable = this.runnables.remove(0);
                }
                if (this.currentRunnable == null) continue;
                this.currentRunnable.run(this);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CoreException e) {
            HeadlessRunnerPlugin.log(e.getStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ILaunchConfiguration createAUTLaunchConfiguration(String autWorkspace, int index) throws CoreException {
        AUTsManager aUTsManager = this.manager;
        synchronized (aUTsManager) {
            ILaunchConfigurationWorkingCopy config;
            String autArgs = Q7LaunchDelegateUtils.getAUTArgs((String[])this.conf.autArgs);
            System.out.println(String.format("%s: AUT arguments: %s", autWorkspace, autArgs));
            if (this.conf.rapPlatform) {
                config = AutThread.createLaunchConfiguration(this.tpc.getTargetPlatform(), "AUT_" + Integer.toString(index), autArgs);
                RAPLaunchConfig.setDefaults((ILaunchConfigurationWorkingCopy)config);
                RAPLaunchConfig helper = new RAPLaunchConfig((ILaunchConfiguration)config);
                if (this.conf.port != null) {
                    helper.setPort(this.conf.port.intValue());
                }
                if (!Strings.isNullOrEmpty((String)this.conf.path)) {
                    helper.setServletPath(this.conf.path);
                }
                if (!StringUtils.isEmpty((String)this.conf.browserCmd)) {
                    helper.setBrowserCommand(this.conf.browserCmd);
                }
            } else {
                config = Q7LaunchingUtil.createQ7LaunchConfiguration((ITargetPlatformHelper)this.tpc.getTargetPlatform(), (String)autArgs, (String)("AUT_" + Integer.toString(index)));
            }
            config.setAttribute("clearws", false);
            config.setAttribute("askclear", true);
            config.setAttribute("clearwslog", false);
            config.setAttribute("location", autWorkspace);
            config.setAttribute("q7.headless.launch", true);
            config.setAttribute("org.eclipse.debug.core.capture_output", true);
            if (!this.conf.overrideSecurityStorage) {
                config.setAttribute("override-secure-storage", "false");
            }
            config.setAttribute("org.eclipse.rcptt.launching.outFile", this.outFilePath);
            String vmArgs = Q7LaunchDelegateUtils.getJoinedVMArgs((ITargetPlatformHelper)this.tpc.getTargetPlatform(), Arrays.asList(this.conf.autVMArgs));
            System.out.println(String.format("%s: AUT VM arguments: %s", autWorkspace, vmArgs));
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs);
            if (this.conf.javaVM != null) {
                String autVM = this.manager.getAutVm();
                config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/" + autVM);
                config.setAttribute("append.args", true);
            } else {
                String vmFromIni = this.manager.addJvmFromIniFile();
                if (vmFromIni != null) {
                    config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, vmFromIni);
                    config.setAttribute("append.args", true);
                }
            }
            if (this.conf.enableSoftwareInstallation) {
                config.setAttribute("generateProfile", true);
            }
            ILaunchConfiguration savedConfig = config.doSave();
            boolean haveAUT = false;
            OSArchitecture architecture = this.tpc.getTargetPlatform().detectArchitecture(true, null);
            String crossArchLaunch = null;
            if (!architecture.equals((Object)OSArchitecture.Unknown)) {
                IVMInstall install = VMHelper.getVMInstall((ILaunchConfiguration)savedConfig);
                try {
                    OSArchitecture jvmArch = JDTUtils.detect((IVMInstall)install);
                    if (jvmArch.equals((Object)architecture)) {
                        haveAUT = true;
                    }
                    if (!haveAUT && jvmArch.equals((Object)OSArchitecture.x86_64) && JDTUtils.canRun32bit((IVMInstall)install)) {
                        haveAUT = true;
                        crossArchLaunch = "-d32";
                    }
                }
                catch (Throwable e) {
                    RcpttPlugin.log((Throwable)e);
                }
                if (!haveAUT) {
                    haveAUT = this.updateJVM(savedConfig, architecture, this.tpc.getTargetPlatform());
                }
                if (!haveAUT) {
                    String errorMessage = "FAIL: AUT requires " + architecture + " Java VM which cannot be found.\nPlease specify -autVM {javaPath} command line argument to use different JVM.\nCurrent used JVM is: " + install.getInstallLocation().toString();
                    Q7ExtLaunchingPlugin.getDefault().log(errorMessage, null);
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.launching.ext", errorMessage, null));
                }
            }
            if (!architecture.equals((Object)OSArchitecture.Unknown)) {
                try {
                    String finalArgs = savedConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
                    finalArgs = finalArgs.replace("${target.arch}", architecture.name());
                    ILaunchConfigurationWorkingCopy copy = savedConfig.getWorkingCopy();
                    copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, finalArgs.toString());
                    if (crossArchLaunch != null) {
                        String crossVmArgs = savedConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
                        if (!(crossVmArgs = crossVmArgs.replace("-d64", crossArchLaunch)).contains(crossArchLaunch)) {
                            crossVmArgs = String.valueOf(crossVmArgs) + " " + crossArchLaunch;
                        }
                        copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs.toString());
                    }
                    savedConfig = copy.doSave();
                }
                catch (Throwable e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.launching.ext", e.getMessage(), e));
                }
            }
            return savedConfig;
        }
    }

    private boolean updateJVM(ILaunchConfiguration configuration, OSArchitecture architecture, ITargetPlatformHelper target) {
        try {
            IVMInstall jvmInstall = null;
            OSArchitecture jvmArch = OSArchitecture.Unknown;
            IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
            boolean haveArch = false;
            IVMInstallType[] iVMInstallTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstall[] installs;
                IVMInstallType ivmInstallType = iVMInstallTypeArray[n2];
                IVMInstall[] iVMInstallArray = installs = ivmInstallType.getVMInstalls();
                int n3 = installs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IVMInstall ivmInstall = iVMInstallArray[n4];
                    jvmArch = JDTUtils.detect((IVMInstall)ivmInstall);
                    if (jvmArch.equals((Object)architecture) || jvmArch.equals((Object)OSArchitecture.x86_64) && JDTUtils.canRun32bit((IVMInstall)ivmInstall)) {
                        jvmInstall = ivmInstall;
                        haveArch = true;
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
            if (haveArch) {
                ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
                String vmArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, target.getIniVMArgs());
                vmArgs = vmArgs == null ? LaunchArgumentsHelper.getInitialVMArguments().trim() : vmArgs.trim();
                OSArchitecture autArch = target.detectArchitecture(true, null);
                if (!autArch.equals((Object)jvmArch) && Platform.getOS().equals("macosx")) {
                    vmArgs = vmArgs != null ? String.valueOf(vmArgs) + " -d32" : "-d32";
                }
                if (vmArgs != null && vmArgs.length() > 0) {
                    vmArgs = UpdateVMArgs.updateAttr((String)vmArgs);
                    workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs);
                }
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, String.format("org.eclipse.jdt.launching.JRE_CONTAINER/%s/%s", jvmInstall.getVMInstallType().getId(), jvmInstall.getName()));
                String programArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, AUTLaunchArgumentsHelper.getInitialProgramArguments((String)autArch.name()));
                if (programArgs.length() > 0) {
                    workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArgs);
                }
                workingCopy.doSave();
                return true;
            }
        }
        catch (Throwable e) {
            RcpttPlugin.log((Throwable)e);
        }
        return false;
    }

    void launchAut() {
        String autWorkspace;
        String restartPostfix;
        block15: {
            File dir;
            if (this.restartId != 0) {
                HeadlessRunnerPlugin.getDefault().info("AUT-" + this.autId + ":" + "Restarting " + " (restartId=" + this.restartId + ")");
                System.out.println("AUT-" + this.autId + ":" + "Restarting (restartId=" + this.restartId + ")");
            } else {
                HeadlessRunnerPlugin.getDefault().info("AUT-" + this.autId + ":" + "Launching");
                System.out.println("AUT-" + this.autId + ":" + "Launching");
            }
            System.out.println("AUT-" + this.autId + ":" + "Product: " + this.tpc.getTargetPlatform().getDefaultProduct());
            System.out.println("AUT-" + this.autId + ":" + "Application: " + this.tpc.getTargetPlatform().getDefaultApplication());
            StringBuilder archDetect = new StringBuilder();
            OSArchitecture architecture = this.tpc.getTargetPlatform().detectArchitecture(true, archDetect);
            System.out.println("AUT-" + this.autId + ":" + "Architecture: " + architecture.name() + "\n" + archDetect.toString());
            while (true) {
                restartPostfix = this.restartId == 0 ? "" : "_restarted_" + Integer.valueOf(this.restartId);
                autWorkspace = this.getAutWorkspace(restartPostfix);
                dir = new File(autWorkspace);
                if (this.conf.reuseExistingWorkspace) {
                    dir.mkdirs();
                    break block15;
                }
                HeadlessRunner.deleteDir(dir);
                if (!dir.exists()) break;
                ++this.restartId;
            }
            dir.mkdirs();
        }
        String prefix = this.conf.autConsolePrefix;
        if (Strings.isNullOrEmpty((String)prefix)) {
            prefix = "rcptt";
        }
        File logFile2 = new File(String.valueOf(prefix) + this.autId + restartPostfix + "_startlog.log");
        try {
            if (logFile2.exists()) {
                logFile2.delete();
            }
            logFile2.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException("AUT-" + this.autId + ":" + "Failed to create log file: " + e.getMessage(), e);
        }
        try {
            PrintStreamMonitor monitor = new PrintStreamMonitor("AUT-" + this.autId + ":" + restartPostfix, logFile2);
            ILaunchConfiguration savedConfig = this.createAUTLaunchConfiguration(autWorkspace, this.restartId);
            Aut aut = AutManager.INSTANCE.getByLaunch(savedConfig);
            if (aut == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.runner", "No AUT found for launch configuration: " + savedConfig));
            }
            this.launch = (BaseAutLaunch)aut.launch((IProgressMonitor)monitor);
            if (this.launch == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.runner", "No launch for configuration: " + savedConfig));
            }
        }
        catch (Exception e) {
            try {
                if (this.launch != null) {
                    this.launch.terminate();
                }
            }
            catch (Exception e2) {
                System.out.println(String.format("AUT-%s Launch failed. Reason: %s", this.autId, e.getMessage()));
            }
            String errorMessage = String.format("AUT-%s: Launch failed. Reason: %s", this.autId, e.getMessage());
            System.out.println(errorMessage);
            System.out.println(String.format("AUT-%s: For more information check AUT output at '%s'", this.autId, this.outFilePath));
            HeadlessRunnerPlugin.getDefault().info(errorMessage);
            throw new RuntimeException(errorMessage, e);
        }
    }

    private String getAutWorkspace(String restartPostfix) {
        return this.conf.reuseExistingWorkspace ? this.conf.autWorkspacePrefix : String.valueOf(this.conf.autWorkspacePrefix) + this.autId + restartPostfix;
    }

    public void shutdown() throws CoreException, InterruptedException {
        if (this.launch != null) {
            this.launch.gracefulShutdown(this.conf.shutdownTimeout);
            this.launch = null;
        }
    }

    private static ILaunchConfigurationWorkingCopy createLaunchConfiguration(ITargetPlatformHelper target, String name, String args) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("org.eclipse.rcptt.launching.rap");
        if (name == null) {
            name = launchManager.generateLaunchConfigurationName("AUT");
        }
        ILaunchConfigurationWorkingCopy config = type.newInstance(null, name);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, Q7LaunchDelegateUtils.getWorkingDirectory((File)new File(target.getTargetPlatformProfilePath())).getAbsolutePath());
        config.setAttribute("aut-location", target.getTargetPlatformProfilePath());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, args);
        return config;
    }

    public void restart() throws CoreException, InterruptedException {
        this.shutdown();
        ++this.restartId;
        this.launchAut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retry() {
        if (this.currentRunnable != null) {
            List<ScenarioRunnable> list = this.runnables;
            synchronized (list) {
                this.runnables.add(0, this.currentRunnable);
            }
            this.currentRunnable = null;
        }
    }

    public void cancel() {
        this.cancel = true;
    }

    @Override
    public String toString() {
        return "[AUT-" + this.autId + "]";
    }
}

