/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import java.util.ArrayList;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.core.util.BindingKeyParser;

public class KeyToSignature
extends BindingKeyParser {
    public static final int SIGNATURE = 0;
    public static final int TYPE_ARGUMENTS = 1;
    public static final int DECLARING_TYPE = 2;
    public static final int THROWN_EXCEPTIONS = 3;
    public StringBuilder signature = new StringBuilder();
    private final int kind;
    private boolean asBinarySignature = false;
    private ArrayList arguments = new ArrayList();
    private ArrayList typeArguments = new ArrayList();
    private ArrayList typeParameters = new ArrayList();
    private ArrayList thrownExceptions = new ArrayList();
    private int mainTypeStart = -1;
    private int mainTypeEnd;
    private int typeSigStart = -1;

    public KeyToSignature(BindingKeyParser parser) {
        super(parser);
        KeyToSignature keyToSignature = (KeyToSignature)parser;
        this.kind = keyToSignature.kind;
        this.asBinarySignature = keyToSignature.asBinarySignature;
    }

    public KeyToSignature(String key, int kind) {
        super(key);
        this.kind = kind;
    }

    public KeyToSignature(String key, int kind, boolean asBinarySignature) {
        super(key);
        this.kind = kind;
        this.asBinarySignature = asBinarySignature;
    }

    @Override
    public void consumeArrayDimension(char[] brakets) {
        this.signature.append(brakets);
    }

    @Override
    public void consumeBaseType(char[] baseTypeSig) {
        this.typeSigStart = this.signature.length();
        this.signature.append(baseTypeSig);
    }

    @Override
    public void consumeCapture(int position) {
        this.signature.append('!');
        this.signature.append((CharSequence)((KeyToSignature)this.arguments.get((int)0)).signature);
    }

    @Override
    public void consumeCapture18ID(int id, int position) {
        this.signature.append("!*");
    }

    @Override
    public void consumeLocalType(char[] uniqueKey) {
        this.signature = new StringBuilder();
        uniqueKey = CharOperation.subarray((char[])uniqueKey, (int)0, (int)(uniqueKey.length - 1));
        if (!this.asBinarySignature) {
            CharOperation.replace((char[])uniqueKey, (char)'/', (char)'.');
        }
        this.signature.append(uniqueKey);
    }

    @Override
    public void consumeMethod(char[] selector, char[] methodSignature) {
        this.arguments = new ArrayList();
        this.typeArguments = new ArrayList();
        if (!this.asBinarySignature) {
            CharOperation.replace((char[])methodSignature, (char)'/', (char)'.');
        }
        switch (this.kind) {
            case 0: {
                this.signature = new StringBuilder();
                this.signature.append(methodSignature);
                break;
            }
            case 3: {
                if (CharOperation.indexOf((char)'^', (char[])methodSignature) <= 0) break;
                char[][] types = Signature.getThrownExceptionTypes(methodSignature);
                int length = types.length;
                int i = 0;
                while (i < length) {
                    this.thrownExceptions.add(new String(types[i]));
                    ++i;
                }
                break;
            }
        }
    }

    @Override
    public void consumeMemberType(char[] simpleTypeName) {
        this.signature.append('$');
        this.signature.append(simpleTypeName);
    }

    @Override
    public void consumePackage(char[] pkgName) {
        this.signature.append(pkgName);
    }

    @Override
    public void consumeParameterizedGenericMethod() {
        this.typeArguments = this.arguments;
        int typeParametersSize = this.arguments.size();
        if (typeParametersSize > 0) {
            int sigLength = this.signature.length();
            char[] methodSignature = new char[sigLength];
            this.signature.getChars(0, sigLength, methodSignature, 0);
            char[][] typeParameterSigs = Signature.getTypeParameters(methodSignature);
            if (typeParameterSigs.length != typeParametersSize) {
                return;
            }
            this.signature = new StringBuilder();
            int i = 0;
            while (i < typeParametersSize) {
                typeParameterSigs[i] = CharOperation.concat((char)'T', (char[])Signature.getTypeVariable(typeParameterSigs[i]), (char)';');
                ++i;
            }
            int paramStart = CharOperation.indexOf((char)'(', (char[])methodSignature);
            char[] typeParametersString = CharOperation.subarray((char[])methodSignature, (int)0, (int)paramStart);
            this.signature.append(typeParametersString);
            this.signature.append('(');
            char[][] parameters = Signature.getParameterTypes(methodSignature);
            int i2 = 0;
            int parametersLength = parameters.length;
            while (i2 < parametersLength) {
                this.substitute(parameters[i2], typeParameterSigs, typeParametersSize);
                ++i2;
            }
            this.signature.append(')');
            char[] returnType = Signature.getReturnType(methodSignature);
            this.substitute(returnType, typeParameterSigs, typeParametersSize);
            char[][] exceptions = Signature.getThrownExceptionTypes(methodSignature);
            int i3 = 0;
            int exceptionsLength = exceptions.length;
            while (i3 < exceptionsLength) {
                this.signature.append('^');
                this.substitute(exceptions[i3], typeParameterSigs, typeParametersSize);
                ++i3;
            }
        }
    }

    private void substitute(char[] parameter, char[][] typeParameterSigs, int typeParametersLength) {
        int i = 0;
        while (i < typeParametersLength) {
            if (CharOperation.equals((char[])parameter, (char[])typeParameterSigs[i])) {
                String typeArgument = ((KeyToSignature)this.arguments.get((int)i)).signature.toString();
                this.signature.append(typeArgument);
                return;
            }
            ++i;
        }
        int genericStart = CharOperation.indexOf((char)'<', (char[])parameter);
        if (genericStart > -1) {
            this.signature.append(CharOperation.subarray((char[])parameter, (int)0, (int)genericStart));
            char[][] parameters = Signature.getTypeArguments(parameter);
            this.signature.append('<');
            int j = 0;
            int paramsLength = parameters.length;
            while (j < paramsLength) {
                this.substitute(parameters[j], typeParameterSigs, typeParametersLength);
                ++j;
            }
            this.signature.append('>');
            this.signature.append(';');
        } else {
            int index = 0;
            int length = parameter.length;
            block5: while (index < length) {
                char current = parameter[index];
                switch (current) {
                    case '!': 
                    case '+': 
                    case '-': 
                    case '[': {
                        this.signature.append(current);
                        ++index;
                        break;
                    }
                    default: {
                        break block5;
                    }
                }
            }
            if (index > 0) {
                this.substitute(CharOperation.subarray((char[])parameter, (int)index, (int)length), typeParameterSigs, typeParametersLength);
            } else {
                this.signature.append(parameter);
            }
        }
    }

    @Override
    public void consumeParameterizedType(char[] simpleTypeName, boolean isRaw) {
        if (simpleTypeName != null) {
            this.signature.append(this.asBinarySignature ? (char)'$' : '.');
            this.signature.append(simpleTypeName);
        }
        if (!isRaw) {
            this.signature.append('<');
            int length = this.arguments.size();
            int i = 0;
            while (i < length) {
                this.signature.append((CharSequence)((KeyToSignature)this.arguments.get((int)i)).signature);
                ++i;
            }
            this.signature.append('>');
            this.typeArguments = this.arguments;
            this.arguments = new ArrayList();
        }
    }

    @Override
    public void consumeParser(BindingKeyParser parser) {
        this.arguments.add(parser);
    }

    @Override
    public void consumeField(char[] fieldName) {
        if (this.kind == 0) {
            this.signature = ((KeyToSignature)this.arguments.get((int)0)).signature;
        }
    }

    @Override
    public void consumeException() {
        int size = this.arguments.size();
        if (size > 0) {
            int i = 0;
            while (i < size) {
                this.thrownExceptions.add(((KeyToSignature)this.arguments.get((int)i)).signature.toString());
                ++i;
            }
            this.arguments = new ArrayList();
            this.typeArguments = new ArrayList();
        }
    }

    @Override
    public void consumeFullyQualifiedName(char[] fullyQualifiedName) {
        this.typeSigStart = this.signature.length();
        this.signature.append('L');
        if (!this.asBinarySignature) {
            fullyQualifiedName = CharOperation.replaceOnCopy((char[])fullyQualifiedName, (char)'/', (char)'.');
        }
        this.signature.append(fullyQualifiedName);
    }

    @Override
    public void consumeSecondaryType(char[] simpleTypeName) {
        this.signature.append('~');
        this.mainTypeStart = this.signature.lastIndexOf(this.asBinarySignature ? "/" : ".") + 1;
        if (this.mainTypeStart == 0) {
            this.mainTypeStart = 1;
            int i = 0;
            while (this.signature.charAt(i) == '[') {
                ++this.mainTypeStart;
                ++i;
            }
        }
        this.mainTypeEnd = this.signature.length();
        this.signature.append(simpleTypeName);
    }

    @Override
    public void consumeType() {
        int length;
        if (this.mainTypeStart != -1) {
            this.signature.replace(this.mainTypeStart, this.mainTypeEnd, "");
        }
        if ((length = this.typeParameters.size()) > 0) {
            StringBuilder typeParametersSig = new StringBuilder();
            typeParametersSig.append('<');
            int i = 0;
            while (i < length) {
                char[] typeParameterSig = Signature.createTypeParameterSignature((char[])this.typeParameters.get(i), new char[][]{ConstantPool.ObjectSignature});
                typeParametersSig.append(typeParameterSig);
                ++i;
            }
            typeParametersSig.append('>');
            this.signature.insert(this.typeSigStart, typeParametersSig.toString());
            this.typeParameters = new ArrayList();
        }
        this.signature.append(';');
    }

    @Override
    public void consumeTypeParameter(char[] typeParameterName) {
        this.typeParameters.add(typeParameterName);
    }

    @Override
    public void consumeTypeVariable(char[] position, char[] typeVariableName) {
        this.signature = new StringBuilder();
        this.signature.append('T');
        this.signature.append(typeVariableName);
        this.signature.append(';');
    }

    @Override
    public void consumeTypeWithCapture() {
        KeyToSignature keyToSignature = (KeyToSignature)this.arguments.get(0);
        this.signature = keyToSignature.signature;
        this.arguments = keyToSignature.arguments;
        this.typeArguments = keyToSignature.typeArguments;
        this.thrownExceptions = keyToSignature.thrownExceptions;
    }

    @Override
    public void consumeWildCard(int wildCardKind) {
        this.signature = new StringBuilder();
        switch (wildCardKind) {
            case 0: {
                this.signature.append('*');
                break;
            }
            case 1: {
                this.signature.append('+');
                this.signature.append((CharSequence)((KeyToSignature)this.arguments.get((int)0)).signature);
                break;
            }
            case 2: {
                this.signature.append('-');
                this.signature.append((CharSequence)((KeyToSignature)this.arguments.get((int)0)).signature);
                break;
            }
            default: {
                return;
            }
        }
    }

    public String[] getThrownExceptions() {
        int length = this.thrownExceptions.size();
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = (String)this.thrownExceptions.get(i);
            ++i;
        }
        return result;
    }

    public String[] getTypeArguments() {
        int length = this.typeArguments.size();
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = ((KeyToSignature)this.typeArguments.get((int)i)).signature.toString();
            ++i;
        }
        return result;
    }

    @Override
    public BindingKeyParser newParser() {
        return new KeyToSignature(this);
    }

    public String toString() {
        return this.signature.toString();
    }
}

