/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.core;

import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.ecl.core.BoxedValue;
import org.eclipse.rcptt.ecl.core.ProcessStatus;
import org.eclipse.rcptt.ecl.internal.core.ProcessStatusConverter;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.ReportingFactory;
import org.eclipse.rcptt.sherlock.core.INodeBuilder;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.LoggingCategory;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.LoggingData;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.ReportFactory;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Snaphot;
import org.eclipse.rcptt.sherlock.core.reporting.EventProviderManager;
import org.eclipse.rcptt.sherlock.core.reporting.Procedure1;
import org.eclipse.rcptt.tesla.core.Q7WaitUtils;
import org.eclipse.rcptt.tesla.core.info.InfoFactory;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;

public class ReportHelper {
    public ReportHelper() {
        InfoFactory.eINSTANCE.createQ7WaitInfoRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Q7Info getInfo(Node node) {
        Node node2 = node;
        synchronized (node2) {
            Q7Info value = ReportHelper.getInfoOnly(node);
            if (value == null) {
                value = ReportingFactory.eINSTANCE.createQ7Info();
                node.getProperties().put((Object)"q7", (Object)value);
            }
            return value;
        }
    }

    public static void setInfo(INodeBuilder node, Q7Info info) {
        assert (info.getType() != null);
        assert (info.getResult() == null);
        node.setProperty("q7", (EObject)info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Q7WaitInfoRoot getWaitInfo(Node node, boolean create) {
        Node node2 = node;
        synchronized (node2) {
            Q7WaitInfoRoot value = (Q7WaitInfoRoot)node.getProperties().get((Object)"q7.waitInfo");
            if (value != null) {
                return value;
            }
            if (value == null && create) {
                value = InfoFactory.eINSTANCE.createQ7WaitInfoRoot();
                value.setStartTime(System.currentTimeMillis());
                node.getProperties().put((Object)"q7.waitInfo", (Object)value);
            }
            return value;
        }
    }

    public static void putProperties(INodeBuilder node, Map<String, ? extends EObject> properties) {
        for (Map.Entry<String, ? extends EObject> entry : properties.entrySet()) {
            node.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public static void appendLog(Node node, LoggingCategory category, String log) {
        String logKey = ReportHelper.getLogCategoryKey(category);
        EMap properties = node.getProperties();
        LoggingData data = (LoggingData)properties.get((Object)logKey);
        if (data == null) {
            data = ReportFactory.eINSTANCE.createLoggingData();
            properties.put((Object)logKey, (Object)data);
        }
        StringBuilder sb = new StringBuilder(data.getText());
        sb.append(log);
        sb.append("\n");
        data.setText(sb.toString());
    }

    private static String getLogCategoryKey(LoggingCategory category) {
        return "log_" + category.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Q7Info getInfoOnly(Node node) {
        Node node2 = node;
        synchronized (node2) {
            EObject value = (EObject)node.getProperties().get((Object)"q7");
            if (value instanceof Q7Info) {
                return (Q7Info)value;
            }
            return null;
        }
    }

    public static Q7Info createInfo() {
        return ReportingFactory.eINSTANCE.createQ7Info();
    }

    public static void startWaitInfo(INodeBuilder node, String kind, String className) {
        Q7WaitUtils.startInfo((String)kind, (String)className, (Q7WaitInfoRoot)ReportHelper.getWaitInfo(node));
    }

    public static void finishWaitInfo(INodeBuilder node, String kind, String className) {
        Q7WaitUtils.finishInfo((String)kind, (String)className, (Q7WaitInfoRoot)ReportHelper.getWaitInfo(node));
    }

    public static void updateWaitInfo(INodeBuilder node, String kind, String className) {
        Q7WaitUtils.updateInfo((String)kind, (String)className, (Q7WaitInfoRoot)ReportHelper.getWaitInfo(node));
    }

    public static Q7WaitInfoRoot getWaitInfo(INodeBuilder node) {
        final Q7WaitInfoRoot[] waitInfo = new Q7WaitInfoRoot[1];
        node.update((Procedure1)new Procedure1<Node>(){

            public void apply(Node node) {
                waitInfo[0] = ReportHelper.getWaitInfo(node, true);
            }
        });
        return waitInfo[0];
    }

    public static void setResult(INodeBuilder node, IStatus status) {
        ReportHelper.setResult(node, ProcessStatusConverter.toProcessStatus((IStatus)status));
    }

    public static void setResult(INodeBuilder node, ProcessStatus status) {
        if (status == null) {
            throw new NullPointerException("Status can't be null");
        }
        if (node == null) {
            throw new NullPointerException("Node can't be null");
        }
        final ProcessStatus status2 = (ProcessStatus)EcoreUtil.copy((EObject)status);
        node.update((Procedure1)new Procedure1<Node>(){

            public void apply(Node arg) {
                Q7Info info = ReportHelper.getInfo(arg);
                if (info.getResult() != null) {
                    throw new IllegalStateException("Result is already set for " + arg.getName());
                }
                info.setResult(status2);
            }
        });
    }

    public static void addSnapshotWithData(INodeBuilder node, EObject data) {
        Snaphot snapshot = ReportFactory.eINSTANCE.createSnaphot();
        snapshot.setData(Objects.requireNonNull(data));
        node.addSnapshot(snapshot);
    }

    public static void takeSnapshot(INodeBuilder node) {
        EventProviderManager.getInstance().takeSnapshot(node);
    }

    public static boolean isIterable(INodeBuilder node) {
        EObject eIsIterable = node.getProperty("q7.command.iterable");
        if (eIsIterable == null) {
            return false;
        }
        assert (eIsIterable instanceof BoxedValue);
        Object oIsIterable = BoxedValues.unbox((Object)((BoxedValue)eIsIterable));
        assert (oIsIterable instanceof Boolean);
        return (Boolean)oIsIterable;
    }

    public static void markIterable(INodeBuilder node) {
        node.setProperty("q7.command.iterable", (EObject)BoxedValues.box((boolean)true));
    }
}

