/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ApplicationSelectionDialog
extends TrayDialog {
    private final String fMode;
    private Combo applicationCombo;
    private final String[] fApplicationNames;
    private String fSelectedApplication;

    public ApplicationSelectionDialog(Shell parentShell, String[] applicationNames, String mode) {
        super(parentShell);
        this.fMode = mode;
        this.fApplicationNames = applicationNames;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.pde.doc.user.launcher_application_selection");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 9;
        layout.marginWidth = 9;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        container.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        if (this.fMode.equals("debug")) {
            label.setText(PDEUIMessages.ApplicationSelectionDialog_debug);
        } else {
            label.setText(PDEUIMessages.ApplicationSelectionDialog_run);
        }
        this.applicationCombo = new Combo(container, 12);
        this.applicationCombo.setLayoutData((Object)new GridData(768));
        this.applicationCombo.setItems(this.fApplicationNames);
        String defaultApp = TargetPlatform.getDefaultApplication();
        if (this.applicationCombo.indexOf(defaultApp) == -1) {
            this.applicationCombo.add(defaultApp);
        }
        this.applicationCombo.setText(this.applicationCombo.getItem(0));
        this.getShell().setText(this.fMode.equals("debug") ? PDEUIMessages.ApplicationSelectionDialog_dtitle : PDEUIMessages.ApplicationSelectionDialog_rtitle);
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    protected void okPressed() {
        this.fSelectedApplication = this.applicationCombo.getText();
        super.okPressed();
    }

    public String getSelectedApplication() {
        if (this.fSelectedApplication.equals(TargetPlatform.getDefaultApplication())) {
            return null;
        }
        return this.fSelectedApplication;
    }
}

