/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.resources.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.rcptt.workspace.WSFile;
import org.eclipse.rcptt.workspace.WSFolder;
import org.eclipse.rcptt.workspace.WSProject;
import org.eclipse.rcptt.workspace.WSRoot;
import org.eclipse.rcptt.workspace.util.WorkspaceSwitch;

public class WSSearchSwitch
extends WorkspaceSwitch<Boolean> {
    private final String query;
    private final IProgressMonitor monitor;

    public WSSearchSwitch(String query, IProgressMonitor monitor) {
        this.query = query.toLowerCase();
        this.monitor = monitor;
    }

    public Boolean caseWSFile(WSFile object) {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return object.getName().toLowerCase().contains(this.query);
    }

    public Boolean caseWSFolder(WSFolder object) {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (object.getName().toLowerCase().contains(this.query)) {
            return true;
        }
        for (WSFile file : object.getFiles()) {
            if (!this.caseWSFile(file).booleanValue()) continue;
            return true;
        }
        for (WSFile file : object.getFolders()) {
            if (!this.caseWSFolder((WSFolder)file).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean caseWSProject(WSProject object) {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (object.getName().toLowerCase().contains(this.query)) {
            return true;
        }
        for (WSFile file : object.getFiles()) {
            if (!this.caseWSFile(file).booleanValue()) continue;
            return true;
        }
        for (WSFile file : object.getFolders()) {
            if (!this.caseWSFolder((WSFolder)file).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Boolean caseWSRoot(WSRoot object) {
        if (this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (WSProject project : object.getProjects()) {
            if (!this.caseWSProject(project).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

