/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.SerializationException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.renderers.swt.IUpdateService;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.commands.ElementReference;
import org.eclipse.ui.internal.menus.MenuHelper;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;

public class SlaveCommandService
implements ICommandService,
IUpdateService {
    private Collection fExecutionListeners = new ArrayList();
    private Set fCallbackCache = new HashSet();
    private ICommandService fParentService;
    private String fScopingName;
    private IServiceLocator fScopingValue;
    private IEclipseContext fContext;

    public SlaveCommandService(ICommandService parent, String scopeName, IServiceLocator scopeValue) {
        this(parent, scopeName, scopeValue, null);
    }

    public SlaveCommandService(ICommandService parent, String scopeName, IServiceLocator scopeValue, IEclipseContext context) {
        if (parent == null) {
            throw new NullPointerException("The parent command service must not be null");
        }
        this.fParentService = parent;
        this.fScopingName = scopeName;
        this.fScopingValue = scopeValue;
        this.fContext = context;
    }

    @Override
    public void addExecutionListener(IExecutionListener listener) {
        if (!this.fExecutionListeners.contains(listener)) {
            this.fExecutionListeners.add(listener);
        }
        this.fParentService.addExecutionListener(listener);
    }

    @Override
    public void defineUncategorizedCategory(String name, String description) {
        this.fParentService.defineUncategorizedCategory(name, description);
    }

    @Override
    public ParameterizedCommand deserialize(String serializedParameterizedCommand) throws NotDefinedException, SerializationException {
        return this.fParentService.deserialize(serializedParameterizedCommand);
    }

    @Override
    public void dispose() {
        Object element;
        int n;
        int n2;
        Object[] objectArray;
        Object[] array;
        if (!this.fExecutionListeners.isEmpty()) {
            objectArray = array = this.fExecutionListeners.toArray();
            n2 = array.length;
            n = 0;
            while (n < n2) {
                element = objectArray[n];
                this.removeExecutionListener((IExecutionListener)element);
                ++n;
            }
            this.fExecutionListeners.clear();
        }
        if (!this.fCallbackCache.isEmpty()) {
            objectArray = array = this.fCallbackCache.toArray();
            n2 = array.length;
            n = 0;
            while (n < n2) {
                element = objectArray[n];
                this.unregisterElement((IElementReference)element);
                ++n;
            }
        }
        this.fScopingValue = null;
        this.fContext = null;
        this.fParentService = null;
    }

    @Override
    public Category getCategory(String categoryId) {
        return this.fParentService.getCategory(categoryId);
    }

    @Override
    public Command getCommand(String commandId) {
        return this.fParentService.getCommand(commandId);
    }

    @Override
    public Category[] getDefinedCategories() {
        return this.fParentService.getDefinedCategories();
    }

    @Override
    public Collection getDefinedCategoryIds() {
        return this.fParentService.getDefinedCategoryIds();
    }

    @Override
    public Collection getDefinedCommandIds() {
        return this.fParentService.getDefinedCommandIds();
    }

    @Override
    public Command[] getDefinedCommands() {
        return this.fParentService.getDefinedCommands();
    }

    @Override
    public Collection getDefinedParameterTypeIds() {
        return this.fParentService.getDefinedParameterTypeIds();
    }

    @Override
    public ParameterType[] getDefinedParameterTypes() {
        return this.fParentService.getDefinedParameterTypes();
    }

    @Override
    public final String getHelpContextId(Command command) throws NotDefinedException {
        return this.fParentService.getHelpContextId(command);
    }

    @Override
    public final String getHelpContextId(String commandId) throws NotDefinedException {
        return this.fParentService.getHelpContextId(commandId);
    }

    @Override
    public ParameterType getParameterType(String parameterTypeId) {
        return this.fParentService.getParameterType(parameterTypeId);
    }

    @Override
    public void readRegistry() {
        this.fParentService.readRegistry();
    }

    @Override
    public void removeExecutionListener(IExecutionListener listener) {
        this.fExecutionListeners.remove(listener);
        this.fParentService.removeExecutionListener(listener);
    }

    @Override
    public final void setHelpContextId(IHandler handler, String helpContextId) {
        this.fParentService.setHelpContextId(handler, helpContextId);
    }

    @Override
    public void refreshElements(String commandId, Map filter) {
        this.fParentService.refreshElements(commandId, filter);
    }

    @Override
    public IElementReference registerElementForCommand(ParameterizedCommand command, UIElement element) throws NotDefinedException {
        if (!command.getCommand().isDefined()) {
            throw new NotDefinedException("Cannot define a callback for undefined command " + command.getCommand().getId());
        }
        if (element == null) {
            throw new NotDefinedException("No callback defined for command " + command.getCommand().getId());
        }
        ElementReference ref = new ElementReference(command.getId(), element, command.getParameterMap());
        this.registerElement(ref);
        return ref;
    }

    @Override
    public void registerElement(IElementReference elementReference) {
        this.fCallbackCache.add(elementReference);
        elementReference.getParameters().put(this.fScopingName, this.fScopingValue);
        this.fParentService.registerElement(elementReference);
    }

    @Override
    public void unregisterElement(IElementReference elementReference) {
        this.fCallbackCache.remove(elementReference);
        this.fParentService.unregisterElement(elementReference);
    }

    public Runnable registerElementForUpdate(ParameterizedCommand parameterizedCommand, final MItem item) {
        UIElement element = new UIElement(this.fScopingValue){

            @Override
            public void setText(String text) {
                item.setLabel(text);
            }

            @Override
            public void setTooltip(String text) {
                item.setTooltip(text);
            }

            @Override
            public void setIcon(ImageDescriptor desc) {
                item.setIconURI(MenuHelper.getIconURI(desc, SlaveCommandService.this.fContext));
            }

            @Override
            public void setDisabledIcon(ImageDescriptor desc) {
                item.getTransientData().put("e4_disabled_icon_image_key", MenuHelper.getIconURI(desc, SlaveCommandService.this.fContext));
            }

            @Override
            public void setHoverIcon(ImageDescriptor desc) {
            }

            @Override
            public void setChecked(boolean checked) {
                item.setSelected(checked);
            }
        };
        try {
            IElementReference reference = this.registerElementForCommand(parameterizedCommand, element);
            return () -> this.unregisterElement(reference);
        }
        catch (NotDefinedException e) {
            WorkbenchPlugin.log(e);
            return null;
        }
    }
}

