/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.tasks;

import aQute.bnd.osgi.resource.ResourceBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import org.eclipse.pde.bnd.ui.model.resolution.RequirementWrapper;
import org.eclipse.pde.bnd.ui.tasks.CapReqLoader;
import org.eclipse.pde.bnd.ui.tasks.ResourceCapReqLoader;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

public class ManifestCapReqLoader
implements CapReqLoader {
    private final File manifestFile;
    private ResourceCapReqLoader resourceCapReqLoader;

    public ManifestCapReqLoader(File manifestFile) {
        this.manifestFile = manifestFile;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.resourceCapReqLoader != null) {
            this.resourceCapReqLoader.close();
            this.resourceCapReqLoader = null;
        }
    }

    @Override
    public String getShortLabel() {
        return this.manifestFile.getName();
    }

    @Override
    public String getLongLabel() {
        return this.manifestFile.getAbsolutePath();
    }

    @Override
    public Map<String, List<Capability>> loadCapabilities() throws Exception {
        this.loadManifest();
        return this.loadManifest().loadCapabilities();
    }

    @Override
    public Map<String, List<RequirementWrapper>> loadRequirements() throws Exception {
        return this.loadManifest().loadRequirements();
    }

    private synchronized ResourceCapReqLoader loadManifest() throws IOException {
        if (this.resourceCapReqLoader == null) {
            Manifest manifest;
            Throwable throwable = null;
            Object var3_3 = null;
            try (FileInputStream stream = new FileInputStream(this.manifestFile);){
                manifest = new Manifest(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ResourceBuilder builder = new ResourceBuilder();
            builder.addManifest(manifest);
            this.resourceCapReqLoader = new ResourceCapReqLoader((Resource)builder.build());
        }
        return this.resourceCapReqLoader;
    }
}

