/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.internal.build.site.QualifierReplacer;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.exports.AbstractExportTab;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExportOptionsTab
extends AbstractExportTab {
    protected static final String S_JAR_FORMAT = "exportUpdate";
    private static final String S_EXPORT_SOURCE = "exportSource";
    private static final String S_EXPORT_SOURCE_FORMAT = "exportSourceFormat";
    private static final String S_SAVE_AS_ANT = "saveAsAnt";
    private static final String S_ANT_FILENAME = "antFileName";
    private static final String S_QUALIFIER = "qualifier";
    private static final String S_QUALIFIER_NAME = "qualifierName";
    private static final String S_ALLOW_BINARY_CYCLES = "allowBinaryCycles";
    private static final String S_USE_WORKSPACE_COMPILED_CLASSES = "useWorkspaceCompiledClasses";
    private Button fIncludeSourceButton;
    private Combo fIncludeSourceCombo;
    protected Button fJarButton;
    private Button fSaveAsAntButton;
    private Combo fAntCombo;
    private Button fBrowseAnt;
    private Button fQualifierButton;
    private Text fQualifierText;
    private Button fAllowBinaryCycles;
    private Button fUseWSCompiledClasses;

    public ExportOptionsTab(BaseExportWizardPage page) {
        super(page);
    }

    @Override
    protected Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(768));
        this.addSourceOption(container);
        this.addJAROption(container);
        this.addAdditionalOptions(container);
        this.addQualifierOption(container);
        this.addAntSection(container);
        this.addAllowBinaryCyclesSection(container);
        this.addUseWorkspaceCompiledClassesSection(container);
        return container;
    }

    protected void addSourceOption(Composite container) {
        Composite composite = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.fIncludeSourceButton = new Button(composite, 32);
        this.fIncludeSourceButton.setText(PDEUIMessages.ExportWizard_includeSource);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        this.fIncludeSourceButton.setLayoutData((Object)gd);
        this.fIncludeSourceCombo = new Combo(composite, 2056);
        this.fIncludeSourceCombo.setLayoutData((Object)new GridData(32));
    }

    protected void addJAROption(Composite comp) {
        this.fJarButton = new Button(comp, 32);
        this.fJarButton.setText(this.getJarButtonText());
    }

    protected void addAllowBinaryCyclesSection(Composite comp) {
        this.fAllowBinaryCycles = new Button(comp, 32);
        this.fAllowBinaryCycles.setText(PDEUIMessages.ExportOptionsTab_allowBinaryCycles);
    }

    protected void addUseWorkspaceCompiledClassesSection(Composite comp) {
        this.fUseWSCompiledClasses = new Button(comp, 32);
        this.fUseWSCompiledClasses.setText(PDEUIMessages.ExportOptionsTab_use_workspace_classfiles);
    }

    protected String getJarButtonText() {
        return PDEUIMessages.BaseExportWizardPage_packageJARs;
    }

    protected void addAdditionalOptions(Composite comp) {
    }

    protected void addAntSection(Composite container) {
        Composite comp = new Composite(container, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.fSaveAsAntButton = new Button(comp, 32);
        this.fSaveAsAntButton.setText(PDEUIMessages.ExportWizard_antCheck);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        this.fSaveAsAntButton.setLayoutData((Object)gd);
        this.fAntCombo = new Combo(comp, 0);
        this.fAntCombo.setLayoutData((Object)new GridData(768));
        this.fBrowseAnt = new Button(comp, 8);
        this.fBrowseAnt.setText(PDEUIMessages.ExportWizard_browse);
        this.fBrowseAnt.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fBrowseAnt);
    }

    protected void addQualifierOption(Composite container) {
        Composite comp = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.fQualifierButton = new Button(comp, 32);
        this.fQualifierButton.setText(PDEUIMessages.AdvancedPluginExportPage_qualifier);
        this.fQualifierText = new Text(comp, 2052);
        this.fQualifierText.setLayoutData((Object)new GridData(768));
        this.fQualifierText.addModifyListener(e -> this.fPage.pageChanged());
    }

    @Override
    protected void initialize(IDialogSettings settings) {
        this.fIncludeSourceButton.setSelection(settings.getBoolean(S_EXPORT_SOURCE));
        this.fIncludeSourceCombo.setItems(new String[]{PDEUIMessages.ExportWizard_generateAssociatedSourceBundles, PDEUIMessages.ExportWizard_includeSourceInBinaryBundles});
        String sourceComboValue = settings.get(S_EXPORT_SOURCE_FORMAT) != null ? settings.get(S_EXPORT_SOURCE_FORMAT) : PDEUIMessages.ExportWizard_generateAssociatedSourceBundles;
        this.fIncludeSourceCombo.setText(sourceComboValue);
        this.fIncludeSourceCombo.setEnabled(this.fIncludeSourceButton.getSelection());
        this.fJarButton.setSelection(this.getInitialJarButtonSelection(settings));
        this.fSaveAsAntButton.setSelection(settings.getBoolean(S_SAVE_AS_ANT));
        this.initializeCombo(settings, S_ANT_FILENAME, this.fAntCombo);
        this.fAntCombo.setEnabled(this.fSaveAsAntButton.getSelection());
        this.fBrowseAnt.setEnabled(this.fSaveAsAntButton.getSelection());
        this.fQualifierButton.setSelection(settings.getBoolean(S_QUALIFIER));
        this.fQualifierText.setText(this.getInitialQualifierText(settings));
        this.fQualifierText.setEnabled(this.fQualifierButton.getSelection());
        this.fAllowBinaryCycles.setSelection(this.getInitialAllowBinaryCyclesSelection(settings));
        this.fUseWSCompiledClasses.setSelection(this.getInitialUseWorkspaceCompiledClassesSelection(settings));
        this.hookListeners();
    }

    @Override
    protected void saveSettings(IDialogSettings settings) {
        settings.put(S_JAR_FORMAT, this.fJarButton.getSelection());
        settings.put(S_EXPORT_SOURCE, this.fIncludeSourceButton.getSelection());
        settings.put(S_EXPORT_SOURCE_FORMAT, this.fIncludeSourceCombo.getItem(this.fIncludeSourceCombo.getSelectionIndex()));
        settings.put(S_SAVE_AS_ANT, this.fSaveAsAntButton.getSelection());
        settings.put(S_QUALIFIER, this.fQualifierButton.getSelection());
        settings.put(S_QUALIFIER_NAME, this.fQualifierText.getText());
        settings.put(S_ALLOW_BINARY_CYCLES, this.fAllowBinaryCycles.getSelection());
        settings.put(S_USE_WORKSPACE_COMPILED_CLASSES, this.fUseWSCompiledClasses.getSelection());
        this.saveCombo(settings, S_ANT_FILENAME, this.fAntCombo);
    }

    private String getInitialQualifierText(IDialogSettings settings) {
        String qualifier = settings.get(S_QUALIFIER_NAME);
        if (qualifier == null || qualifier.equals("")) {
            return QualifierReplacer.getDateQualifier();
        }
        return qualifier;
    }

    protected boolean getInitialJarButtonSelection(IDialogSettings settings) {
        String selected = settings.get(S_JAR_FORMAT);
        return selected == null ? TargetPlatformHelper.getTargetVersion() >= 3.1 : Boolean.parseBoolean(selected);
    }

    protected boolean getInitialAllowBinaryCyclesSelection(IDialogSettings settings) {
        String selected = settings.get(S_ALLOW_BINARY_CYCLES);
        return selected == null ? true : Boolean.parseBoolean(selected);
    }

    protected boolean getInitialUseWorkspaceCompiledClassesSelection(IDialogSettings settings) {
        String selected = settings.get(S_USE_WORKSPACE_COMPILED_CLASSES);
        return selected == null ? false : Boolean.parseBoolean(selected);
    }

    protected void hookListeners() {
        this.fIncludeSourceButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.fIncludeSourceCombo.setEnabled(this.fIncludeSourceButton.getSelection())));
        this.fJarButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> ((BaseExportWizardPage)this.fPage).adjustAdvancedTabsVisibility()));
        this.fSaveAsAntButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.fAntCombo.setEnabled(this.fSaveAsAntButton.getSelection());
            this.fBrowseAnt.setEnabled(this.fSaveAsAntButton.getSelection());
            this.fPage.pageChanged();
        }));
        this.fBrowseAnt.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.chooseFile(this.fAntCombo, new String[]{"*.xml"})));
        this.fAntCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.fPage.pageChanged()));
        this.fAntCombo.addModifyListener(e -> this.fPage.pageChanged());
        this.fQualifierButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.fQualifierText.setEnabled(this.fQualifierButton.getSelection());
            this.fPage.pageChanged();
        }));
    }

    protected String validate() {
        if (this.fSaveAsAntButton.getSelection() && this.fAntCombo.getText().trim().length() == 0) {
            return PDEUIMessages.ExportWizard_status_noantfile;
        }
        return null;
    }

    protected String validateAntCombo() {
        String path = IPath.fromOSString((String)this.fAntCombo.getText()).lastSegment();
        if ("build.xml".equals(path)) {
            return PDEUIMessages.ExportOptionsTab_antReservedMessage;
        }
        return null;
    }

    protected boolean doExportSource() {
        return this.fIncludeSourceButton.getSelection();
    }

    protected boolean doExportSourceBundles() {
        return PDEUIMessages.ExportWizard_generateAssociatedSourceBundles.equals(this.fIncludeSourceCombo.getText());
    }

    protected boolean doBinaryCycles() {
        return this.fAllowBinaryCycles.getSelection();
    }

    protected boolean useWorkspaceCompiledClasses() {
        return this.fUseWSCompiledClasses.getSelection();
    }

    protected boolean useJARFormat() {
        return this.fJarButton.getSelection();
    }

    protected boolean doGenerateAntFile() {
        return this.fSaveAsAntButton.getSelection();
    }

    protected String getAntBuildFileName() {
        return this.fSaveAsAntButton.getSelection() ? this.fAntCombo.getText() : null;
    }

    protected String getQualifier() {
        String qualifier;
        if (this.fQualifierText.isEnabled() && (qualifier = this.fQualifierText.getText().trim()).length() > 0) {
            return qualifier;
        }
        return null;
    }

    protected void setEnabledForInstall(boolean enabled) {
        this.fQualifierButton.setEnabled(enabled);
        this.fQualifierText.setEnabled(enabled && this.fQualifierButton.getSelection());
        this.fJarButton.setEnabled(enabled);
    }
}

