/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.UseSupertypeDescriptor;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsModel;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsSolver;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeRefactoringProcessor;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ITypeConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.util.Progress;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.TextEditGroup;

public final class UseSuperTypeProcessor
extends SuperTypeRefactoringProcessor {
    private static final String IDENTIFIER = "org.eclipse.jdt.ui.useSuperTypeProcessor";
    private TextEditBasedChangeManager fChangeManager = null;
    private int fChanges = 0;
    private IType fSubType;
    private IType fSuperType;

    protected static ITypeBinding findTypeInHierarchy(ITypeBinding type, String name) {
        ITypeBinding result;
        if (type.isArray() || type.isPrimitive()) {
            return null;
        }
        if (name.equals(type.getTypeDeclaration().getQualifiedName())) {
            return type;
        }
        ITypeBinding binding = type.getSuperclass();
        if (binding != null && (result = UseSuperTypeProcessor.findTypeInHierarchy(binding, name)) != null) {
            return result;
        }
        ITypeBinding[] iTypeBindingArray = type.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding b = iTypeBindingArray[n2];
            ITypeBinding result2 = UseSuperTypeProcessor.findTypeInHierarchy(b, name);
            if (result2 != null) {
                return result2;
            }
            ++n2;
        }
        return null;
    }

    public UseSuperTypeProcessor(IType subType) {
        super(null);
        this.fReplace = true;
        this.fSubType = subType;
    }

    public UseSuperTypeProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        super(null);
        this.fReplace = true;
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)context);
        RefactoringStatus status = new RefactoringStatus();
        this.fChangeManager = new TextEditBasedChangeManager();
        try {
            monitor.beginTask("", 200);
            monitor.setTaskName(RefactoringCoreMessages.UseSuperTypeProcessor_checking);
            this.fChangeManager = this.createChangeManager(Progress.subMonitor(monitor, 200), status);
            if (!status.hasFatalError()) {
                Checks.addModifiedFilesToChecker(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits()), context);
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Assert.isNotNull((Object)monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.UseSuperTypeProcessor_checking);
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
        return status;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Assert.isNotNull((Object)monitor);
        try {
            this.fChanges = 0;
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
            TextEditBasedChange[] changes = this.fChangeManager.getAllChanges();
            if (changes != null && changes.length != 0) {
                this.fChanges = changes.length;
                IJavaProject project = null;
                if (!this.fSubType.isBinary()) {
                    project = this.fSubType.getJavaProject();
                }
                int flags = 589830;
                try {
                    if (this.fSubType.isLocal() || this.fSubType.isAnonymous()) {
                        flags |= 0x40000;
                    }
                }
                catch (JavaModelException exception) {
                    JavaManipulationPlugin.log(exception);
                }
                String name = project != null ? project.getElementName() : null;
                String description = Messages.format(RefactoringCoreMessages.UseSuperTypeProcessor_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fSuperType.getElementName()));
                String header = Messages.format(RefactoringCoreMessages.UseSuperTypeProcessor_descriptor_description, new String[]{JavaElementLabelsCore.getElementLabel((IJavaElement)this.fSuperType, 2235681801344L), JavaElementLabelsCore.getElementLabel((IJavaElement)this.fSubType, 2235681801344L)});
                JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(name, (Object)this, header);
                comment.addSetting(Messages.format(RefactoringCoreMessages.UseSuperTypeProcessor_refactored_element_pattern, JavaElementLabelsCore.getElementLabel((IJavaElement)this.fSuperType, 2235681801344L)));
                this.addSuperTypeSettings(comment, false);
                UseSupertypeDescriptor descriptor = RefactoringSignatureDescriptorFactory.createUseSupertypeDescriptor();
                descriptor.setProject(name);
                descriptor.setDescription(description);
                descriptor.setComment(comment.asString());
                descriptor.setFlags(flags);
                descriptor.setSubtype(this.getSubType());
                descriptor.setSupertype(this.getSuperType());
                descriptor.setReplaceInstanceof(this.fInstanceOf);
                DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.UseSupertypeWherePossibleRefactoring_name, (Change[])this.fChangeManager.getAllChanges());
                return dynamicValidationRefactoringChange;
            }
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
        return null;
    }

    protected TextEditBasedChangeManager createChangeManager(final IProgressMonitor monitor, final RefactoringStatus status) throws JavaModelException, CoreException {
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", 300);
            monitor.setTaskName(RefactoringCoreMessages.UseSuperTypeProcessor_creating);
            final TextEditBasedChangeManager manager = new TextEditBasedChangeManager();
            IJavaProject project = this.fSubType.getJavaProject();
            ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
            parser.setWorkingCopyOwner((WorkingCopyOwner)this.fOwner);
            parser.setResolveBindings(true);
            parser.setProject(project);
            parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)project));
            if (this.fSubType.isBinary() || this.fSubType.isReadOnly()) {
                IBinding[] bindings = parser.createBindings(new IJavaElement[]{this.fSubType, this.fSuperType}, Progress.subMonitor(monitor, 50));
                if (bindings != null && bindings.length == 2 && bindings[0] instanceof ITypeBinding && bindings[1] instanceof ITypeBinding) {
                    this.solveSuperTypeConstraints(null, null, this.fSubType, (ITypeBinding)bindings[0], (ITypeBinding)bindings[1], Progress.subMonitor(monitor, 100), status);
                    if (!status.hasFatalError()) {
                        this.rewriteTypeOccurrences(manager, null, null, null, null, new HashSet<String>(), status, Progress.subMonitor(monitor, 150));
                    }
                }
            } else {
                parser.createASTs(new ICompilationUnit[]{this.fSubType.getCompilationUnit()}, new String[0], new ASTRequestor(){

                    public final void acceptAST(ICompilationUnit unit, CompilationUnit node) {
                        try {
                            ITypeBinding superBinding;
                            ITypeBinding subBinding;
                            CompilationUnitRewrite subRewrite = new CompilationUnitRewrite(UseSuperTypeProcessor.this.fOwner, unit, node);
                            AbstractTypeDeclaration subDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(UseSuperTypeProcessor.this.fSubType, subRewrite.getRoot());
                            if (subDeclaration != null && (subBinding = subDeclaration.resolveBinding()) != null && (superBinding = UseSuperTypeProcessor.findTypeInHierarchy(subBinding, UseSuperTypeProcessor.this.fSuperType.getFullyQualifiedName('.'))) != null) {
                                UseSuperTypeProcessor.this.solveSuperTypeConstraints(subRewrite.getCu(), subRewrite.getRoot(), UseSuperTypeProcessor.this.fSubType, subBinding, superBinding, Progress.subMonitor(monitor, 100), status);
                                if (!status.hasFatalError()) {
                                    UseSuperTypeProcessor.this.rewriteTypeOccurrences(manager, this, subRewrite, subRewrite.getCu(), subRewrite.getRoot(), new HashSet(), status, Progress.subMonitor(monitor, 200));
                                    CompilationUnitChange change = subRewrite.createChange(true);
                                    if (change != null) {
                                        manager.manage(subRewrite.getCu(), (TextEditBasedChange)change);
                                    }
                                }
                            }
                        }
                        catch (CoreException exception) {
                            JavaManipulationPlugin.log(exception);
                            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.UseSuperTypeProcessor_internal_error));
                        }
                    }

                    public final void acceptBinding(String key, IBinding binding) {
                    }
                }, (IProgressMonitor)new NullProgressMonitor());
            }
            TextEditBasedChangeManager textEditBasedChangeManager = manager;
            return textEditBasedChangeManager;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected SuperTypeConstraintsSolver createContraintSolver(SuperTypeConstraintsModel model) {
        return new SuperTypeConstraintsSolver(model);
    }

    public int getChanges() {
        return this.fChanges;
    }

    public Object[] getElements() {
        return new Object[]{this.fSubType};
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.UseSuperTypeProcessor_name;
    }

    public IType getSubType() {
        return this.fSubType;
    }

    public IType getSuperType() {
        return this.fSuperType;
    }

    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        IJavaElement element;
        String handle = extended.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 7) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.use.supertype");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fSubType = (IType)element;
        handle = extended.getAttribute("element1");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 7) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.use.supertype");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "element1"));
        }
        this.fSuperType = (IType)element;
        String instance = extended.getAttribute("instanceof");
        if (instance == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "instanceof"));
        }
        this.fInstanceOf = Boolean.parseBoolean(instance);
        return new RefactoringStatus();
    }

    public boolean isApplicable() throws CoreException {
        return Checks.isAvailable((IJavaElement)this.fSubType) && Checks.isAvailable((IJavaElement)this.fSuperType) && !this.fSubType.isAnonymous() && !this.fSubType.isAnnotation() && !this.fSuperType.isAnonymous() && !this.fSuperType.isAnnotation() && !this.fSuperType.isEnum();
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    @Override
    protected void rewriteTypeOccurrences(TextEditBasedChangeManager manager, ASTRequestor requestor, CompilationUnitRewrite rewrite, ICompilationUnit unit, CompilationUnit node, Set<String> replacements, IProgressMonitor monitor) throws CoreException {
        block9: {
            try {
                monitor.beginTask("", 100);
                monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
                Collection collection = (Collection)this.fTypeOccurrences.get(unit);
                if (collection == null || collection.isEmpty()) break block9;
                IProgressMonitor subMonitor = Progress.subMonitor(monitor, 100);
                try {
                    CompilationUnitChange change;
                    subMonitor.beginTask("", collection.size() * 10);
                    subMonitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
                    CompilationUnitRewrite currentRewrite = null;
                    ICompilationUnit sourceUnit = rewrite.getCu();
                    currentRewrite = sourceUnit.equals(unit) ? rewrite : new CompilationUnitRewrite(this.fOwner, unit, node);
                    for (ITypeConstraintVariable iTypeConstraintVariable : collection) {
                        ASTNode result;
                        TType estimate = (TType)iTypeConstraintVariable.getData("te");
                        if (estimate != null && (result = NodeFinder.perform((ASTNode)node, (ISourceRange)iTypeConstraintVariable.getRange().getSourceRange())) != null) {
                            this.rewriteTypeOccurrence(estimate, currentRewrite, result, (TextEditGroup)currentRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.SuperTypeRefactoringProcessor_update_type_occurrence, SET_SUPER_TYPE));
                        }
                        subMonitor.worked(10);
                    }
                    if (!sourceUnit.equals(unit) && (change = currentRewrite.createChange(true)) != null) {
                        manager.manage(unit, (TextEditBasedChange)change);
                    }
                }
                finally {
                    subMonitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    public void setSuperType(IType type) {
        Assert.isNotNull((Object)type);
        this.fSuperType = type;
    }
}

