/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.capability.ui.views;

import java.util.ArrayList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IElementChangedListener;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.CapabilityContext;
import org.eclipse.rcptt.core.scenario.CapabilityContextItem;
import org.eclipse.rcptt.core.scenario.ScenarioPackage;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.ctx.capability.CapabilityManager;
import org.eclipse.rcptt.ctx.capability.ui.views.CapabilityDialog;
import org.eclipse.rcptt.ctx.capability.ui.views.ContextFilter;
import org.eclipse.rcptt.ctx.capability.ui.views.Messages;
import org.eclipse.rcptt.ctx.capability.ui.views.OpenContextEditorHelper;
import org.eclipse.rcptt.ctx.capability.ui.views.ResourceUtils;
import org.eclipse.rcptt.ctx.capability.ui.views.WorkspaceChangeListener;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.commons.EObjectTable;
import org.eclipse.rcptt.ui.commons.NamedElementTransfer;
import org.eclipse.rcptt.ui.dialogs.ContextSelectionDialog;
import org.eclipse.rcptt.ui.editors.NamedElementLabelProvider;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ResourceTransfer;

public class CapabiltyContextTable
extends EObjectTable {
    private static NamedElementTransfer TRANSFER = null;
    private final OpenContextEditorHelper openHelper = new OpenContextEditorHelper();
    private final ContextFilter filter = new ContextFilter();
    private final WorkspaceChangeListener workspaceMonitorListener;
    private IQ7NamedElement namedElement;
    private Action editCapability;
    private Action removeCapability;
    private IObservableValue<?> capabilityObservables;

    public CapabiltyContextTable(IQ7NamedElement namedElement, CapabilityContextItem content) {
        super((EObject)content, (EStructuralFeature)ScenarioPackage.Literals.CAPABILITY_CONTEXT_ITEM__CONTEXT_REFERENCES);
        this.setNamedElement(namedElement);
        this.workspaceMonitorListener = new WorkspaceChangeListener(this);
        RcpttCore.addElementChangedListener((IElementChangedListener)this.workspaceMonitorListener);
    }

    public String getName() {
        StringBuilder builder = new StringBuilder();
        EList capability = this.getContent().getCapability();
        int last = capability.size() - 1;
        if (last < 0) {
            return "";
        }
        int i = 0;
        while (i < last) {
            builder.append((String)capability.get(i)).append(", ");
            ++i;
        }
        builder.append((String)capability.get(last));
        return builder.toString().toUpperCase();
    }

    public Image getImage() {
        return Images.getImage((String)"icons/context.gif");
    }

    public void update(EObject content) {
        super.update(content);
        this.capabilityObservables = EMFObservables.observeValue((EObject)this.getContent(), (EStructuralFeature)ScenarioPackage.Literals.CAPABILITY_CONTEXT_ITEM__CAPABILITY);
        this.capabilityObservables.addValueChangeListener((IValueChangeListener)new IValueChangeListener<Object>(){

            public void handleValueChange(ValueChangeEvent<? extends Object> event) {
                CapabiltyContextTable.this.updateActionTooltip();
            }
        });
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                CapabiltyContextTable.this.openHelper.open(selection, CapabiltyContextTable.this.namedElement.getQ7Project());
            }
        });
    }

    public void dispose() {
        if (this.capabilityObservables != null) {
            this.capabilityObservables.dispose();
        }
        RcpttCore.removeElementChangedListener((IElementChangedListener)this.workspaceMonitorListener);
        super.dispose();
    }

    protected ILabelProvider createLabelProvider() {
        return new NamedElementLabelProvider(this.getNamedElement().getQ7Project());
    }

    protected Object[] handleAdd() {
        ContextSelectionDialog dialog = new ContextSelectionDialog(this.getControl().getShell(), this.getNamedElement(), null){

            protected boolean isValidToAdd(IContext context) {
                return CapabiltyContextTable.this.filter.isValidToAdd((IQ7NamedElement)context, CapabiltyContextTable.this.getNamedElement());
            }
        };
        if (dialog.open() == 0) {
            Object[] selected = dialog.getResult();
            ArrayList<String> list = new ArrayList<String>();
            if (selected != null) {
                int i = 0;
                while (i < selected.length) {
                    IContext context = (IContext)selected[i];
                    try {
                        String id = Q7SearchCore.findIDByDocument((IQ7Element)context);
                        if (id == null) {
                            id = context.getID();
                        }
                        list.add(id);
                    }
                    catch (ModelException e) {
                        Q7UIPlugin.log((Throwable)e);
                    }
                    ++i;
                }
            }
            this.setVisible(true);
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    protected Class<?> getContentsType() {
        return String.class;
    }

    protected Transfer getContentTransfer() {
        if (TRANSFER == null) {
            TRANSFER = new NamedElementTransfer();
        }
        return TRANSFER;
    }

    protected IQ7Element.HandleType getAppropriateHandleType() {
        return IQ7Element.HandleType.Context;
    }

    protected CapabilityContextItem getContent() {
        return (CapabilityContextItem)this.content;
    }

    protected void fillActions(IToolBarManager toolBarManager) {
        super.fillActions(toolBarManager);
        this.editCapability = new Action(){

            public void run() {
                CapabiltyContextTable.this.handleEditItem();
            }
        };
        this.editCapability.setImageDescriptor(Images.getImageDescriptor((String)"icons/panel/menu.gif"));
        this.removeCapability = new Action(){

            public void run() {
                CapabiltyContextTable.this.handleRemoveItem();
            }
        };
        this.removeCapability.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_CLEAR"));
        this.updateActionTooltip();
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.editCapability);
        toolBarManager.add((IAction)this.removeCapability);
    }

    protected boolean allowDrag(IStructuredSelection selection) {
        if (!super.allowDrag(selection)) {
            return false;
        }
        Object element = selection.getFirstElement();
        return element != null && element instanceof String;
    }

    protected boolean doPerformDrop(Object data, Object currentTarget, int currentLocation) {
        if (data instanceof IResource[]) {
            IResource[] resources = (IResource[])data;
            EList content = this.getContents();
            int targetPosition = content.size() - 1;
            if (currentTarget != null) {
                targetPosition = content.indexOf(currentTarget);
            }
            if (currentLocation == 2 || currentLocation == 4) {
                ++targetPosition;
            }
            EList contents = this.getContents();
            ArrayList<String> newContents = new ArrayList<String>();
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                IQ7NamedElement element = ResourceUtils.getNamedElementByResource(resource);
                if (this.filter.isValidToAdd(element, this.getNamedElement())) {
                    try {
                        newContents.add(element.getID());
                    }
                    catch (ModelException e) {
                        Q7UIPlugin.log((Throwable)e);
                    }
                }
                ++n2;
            }
            if (targetPosition != -1) {
                contents.addAll(targetPosition, newContents);
            } else {
                contents.addAll(newContents);
            }
            this.refresh();
            return true;
        }
        return super.doPerformDrop(data, currentTarget, currentLocation);
    }

    protected boolean doValidateDrop(Object target, int operation, TransferData transferType, int currentLocation) {
        if (ResourceTransfer.getInstance().isSupportedType(transferType)) {
            IResource[] resources;
            IResource[] iResourceArray = resources = ResourceUtils.getSelectedResources();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                IQ7NamedElement element = ResourceUtils.getNamedElementByResource(resource);
                if (this.filter.isValidToAdd(element, this.getNamedElement())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return super.doValidateDrop(target, operation, transferType, currentLocation);
    }

    protected Transfer[] getDropTransferTypes() {
        Transfer[] base = super.getDropTransferTypes();
        Transfer[] result = new Transfer[base.length + 1];
        int i = 0;
        while (i < base.length) {
            result[i] = base[i];
            ++i;
        }
        result[base.length] = ResourceTransfer.getInstance();
        return result;
    }

    protected void handleRemoveItem() {
        this.getContext().getItems().remove((Object)this.getContent());
    }

    protected void handleEditItem() {
        CapabilityDialog dialog = new CapabilityDialog(this.getControl().getShell(), this.getContext(), this.getContent());
        if (dialog.open() == 0) {
            CapabilityManager.getManager().updateCapabilityItem(this.getContent(), dialog.getResult());
        }
    }

    protected CapabilityContext getContext() {
        return (CapabilityContext)this.getContent().eContainer();
    }

    private void updateActionTooltip() {
        String name = this.getName();
        this.editCapability.setText(Messages.CapabiltyContextTable_EditActionTooltip + name);
        this.removeCapability.setText(Messages.CapabiltyContextTable_DeleteActionTooltip + name);
    }

    IQ7NamedElement getNamedElement() {
        return this.namedElement;
    }

    void setNamedElement(IQ7NamedElement namedElement) {
        this.namedElement = namedElement;
    }

    TableViewer getTableViewer() {
        return this.viewer;
    }
}

