/*******************************************************************************
 * Copyright (c) 2009, 2019 Xored Software Inc and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *     Xored Software Inc - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.rcptt.launching.remote;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.rcptt.core.launching.events.AutReconnect;
import org.eclipse.rcptt.core.launching.events.EventsFactory;
import org.eclipse.rcptt.internal.launching.aut.BaseAutLaunch;
import org.eclipse.rcptt.internal.launching.aut.BaseAutManager;
import org.eclipse.rcptt.launching.IQ7Launch;
import org.eclipse.rcptt.launching.Q7Launcher;
import org.eclipse.rcptt.launching.events.AutEventManager;

/**
 * Version of this plugin is strictly requires eclipse 3.6
 *
 * @author haiodo
 *
 */
public class Q7RemoteLaunchDelegate implements ILaunchConfigurationDelegate2 {

	@Override
	public void launch(ILaunchConfiguration configuration, String mode,
			ILaunch launch, IProgressMonitor monitor) throws CoreException {

		int ecl = configuration.getAttribute(IQ7Launch.ATTR_ECL_PORT, -1);
		int tesla = configuration.getAttribute(IQ7Launch.ATTR_TESLA_PORT, -1);
		String host = configuration.getAttribute(IQ7Launch.ATTR_HOST, IQ7Launch.DEFAULT_HOST);
		String platform = configuration.getAttribute(IQ7Launch.ATTR_AUT_PLATFORM, IQ7Launch.DEFAULT_PLATFORM);
		String capability = configuration.getAttribute(IQ7Launch.ATTR_AUT_CAPABILITY, IQ7Launch.DEFAULT_CAPABILITY);
		BaseAutLaunch aut = BaseAutManager.INSTANCE.getByLaunch(launch);
		aut.activate(host, ecl, tesla, platform, capability, 2, monitor);

		AutReconnect reconnect = EventsFactory.eINSTANCE.createAutReconnect();
		reconnect.setQ7EclPort(AutEventManager.INSTANCE.getPort());
		reconnect.setId(aut.getId());
		try {
			aut.execute(reconnect, Q7Launcher.getLaunchTimeout()* 1000, monitor);
		} catch (InterruptedException e) {
			Q7RemoteLaunchingPlugin.getDefault().log(e);
		}

		EclActivityMonitor process = new EclActivityMonitor(aut);
		process.startMonitor();
		launch.addProcess(process);
	}

	@Override
	public ILaunch getLaunch(ILaunchConfiguration configuration, String mode)
			throws CoreException {
		return null;
	}

	@Override
	public boolean buildForLaunch(ILaunchConfiguration configuration,
			String mode, IProgressMonitor monitor) throws CoreException {
		return false;
	}

	@Override
	public boolean finalLaunchCheck(ILaunchConfiguration configuration,
			String mode, IProgressMonitor monitor) throws CoreException {
		return true;
	}

	@Override
	public boolean preLaunchCheck(ILaunchConfiguration configuration,
			String mode, IProgressMonitor monitor) throws CoreException {
		return true;
	}
}
