/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.rap;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.rcptt.internal.launching.aut.BaseAutLaunch;
import org.eclipse.rcptt.launching.AutLaunchState;
import org.eclipse.rcptt.launching.ILaunchExecutor;
import org.eclipse.rcptt.tesla.core.TeslaLimits;

public class RapLaunchExecutor
implements ILaunchExecutor {
    public ILaunch launch(String mode, ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        return config.launch(mode, monitor);
    }

    public void waitForRestart(BaseAutLaunch launch, IProgressMonitor monitor) throws CoreException {
        long startTime = System.currentTimeMillis();
        try {
            String lastUUID = launch.getLastActivateID();
            while (launch.getLastActivateID().equals(lastUUID) && !launch.getState().equals((Object)AutLaunchState.TERMINATE)) {
                this.waitFor(100L, startTime);
            }
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(8, "org.eclipse.rcptt.launching", e.getMessage(), (Throwable)e));
        }
    }

    private void waitFor(long time, long startTime) throws InterruptedException, CoreException {
        Thread.sleep(time);
        long currentTime = System.currentTimeMillis();
        if (currentTime > startTime + (long)TeslaLimits.getAUTStartupTimeout()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.launching", "Waiting for restart failed: timeout error"));
        }
    }
}

