/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.model.search;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.rcptt.core.model.search.IIndexRequestor;
import org.eclipse.rcptt.core.model.search.ISearchPattern;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.internal.core.jobs.IJob;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.core.model.index.Index;
import org.eclipse.rcptt.internal.core.model.index.IndexManager;
import org.eclipse.rcptt.internal.core.model.index.ReadWriteMonitor;

public class PatternSearchJob
implements IJob {
    protected boolean areIndexesReady;
    protected long executionTime = 0L;
    private ISearchScope scope;
    private ISearchPattern pattern;
    private IIndexRequestor requestor;

    public PatternSearchJob(ISearchPattern pattern, ISearchScope scope, IIndexRequestor requestor) {
        this.pattern = pattern;
        this.scope = scope;
        this.requestor = requestor;
    }

    @Override
    public boolean belongsTo(String jobFamily) {
        return true;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void ensureReadyToRun() {
        if (!this.areIndexesReady) {
            this.getIndexes(null);
        }
    }

    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        boolean isComplete = true;
        this.executionTime = 0L;
        Index[] indexes = this.getIndexes(progressMonitor);
        try {
            int max = indexes.length;
            if (progressMonitor != null) {
                progressMonitor.beginTask("", max);
            }
            int i = 0;
            while (i < max) {
                isComplete &= this.search(indexes[i], progressMonitor);
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    progressMonitor.worked(1);
                }
                ++i;
            }
            boolean bl = isComplete;
            return bl;
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
        }
    }

    public Index[] getIndexes(IProgressMonitor progressMonitor) {
        IPath[] paths;
        ArrayList<Index> indexes = new ArrayList<Index>();
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        IPath[] iPathArray = paths = this.scope.getPaths();
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath iPath = iPathArray[n2];
            Index index = indexManager.getIndex(iPath);
            if (index != null) {
                indexes.add(index);
            }
            ++n2;
        }
        return indexes.toArray(new Index[indexes.size()]);
    }

    public boolean search(Index index, IProgressMonitor progressMonitor) {
        if (index == null) {
            return true;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return true;
        }
        try {
            monitor.enterRead();
            long start = System.currentTimeMillis();
            this.pattern.findIndexMatches(index, progressMonitor, this.requestor);
            this.executionTime += System.currentTimeMillis() - start;
            return true;
        }
        finally {
            monitor.exitRead();
        }
    }

    public String toString() {
        return "searching " + this.pattern.toString();
    }
}

