/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.buildpath;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathVariableInitializer;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.buildpath.BuildPathSupport;

public class JUnitHomeInitializer
extends ClasspathVariableInitializer {
    public void initialize(String variable) {
        if ("JUNIT_HOME".equals(variable)) {
            this.initializeHome();
        } else if ("JUNIT_SRC_HOME".equals(variable)) {
            this.initializeSource();
        }
    }

    private void initializeHome() {
        try {
            IPath location = BuildPathSupport.JUNIT3_PLUGIN.getBundleLocation();
            if (location == null) {
                location = BuildPathSupport.JUNIT4_PLUGIN.getBundleLocation();
            }
            if (location != null) {
                JavaCore.setClasspathVariable((String)"JUNIT_HOME", (IPath)location, null);
            } else {
                JavaCore.removeClasspathVariable((String)"JUNIT_HOME", null);
            }
        }
        catch (JavaModelException e1) {
            JavaCore.removeClasspathVariable((String)"JUNIT_HOME", null);
        }
    }

    private void initializeSource() {
        try {
            IPath sourceLocation = BuildPathSupport.JUNIT3_PLUGIN.getSourceBundleLocation();
            if (sourceLocation == null) {
                sourceLocation = BuildPathSupport.JUNIT4_PLUGIN.getSourceBundleLocation();
            }
            if (sourceLocation != null) {
                JavaCore.setClasspathVariable((String)"JUNIT_SRC_HOME", (IPath)sourceLocation, null);
            } else {
                JavaCore.removeClasspathVariable((String)"JUNIT_SRC_HOME", null);
            }
        }
        catch (JavaModelException e1) {
            JavaCore.removeClasspathVariable((String)"JUNIT_SRC_HOME", null);
        }
    }
}

