/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.comparator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.pde.api.tools.internal.util.Util;

class TypeParameterDescriptor {
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    String classBound;
    List<String> interfaceBounds;
    String name;

    public TypeParameterDescriptor(String name) {
        this.name = name;
    }

    public void addInterfaceBound(String bound) {
        if (this.interfaceBounds == null) {
            this.interfaceBounds = new ArrayList<String>();
        }
        this.interfaceBounds.add(bound);
    }

    public void setClassBound(String bound) {
        if (JAVA_LANG_OBJECT.equals(bound)) {
            return;
        }
        this.classBound = bound;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("type parameter ").append(this.name).append(" : ").append(Util.LINE_DELIMITER);
        if (this.classBound != null) {
            buffer.append("class bound : ").append(this.classBound).append(Util.LINE_DELIMITER);
        }
        if (this.interfaceBounds != null) {
            buffer.append("interface bounds : ");
            int i = 0;
            for (String string : this.interfaceBounds) {
                if (i > 0) {
                    buffer.append(',');
                }
                ++i;
                buffer.append(string);
            }
            buffer.append(Util.LINE_DELIMITER);
        }
        return String.valueOf(buffer);
    }
}

