/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractSimpleConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LiteralComparatorFilter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;

public class MinExclusiveConstraintComponent
extends AbstractSimpleConstraintComponent {
    Literal minExclusive;

    public MinExclusiveConstraintComponent(Literal minExclusive) {
        this.minExclusive = minExclusive;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.MIN_EXCLUSIVE, (Value)this.minExclusive, new Resource[0]);
    }

    @Override
    String getSparqlFilterExpression(StatementMatcher.Variable<Value> variable, boolean negated) {
        if (negated) {
            return this.literalToString(this.minExclusive) + " < " + variable.asSparqlVariable();
        }
        return this.literalToString(this.minExclusive) + " >= " + variable.asSparqlVariable();
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.MinExclusiveConstraintComponent;
    }

    @Override
    public ConstraintComponent deepClone() {
        return new MinExclusiveConstraintComponent(this.minExclusive);
    }

    @Override
    Function<PlanNode, FilterPlanNode> getFilterAttacher(ConnectionsGroup connectionsGroup) {
        return parent -> new LiteralComparatorFilter((PlanNode)parent, this.minExclusive, Compare.CompareOp.LT, connectionsGroup);
    }

    @Override
    public List<Literal> getDefaultMessage() {
        return List.of();
    }

    @Override
    public boolean equals(ConstraintComponent o, IdentityHashMap<Shape, Shape> kvIdentityHashMap) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinExclusiveConstraintComponent that = (MinExclusiveConstraintComponent)o;
        return this.minExclusive.equals((Object)that.minExclusive);
    }

    @Override
    public int hashCode(IdentityHashMap<Shape, Boolean> identityHashMap) {
        return this.minExclusive.hashCode() + "MinExclusiveConstraintComponent".hashCode();
    }
}

