/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.TupleExprIRRenderer;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPrinter;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrTripleLike;

public class IrStatementPattern
extends IrTripleLike {
    private final Var predicate;

    public IrStatementPattern(Var subject, Var predicate, Var object, boolean newScope) {
        super(subject, object, newScope);
        this.predicate = predicate;
    }

    public Var getPredicate() {
        return this.predicate;
    }

    @Override
    public String getPredicateOrPathText(TupleExprIRRenderer r) {
        Var pv = this.getPredicate();
        if (IrStatementPattern.isRdfTypePredicate(pv)) {
            return "a";
        }
        return r.convertVarIriToString(pv);
    }

    @Override
    public void print(IrPrinter p) {
        p.startLine();
        if (this.getSubjectOverride() != null) {
            this.getSubjectOverride().print(p);
        } else {
            p.append(p.convertVarToString(this.getSubject()));
        }
        String predText = IrStatementPattern.isRdfTypePredicate(this.getPredicate()) ? "a" : p.convertVarToString(this.getPredicate());
        p.append(" " + predText + " ");
        if (this.getObjectOverride() != null) {
            this.getObjectOverride().print(p);
        } else {
            p.append(p.convertVarToString(this.getObject()));
        }
        p.append(" .");
        p.endLine();
    }

    public String toString() {
        return "IrStatementPattern{subject=" + String.valueOf(this.subject) + ", subjectOverride=" + String.valueOf(this.subjectOverride) + ", predicate=" + String.valueOf(this.predicate) + ", object=" + String.valueOf(this.object) + ", objectOverride=" + String.valueOf(this.objectOverride) + "}";
    }

    @Override
    public Set<Var> getVars() {
        HashSet<Var> out = new HashSet<Var>(super.getVars());
        if (this.predicate != null) {
            out.add(this.predicate);
        }
        return out;
    }

    private static boolean isRdfTypePredicate(Var v) {
        return v != null && v.hasValue() && v.getValue() instanceof IRI && RDF.TYPE.equals((Object)v.getValue());
    }
}

