/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.StampedLockManager;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.model.vocabulary.SESAME;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UpdateContext;
import org.eclipse.rdf4j.sail.helpers.AbstractSailConnection;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailConnectionWrapper;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.shacl.ConnectionHelper;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.ShaclSailValidationException;
import org.eclipse.rdf4j.sail.shacl.ShapeValidationContainer;
import org.eclipse.rdf4j.sail.shacl.Stats;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.ContextWithShape;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.results.ValidationReport;
import org.eclipse.rdf4j.sail.shacl.results.lazy.LazyValidationReport;
import org.eclipse.rdf4j.sail.shacl.results.lazy.ValidationResultIterator;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.VerySimpleRdfsBackwardsChainingConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaclSailConnection
extends NotifyingSailConnectionWrapper
implements SailConnectionListener {
    private static final Logger logger = LoggerFactory.getLogger(ShaclSailConnection.class);
    private final SailConnection previousStateConnection;
    private final SailConnection serializableConnection;
    private final boolean useDefaultShapesGraph;
    private IRI[] shapesGraphs;
    Sail addedStatements;
    Sail removedStatements;
    Sail addedStatementsInferred;
    Sail removedStatementsInferred;
    Sail addedStatementsRdfsInferred;
    Sail removedStatementsRdfsInferred;
    Sail addedStatementsWithInferred;
    Sail removedStatementsWithInferred;
    Sail addedStatementsWithRdfsInferred;
    Sail removedStatementsWithRdfsInferred;
    Sail addedStatementsWithInferredAndRdfs;
    Sail removedStatementsWithInferredAndRdfs;
    private final HashSet<Statement> addedStatementsSet = new HashSet();
    private final HashSet<Statement> removedStatementsSet = new HashSet();
    private final HashSet<Statement> addedStatementsInferredSet = new HashSet();
    private final HashSet<Statement> removedStatementsInferredSet = new HashSet();
    private boolean shapeRefreshNeeded = false;
    private boolean legacyStatementAddedWithoutInferredFlagObserved = false;
    private boolean legacyStatementRemovedWithoutInferredFlagObserved = false;
    private boolean shapesModifiedInCurrentTransaction = false;
    public final ShaclSail sail;
    private Stats stats;
    RdfsSubClassOfReasoner rdfsSubClassOfReasoner;
    private boolean prepareHasBeenCalled = false;
    private Lock exclusiveSerializableValidationLock;
    private Lock nonExclusiveSerializableValidationLock;
    private StampedLockManager.Cache.WritableState writableShapesCache;
    private StampedLockManager.Cache.ReadableState readableShapesCache;
    private final SailRepositoryConnection shapesRepoConnection;
    private boolean connectionListenerActive = false;
    private IsolationLevel currentIsolationLevel = null;
    private Settings transactionSettings;
    private TransactionSetting[] transactionSettingsRaw = new TransactionSetting[0];
    private volatile boolean closed;
    private volatile List<Future<ValidationResultIterator>> futures;
    private List<ShapeValidationContainer> shapeValidatorContainers;

    ShaclSailConnection(ShaclSail sail, NotifyingSailConnection connection, SailConnection previousStateConnection, SailRepositoryConnection shapesRepoConnection, SailConnection serializableConnection) {
        super(connection);
        this.previousStateConnection = previousStateConnection;
        this.shapesRepoConnection = shapesRepoConnection;
        this.serializableConnection = serializableConnection;
        this.sail = sail;
        this.transactionSettings = this.getDefaultSettings(sail);
        this.useDefaultShapesGraph = sail.getShapesGraphs().contains(RDF4J.SHACL_SHAPE_GRAPH);
    }

    ShaclSailConnection(ShaclSail sail, NotifyingSailConnection connection, SailConnection previousStateConnection, SailRepositoryConnection shapesRepoConnection) {
        super(connection);
        this.previousStateConnection = previousStateConnection;
        this.shapesRepoConnection = shapesRepoConnection;
        this.serializableConnection = null;
        this.sail = sail;
        this.transactionSettings = this.getDefaultSettings(sail);
        this.useDefaultShapesGraph = sail.getShapesGraphs().contains(RDF4J.SHACL_SHAPE_GRAPH);
    }

    ShaclSailConnection(ShaclSail sail, NotifyingSailConnection connection, SailRepositoryConnection shapesRepoConnection, SailConnection serializableConnection) {
        super(connection);
        this.previousStateConnection = null;
        this.shapesRepoConnection = shapesRepoConnection;
        this.serializableConnection = serializableConnection;
        this.sail = sail;
        this.transactionSettings = this.getDefaultSettings(sail);
        this.useDefaultShapesGraph = sail.getShapesGraphs().contains(RDF4J.SHACL_SHAPE_GRAPH);
    }

    ShaclSailConnection(ShaclSail sail, NotifyingSailConnection connection, SailRepositoryConnection shapesRepoConnection) {
        super(connection);
        this.previousStateConnection = null;
        this.serializableConnection = null;
        this.shapesRepoConnection = shapesRepoConnection;
        this.sail = sail;
        this.transactionSettings = this.getDefaultSettings(sail);
        this.useDefaultShapesGraph = sail.getShapesGraphs().contains(RDF4J.SHACL_SHAPE_GRAPH);
    }

    private Settings getDefaultSettings(ShaclSail sail) {
        return new Settings(sail.isCacheSelectNodes(), sail.isValidationEnabled(), sail.isParallelValidation(), this.currentIsolationLevel);
    }

    public void setTransactionSettings(TransactionSetting ... settings) {
        super.setTransactionSettings(settings);
        this.transactionSettingsRaw = settings;
    }

    public void begin() throws SailException {
        this.begin(this.sail.getDefaultIsolationLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(IsolationLevel level) throws SailException {
        if (this.closed) {
            throw new SailException("Connection is closed");
        }
        if (this.sail.isShutdown()) {
            throw new SailException("Sail is shutdown");
        }
        this.shapeValidatorContainers = new ArrayList<ShapeValidationContainer>();
        this.currentIsolationLevel = level;
        assert (this.addedStatements == null);
        assert (this.removedStatements == null);
        assert (this.readableShapesCache == null);
        assert (this.writableShapesCache == null);
        assert (this.nonExclusiveSerializableValidationLock == null);
        assert (this.exclusiveSerializableValidationLock == null);
        assert (this.shapesGraphs == null);
        this.shapesGraphs = (IRI[])this.sail.getShapesGraphs().stream().map(g -> {
            if (g.equals((Object)RDF4J.NIL)) {
                return null;
            }
            if (g.equals((Object)SESAME.NIL)) {
                return null;
            }
            return g;
        }).toArray(IRI[]::new);
        this.stats = new Stats();
        ShaclSail shaclSail = this.sail;
        synchronized (shaclSail) {
            super.begin(level);
            this.hasStatement(null, null, null, false, new Resource[0]);
            this.shapesRepoConnection.begin(this.currentIsolationLevel);
            if (this.previousStateConnection != null) {
                this.previousStateConnection.begin(this.currentIsolationLevel);
                this.previousStateConnection.hasStatement(null, null, null, false, new Resource[0]);
            }
        }
        this.stats.setEmptyBeforeTransaction(ConnectionHelper.isEmpty((SailConnection)this));
        this.transactionSettings = this.getDefaultSettings(this.sail);
        if (this.stats.wasEmptyBeforeTransaction() && !this.shouldUseSerializableValidation()) {
            this.transactionSettings.switchToBulkValidation();
        }
        this.transactionSettings.applyTransactionSettings(this.getLocalTransactionSettings());
        assert (this.transactionSettings.parallelValidation != null);
        assert (this.transactionSettings.cacheSelectedNodes != null);
        assert (this.transactionSettings.validationApproach != null);
        if (this.isBulkValidation() || !this.isValidationEnabled()) {
            this.removeConnectionListener(this);
        } else {
            this.addConnectionListener(this);
        }
    }

    private Settings getLocalTransactionSettings() {
        return new Settings(this);
    }

    public void addConnectionListener(SailConnectionListener listener) {
        if (!this.connectionListenerActive && this.isValidationEnabled()) {
            super.addConnectionListener((SailConnectionListener)this);
            this.connectionListenerActive = true;
        }
    }

    boolean isValidationEnabled() {
        return this.transactionSettings.getValidationApproach() != ShaclSail.TransactionSettings.ValidationApproach.Disabled;
    }

    public void removeConnectionListener(SailConnectionListener listener) {
        super.removeConnectionListener(listener);
        this.connectionListenerActive = false;
    }

    private Sail getNewMemorySail() {
        MemoryStore sail = new MemoryStore();
        sail.setDefaultIsolationLevel((IsolationLevel)IsolationLevels.NONE);
        sail.init();
        return sail;
    }

    public void commit() throws SailException {
        if (this.closed) {
            throw new SailException("Connection is closed");
        }
        if (!this.prepareHasBeenCalled) {
            this.prepare();
        }
        try {
            long before = this.getTimeStamp();
            if (this.previousStateConnection != null) {
                this.previousStateConnection.commit();
            }
            super.commit();
            this.shapesRepoConnection.commit();
            if (this.sail.isPerformanceLogging()) {
                logger.info("commit() excluding validation and cleanup took {} ms", (Object)(this.getTimeStamp() - before));
            }
        }
        finally {
            this.cleanup();
        }
    }

    public void addStatement(UpdateContext modify, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (this.useDefaultShapesGraph && contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals((Object)contexts[0])) {
            this.shapesRepoConnection.add(subj, pred, obj, contexts);
            this.markShapesRefreshNeeded();
        } else {
            super.addStatement(modify, subj, pred, obj, contexts);
        }
    }

    public void removeStatement(UpdateContext modify, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (this.useDefaultShapesGraph && contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals((Object)contexts[0])) {
            this.shapesRepoConnection.remove(subj, pred, obj, contexts);
            this.markShapesRefreshNeeded();
        } else {
            super.removeStatement(modify, subj, pred, obj, contexts);
        }
    }

    public void addStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (this.useDefaultShapesGraph && contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals((Object)contexts[0])) {
            this.shapesRepoConnection.add(subj, pred, obj, contexts);
            this.markShapesRefreshNeeded();
        } else {
            super.addStatement(subj, pred, obj, contexts);
        }
    }

    public void removeStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (this.useDefaultShapesGraph && contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals((Object)contexts[0])) {
            this.shapesRepoConnection.remove(subj, pred, obj, contexts);
            this.markShapesRefreshNeeded();
        } else {
            super.removeStatements(subj, pred, obj, contexts);
        }
    }

    public void clear(Resource ... contexts) throws SailException {
        if (Arrays.asList(contexts).contains(RDF4J.SHACL_SHAPE_GRAPH)) {
            this.shapesRepoConnection.clear(new Resource[0]);
            this.markShapesRefreshNeeded();
        }
        super.clear(contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SailException {
        block154: {
            if (this.closed) {
                throw new SailException("Connection is closed");
            }
            try {
                if (this.readableShapesCache == null) break block154;
                try {
                    this.readableShapesCache.close();
                }
                finally {
                    this.readableShapesCache = null;
                }
            }
            finally {
                block155: {
                    try {
                        if (this.writableShapesCache == null) break block155;
                        try {
                            this.writableShapesCache.purge();
                        }
                        finally {
                            try {
                                this.writableShapesCache.close();
                            }
                            finally {
                                this.writableShapesCache = null;
                            }
                        }
                    }
                    finally {
                        try {
                            if (this.previousStateConnection != null && this.previousStateConnection.isActive()) {
                                this.previousStateConnection.rollback();
                            }
                        }
                        finally {
                            try {
                                if (this.serializableConnection != null && this.serializableConnection.isActive()) {
                                    this.serializableConnection.rollback();
                                }
                            }
                            finally {
                                try {
                                    if (this.shapesRepoConnection.isActive()) {
                                        this.shapesRepoConnection.rollback();
                                    }
                                }
                                finally {
                                    try {
                                        if (this.isActive()) {
                                            super.rollback();
                                        }
                                    }
                                    finally {
                                        this.cleanup();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        long before = 0L;
        try {
            if (this.sail.isPerformanceLogging()) {
                before = System.currentTimeMillis();
            }
            logger.debug("Cleanup");
            if (this.addedStatements != null) {
                if (this.addedStatements != this.sail.getBaseSail()) {
                    this.addedStatements.shutDown();
                }
                this.addedStatements = null;
            }
            if (this.removedStatements != null) {
                this.removedStatements.shutDown();
                this.removedStatements = null;
            }
            if (this.addedStatementsInferred != null) {
                this.addedStatementsInferred.shutDown();
                this.addedStatementsInferred = null;
            }
            if (this.removedStatementsInferred != null) {
                this.removedStatementsInferred.shutDown();
                this.removedStatementsInferred = null;
            }
            if (this.addedStatementsRdfsInferred != null) {
                this.addedStatementsRdfsInferred.shutDown();
                this.addedStatementsRdfsInferred = null;
            }
            if (this.removedStatementsRdfsInferred != null) {
                this.removedStatementsRdfsInferred.shutDown();
                this.removedStatementsRdfsInferred = null;
            }
            if (this.addedStatementsWithInferred != null) {
                this.addedStatementsWithInferred.shutDown();
                this.addedStatementsWithInferred = null;
            }
            if (this.removedStatementsWithInferred != null) {
                this.removedStatementsWithInferred.shutDown();
                this.removedStatementsWithInferred = null;
            }
            if (this.addedStatementsWithRdfsInferred != null) {
                this.addedStatementsWithRdfsInferred.shutDown();
                this.addedStatementsWithRdfsInferred = null;
            }
            if (this.removedStatementsWithRdfsInferred != null) {
                this.removedStatementsWithRdfsInferred.shutDown();
                this.removedStatementsWithRdfsInferred = null;
            }
            if (this.addedStatementsWithInferredAndRdfs != null) {
                this.addedStatementsWithInferredAndRdfs.shutDown();
                this.addedStatementsWithInferredAndRdfs = null;
            }
            if (this.removedStatementsWithInferredAndRdfs != null) {
                this.removedStatementsWithInferredAndRdfs.shutDown();
                this.removedStatementsWithInferredAndRdfs = null;
            }
            this.addedStatementsSet.clear();
            this.removedStatementsSet.clear();
            this.addedStatementsInferredSet.clear();
            this.removedStatementsInferredSet.clear();
            this.stats = null;
            this.prepareHasBeenCalled = false;
            this.shapeRefreshNeeded = false;
            this.legacyStatementAddedWithoutInferredFlagObserved = false;
            this.legacyStatementRemovedWithoutInferredFlagObserved = false;
            this.shapesModifiedInCurrentTransaction = false;
            this.currentIsolationLevel = null;
            this.shapesGraphs = null;
        }
        finally {
            try {
                this.cleanupShapesReadWriteLock();
            }
            finally {
                this.cleanupReadWriteLock();
            }
            if (this.sail.isPerformanceLogging()) {
                logger.info("cleanup() took {} ms", (Object)(System.currentTimeMillis() - before));
            }
        }
    }

    private void cleanupShapesReadWriteLock() {
        block7: {
            try {
                if (this.writableShapesCache == null) break block7;
                try {
                    this.writableShapesCache.purge();
                }
                finally {
                    this.writableShapesCache.close();
                }
            }
            finally {
                if (this.readableShapesCache != null) {
                    this.readableShapesCache.close();
                }
            }
        }
        this.writableShapesCache = null;
        this.readableShapesCache = null;
    }

    private void cleanupReadWriteLock() {
        try {
            if (this.exclusiveSerializableValidationLock != null) {
                this.exclusiveSerializableValidationLock.release();
            }
        }
        finally {
            if (this.nonExclusiveSerializableValidationLock != null) {
                this.nonExclusiveSerializableValidationLock.release();
            }
        }
        this.exclusiveSerializableValidationLock = null;
        this.nonExclusiveSerializableValidationLock = null;
    }

    private ValidationReport validate(List<ContextWithShape> shapes, boolean validateEntireBaseSail) throws InterruptedException {
        assert (this.isValidationEnabled());
        try {
            ConnectionsGroup connectionsGroup = this.getConnectionsGroup();
            try {
                ValidationReport validationReport = this.performValidation(shapes, validateEntireBaseSail, connectionsGroup, (SailConnection)this, this.previousStateConnection);
                if (connectionsGroup != null) {
                    connectionsGroup.close();
                }
                return validationReport;
            }
            catch (Throwable throwable) {
                if (connectionsGroup != null) {
                    try {
                        connectionsGroup.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.rdfsSubClassOfReasoner = null;
        }
    }

    void prepareValidation(ValidationSettings validationSettings, boolean requireRdfsSubClassReasoning) throws InterruptedException {
        assert (this.isValidationEnabled());
        this.rdfsSubClassOfReasoner = requireRdfsSubClassReasoning ? RdfsSubClassOfReasoner.createReasoner((SailConnection)this, validationSettings) : null;
        if (this.sail.isShutdown()) {
            throw new SailException("Sail is shutdown");
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.isBulkValidation()) {
            this.fillAddedAndRemovedStatementRepositories();
        }
    }

    ConnectionsGroup getConnectionsGroup() {
        return this.getConnectionsGroup((SailConnection)this, this.previousStateConnection, this.sail.isIncludeInferredStatements(), this.sail.isRdfsSubClassReasoning());
    }

    ConnectionsGroup getConnectionsGroup(SailConnection baseConnection, SailConnection previousStateConnection, boolean includeInferredStatements, boolean useRdfsSubClassReasoning) {
        RdfsSubClassOfReasoner reasoner = useRdfsSubClassReasoning ? this.rdfsSubClassOfReasoner : null;
        ConnectionsGroup.RdfsSubClassOfReasonerProvider provider = reasoner == null ? null : () -> reasoner;
        Sail effectiveAddedStatements = this.getEffectiveAddedStatements(includeInferredStatements, useRdfsSubClassReasoning);
        Sail effectiveRemovedStatements = this.getEffectiveRemovedStatements(includeInferredStatements, useRdfsSubClassReasoning);
        return new ConnectionsGroup((SailConnection)new VerySimpleRdfsBackwardsChainingConnection(baseConnection, reasoner, includeInferredStatements), previousStateConnection, effectiveAddedStatements, effectiveRemovedStatements, this.stats, provider, includeInferredStatements, this.transactionSettings, this.sail.sparqlValidation);
    }

    private Sail getEffectiveAddedStatements(boolean includeInferredStatements, boolean useRdfsSubClassReasoning) {
        boolean includeRdfsInferred;
        boolean includeBaseInferred = includeInferredStatements && this.addedStatementsInferred != null;
        boolean bl = includeRdfsInferred = useRdfsSubClassReasoning && this.addedStatementsRdfsInferred != null;
        if (!includeBaseInferred && !includeRdfsInferred) {
            return this.addedStatements;
        }
        if (includeBaseInferred && includeRdfsInferred) {
            if (this.addedStatementsWithInferredAndRdfs == null) {
                this.addedStatementsWithInferredAndRdfs = this.buildCombinedStatements(this.addedStatements, this.addedStatementsInferred, this.addedStatementsRdfsInferred);
            }
            return this.addedStatementsWithInferredAndRdfs;
        }
        if (includeBaseInferred) {
            if (this.addedStatementsWithInferred == null) {
                this.addedStatementsWithInferred = this.buildCombinedStatements(this.addedStatements, this.addedStatementsInferred, null);
            }
            return this.addedStatementsWithInferred;
        }
        if (this.addedStatementsWithRdfsInferred == null) {
            this.addedStatementsWithRdfsInferred = this.buildCombinedStatements(this.addedStatements, null, this.addedStatementsRdfsInferred);
        }
        return this.addedStatementsWithRdfsInferred;
    }

    private Sail getEffectiveRemovedStatements(boolean includeInferredStatements, boolean useRdfsSubClassReasoning) {
        boolean includeRdfsInferred;
        boolean includeBaseInferred = includeInferredStatements && this.removedStatementsInferred != null;
        boolean bl = includeRdfsInferred = useRdfsSubClassReasoning && this.removedStatementsRdfsInferred != null;
        if (!includeBaseInferred && !includeRdfsInferred) {
            return this.removedStatements;
        }
        if (includeBaseInferred && includeRdfsInferred) {
            if (this.removedStatementsWithInferredAndRdfs == null) {
                this.removedStatementsWithInferredAndRdfs = this.buildCombinedStatements(this.removedStatements, this.removedStatementsInferred, this.removedStatementsRdfsInferred);
            }
            return this.removedStatementsWithInferredAndRdfs;
        }
        if (includeBaseInferred) {
            if (this.removedStatementsWithInferred == null) {
                this.removedStatementsWithInferred = this.buildCombinedStatements(this.removedStatements, this.removedStatementsInferred, null);
            }
            return this.removedStatementsWithInferred;
        }
        if (this.removedStatementsWithRdfsInferred == null) {
            this.removedStatementsWithRdfsInferred = this.buildCombinedStatements(this.removedStatements, null, this.removedStatementsRdfsInferred);
        }
        return this.removedStatementsWithRdfsInferred;
    }

    private Sail buildCombinedStatements(Sail explicitStatements, Sail inferredStatements, Sail rdfsInferredStatements) {
        if (explicitStatements == null && inferredStatements == null && rdfsInferredStatements == null) {
            return null;
        }
        Sail combinedStatements = this.getNewMemorySail();
        try (SailConnection combinedConnection = combinedStatements.getConnection();){
            combinedConnection.begin((IsolationLevel)IsolationLevels.NONE);
            this.copyStatements(explicitStatements, combinedConnection);
            this.copyStatements(inferredStatements, combinedConnection);
            this.copyStatements(rdfsInferredStatements, combinedConnection);
            combinedConnection.commit();
        }
        return combinedStatements;
    }

    private void copyStatements(Sail source, SailConnection target) {
        if (source == null) {
            return;
        }
        try (SailConnection from = source.getConnection();){
            ConnectionHelper.transferStatements(from, (x$0, x$1, x$2, xva$3) -> target.addStatement(x$0, x$1, x$2, new Resource[]{xva$3}));
        }
    }

    private void resetCombinedStatementStores() {
        if (this.addedStatementsWithInferred != null) {
            this.addedStatementsWithInferred.shutDown();
            this.addedStatementsWithInferred = null;
        }
        if (this.removedStatementsWithInferred != null) {
            this.removedStatementsWithInferred.shutDown();
            this.removedStatementsWithInferred = null;
        }
        if (this.addedStatementsWithRdfsInferred != null) {
            this.addedStatementsWithRdfsInferred.shutDown();
            this.addedStatementsWithRdfsInferred = null;
        }
        if (this.removedStatementsWithRdfsInferred != null) {
            this.removedStatementsWithRdfsInferred.shutDown();
            this.removedStatementsWithRdfsInferred = null;
        }
        if (this.addedStatementsWithInferredAndRdfs != null) {
            this.addedStatementsWithInferredAndRdfs.shutDown();
            this.addedStatementsWithInferredAndRdfs = null;
        }
        if (this.removedStatementsWithInferredAndRdfs != null) {
            this.removedStatementsWithInferredAndRdfs.shutDown();
            this.removedStatementsWithInferredAndRdfs = null;
        }
    }

    private boolean requiresRdfsSubClassReasoner(List<ContextWithShape> shapes) {
        return shapes.stream().map(ContextWithShape::getShape).map(Shape::getRdfsSubClassReasoningOverride).anyMatch(Boolean.TRUE::equals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationReport performValidation(List<ContextWithShape> shapes, boolean validateEntireBaseSail, ConnectionsGroup connectionsGroup, SailConnection baseConnection, SailConnection previousStateConnection) throws InterruptedException {
        long beforeValidation = 0L;
        boolean defaultIncludeInferredStatements = this.sail.isIncludeInferredStatements();
        boolean defaultRdfsSubClassReasoning = this.sail.isRdfsSubClassReasoning();
        if (this.sail.isPerformanceLogging()) {
            beforeValidation = System.currentTimeMillis();
        }
        try {
            List<Future<ValidationResultIterator>> list;
            List<Future<ValidationResultIterator>> originalFutures;
            int numberOfShapes = shapes.size();
            Stream<Callable> callableStream = shapes.stream().map(contextWithShapes -> {
                Shape shape = contextWithShapes.getShape();
                boolean shapeRdfsSubClassReasoning = shape.usesRdfsSubClassReasoning(defaultRdfsSubClassReasoning);
                boolean shapeIncludeInferredStatements = shape.usesIncludeInferredStatements(defaultIncludeInferredStatements);
                boolean closeConnectionsGroup = false;
                ConnectionsGroup shapeConnectionsGroup = connectionsGroup;
                if (shapeRdfsSubClassReasoning != defaultRdfsSubClassReasoning || shapeIncludeInferredStatements != defaultIncludeInferredStatements) {
                    shapeConnectionsGroup = this.getConnectionsGroup(baseConnection, previousStateConnection, shapeIncludeInferredStatements, shapeRdfsSubClassReasoning);
                    closeConnectionsGroup = true;
                }
                ConnectionsGroup planConnectionsGroup = shapeConnectionsGroup;
                return new ShapeValidationContainer(shape, () -> shape.generatePlans(planConnectionsGroup, new ValidationSettings(contextWithShapes.getDataGraph(), this.sail.isLogValidationPlans(), validateEntireBaseSail, this.sail.isPerformanceLogging())), this.sail.isGlobalLogValidationExecution(), this.sail.isLogValidationViolations(), this.sail.getEffectiveValidationResultsLimitPerConstraint(), this.sail.isPerformanceLogging(), this.sail.isLogValidationPlans(), logger, shapeConnectionsGroup, closeConnectionsGroup);
            }).filter(ShapeValidationContainer::hasPlanNode).peek(s -> {
                if (this.sail.isShutdown()) {
                    throw new SailException("Sail is shutdown");
                }
                if (this.closed) {
                    throw new SailException("Connection is closed");
                }
                List<ShapeValidationContainer> list = this.shapeValidatorContainers;
                synchronized (list) {
                    try {
                        if (this.closed) {
                            try {
                                s.forceClose();
                            }
                            catch (Throwable ignored) {
                                logger.debug("Throwable was ignored while closing connection", ignored);
                            }
                            throw new SailException("Connection is closed");
                        }
                        this.shapeValidatorContainers.add((ShapeValidationContainer)s);
                    }
                    catch (Throwable t) {
                        try {
                            s.forceClose();
                        }
                        catch (Throwable ignored) {
                            logger.debug("Throwable was ignored while closing connection", ignored);
                        }
                        if (this.closed) {
                            throw new SailException("Connection is closed", t);
                        }
                        throw t;
                    }
                }
            }).map(validationContainer -> validationContainer::performValidation);
            ArrayList<ValidationResultIterator> validationResultIterators = new ArrayList<ValidationResultIterator>(numberOfShapes);
            this.futures = new ArrayList<Future<ValidationResultIterator>>(numberOfShapes);
            boolean parallelValidation = numberOfShapes > 1 && this.isParallelValidation();
            try {
                ArrayDeque<Future<ValidationResultIterator>> futures1;
                callableStream.map(callable -> {
                    if (Thread.currentThread().isInterrupted()) {
                        return null;
                    }
                    if (this.sail.isShutdown()) {
                        throw new SailException("Sail is shutdown");
                    }
                    if (this.closed) {
                        throw new SailException("Connection is closed");
                    }
                    if (parallelValidation) {
                        try {
                            return this.sail.submitToExecutorService(callable);
                        }
                        catch (Throwable e) {
                            if (this.sail.isShutdown()) {
                                throw new SailException("Sail is shutdown", e);
                            }
                            if (this.closed) {
                                throw new SailException("Connection is closed", e);
                            }
                            throw e;
                        }
                    }
                    FutureTask futureTask = new FutureTask(callable);
                    futureTask.run();
                    return futureTask;
                }).filter(Objects::nonNull).forEach(f -> {
                    List<Future<ValidationResultIterator>> list = this.futures;
                    synchronized (list) {
                        try {
                            if (this.closed) {
                                f.cancel(true);
                                throw new SailException("Connection is closed");
                            }
                            this.futures.add((Future<ValidationResultIterator>)f);
                        }
                        catch (Throwable t) {
                            f.cancel(true);
                            if (this.closed) {
                                throw new SailException("Connection is closed", t);
                            }
                            throw t;
                        }
                    }
                });
                boolean done = false;
                List<Future<ValidationResultIterator>> list2 = this.futures;
                synchronized (list2) {
                    futures1 = new ArrayDeque<Future<ValidationResultIterator>>(this.futures);
                }
                while (!futures1.isEmpty()) {
                    Future<ValidationResultIterator> future = futures1.removeFirst();
                    assert (future != null);
                    try {
                        if (this.sail.isShutdown()) {
                            throw new SailException("Sail is shutdown");
                        }
                        if (this.closed) {
                            throw new SailException("Connection is closed");
                        }
                        if (Thread.currentThread().isInterrupted()) continue;
                        ValidationResultIterator validationResultIterator = future.get(100L, TimeUnit.MILLISECONDS);
                        validationResultIterators.add(validationResultIterator);
                    }
                    catch (CancellationException cancellationException) {
                        Thread.currentThread().interrupt();
                        InterruptedException interruptedException = new InterruptedException("Validation future was cancelled");
                        interruptedException.initCause(cancellationException);
                        throw interruptedException;
                    }
                    catch (ExecutionException executionException) {
                        Throwable cause = executionException.getCause();
                        if (cause instanceof InterruptedException) {
                            throw new InterruptedException();
                        }
                        if (cause instanceof RuntimeException) {
                            throw (RuntimeException)cause;
                        }
                        if (cause instanceof Error) {
                            throw (Error)cause;
                        }
                        assert (false);
                        throw new IllegalStateException(cause);
                    }
                    catch (TimeoutException timeoutException) {
                        futures1.addLast(future);
                    }
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                list = originalFutures = this.futures;
            }
            catch (Throwable throwable) {
                List<Future<ValidationResultIterator>> originalFutures2;
                List<Future<ValidationResultIterator>> list2 = originalFutures2 = this.futures;
                synchronized (list2) {
                    for (Future<ValidationResultIterator> future : originalFutures2) {
                        future.cancel(true);
                    }
                    this.futures = List.of();
                }
                throw throwable;
            }
            synchronized (list) {
                for (Future future : originalFutures) {
                    future.cancel(true);
                }
                this.futures = List.of();
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            LazyValidationReport lazyValidationReport = new LazyValidationReport(validationResultIterators, this.sail.getValidationResultsLimitTotal());
            return lazyValidationReport;
        }
        finally {
            if (this.sail.isPerformanceLogging()) {
                logger.info("Actual validation and generating plans took {} ms", (Object)(System.currentTimeMillis() - beforeValidation));
            }
        }
    }

    private boolean isParallelValidation() {
        assert (!this.transactionSettings.isParallelValidation() || this.supportsConcurrentReads());
        assert (this.getIsolationLevel() != IsolationLevels.SERIALIZABLE || !this.transactionSettings.isParallelValidation()) : "Concurrent reads is buggy for SERIALIZABLE transactions.";
        return this.transactionSettings.isParallelValidation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fillAddedAndRemovedStatementRepositories() throws InterruptedException {
        assert (!this.isBulkValidation());
        assert (this.isValidationEnabled());
        long before = 0L;
        if (this.sail.isPerformanceLogging()) {
            before = System.currentTimeMillis();
        }
        ArrayList futures = new ArrayList();
        boolean parallelValidation = this.isParallelValidation() && !this.addedStatementsSet.isEmpty() && !this.removedStatementsSet.isEmpty();
        this.resetCombinedStatementStores();
        try {
            Stream.of(this.addedStatementsSet, this.removedStatementsSet).map(set -> () -> {
                Sail explicitRepository;
                HashSet<Statement> otherSet;
                Sail inferredRepository = null;
                if (set == this.addedStatementsSet) {
                    otherSet = this.removedStatementsSet;
                    if (this.addedStatements != null && this.addedStatements != this.sail.getBaseSail()) {
                        this.addedStatements.shutDown();
                    }
                    explicitRepository = this.addedStatements = this.getNewMemorySail();
                    if (this.rdfsSubClassOfReasoner != null) {
                        if (this.addedStatementsRdfsInferred != null) {
                            this.addedStatementsRdfsInferred.shutDown();
                        }
                        inferredRepository = this.addedStatementsRdfsInferred = this.getNewMemorySail();
                    } else if (this.addedStatementsRdfsInferred != null) {
                        this.addedStatementsRdfsInferred.shutDown();
                        this.addedStatementsRdfsInferred = null;
                    }
                    set.forEach(this.stats::added);
                } else {
                    otherSet = this.addedStatementsSet;
                    if (this.removedStatements != null) {
                        this.removedStatements.shutDown();
                        this.removedStatements = null;
                    }
                    explicitRepository = this.removedStatements = this.getNewMemorySail();
                    if (this.rdfsSubClassOfReasoner != null) {
                        if (this.removedStatementsRdfsInferred != null) {
                            this.removedStatementsRdfsInferred.shutDown();
                        }
                        inferredRepository = this.removedStatementsRdfsInferred = this.getNewMemorySail();
                    } else if (this.removedStatementsRdfsInferred != null) {
                        this.removedStatementsRdfsInferred.shutDown();
                        this.removedStatementsRdfsInferred = null;
                    }
                    set.forEach(this.stats::removed);
                }
                try (SailConnection explicitConnection = explicitRepository.getConnection();
                     SailConnection inferredConnection = inferredRepository != null ? inferredRepository.getConnection() : null;){
                    explicitConnection.begin((IsolationLevel)IsolationLevels.NONE);
                    if (inferredConnection != null) {
                        inferredConnection.begin((IsolationLevel)IsolationLevels.NONE);
                    }
                    set.stream().peek(s -> {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new SailException("ShacilSailConnection was interrupted while filling added/removed statement repositories");
                        }
                    }).filter(statement -> !otherSet.contains(statement)).forEach(statement -> {
                        if (!Thread.currentThread().isInterrupted()) {
                            explicitConnection.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[]{statement.getContext()});
                            if (inferredConnection != null) {
                                this.rdfsSubClassOfReasoner.forwardChain((Statement)statement).forEach(inferredStatement -> inferredConnection.addStatement(inferredStatement.getSubject(), inferredStatement.getPredicate(), inferredStatement.getObject(), new Resource[]{inferredStatement.getContext()}));
                            }
                        }
                    });
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    if (inferredConnection != null) {
                        inferredConnection.commit();
                    }
                    explicitConnection.commit();
                }
                return null;
            }).map(callable -> {
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                if (this.closed) {
                    throw new SailException("Connection is closed");
                }
                if (this.sail.isShutdown()) {
                    throw new SailException("Sail is shutdown");
                }
                if (parallelValidation) {
                    return this.sail.submitToExecutorService(callable);
                }
                FutureTask objectFutureTask = new FutureTask(callable);
                objectFutureTask.run();
                return objectFutureTask;
            }).filter(Objects::nonNull).forEach(futures::add);
            for (Future future : futures) {
                try {
                    if (Thread.currentThread().isInterrupted()) continue;
                    future.get();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof InterruptedException) {
                        throw (InterruptedException)cause;
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw new IllegalStateException(cause);
                }
            }
            this.fillInferredStatementRepository(this.addedStatementsInferredSet, this.removedStatementsInferredSet, true);
            this.fillInferredStatementRepository(this.removedStatementsInferredSet, this.addedStatementsInferredSet, false);
        }
        finally {
            if (futures != null) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        }
        if (this.sail.isPerformanceLogging()) {
            logger.info("fillAddedAndRemovedStatementRepositories() took {} ms", (Object)(System.currentTimeMillis() - before));
        }
    }

    private void fillInferredStatementRepository(Set<Statement> sourceSet, Set<Statement> otherSet, boolean added) throws InterruptedException {
        Sail inferredRepository;
        if (sourceSet.isEmpty()) {
            if (added) {
                if (this.addedStatementsInferred != null) {
                    this.addedStatementsInferred.shutDown();
                    this.addedStatementsInferred = null;
                }
            } else if (this.removedStatementsInferred != null) {
                this.removedStatementsInferred.shutDown();
                this.removedStatementsInferred = null;
            }
            return;
        }
        if (added) {
            if (this.addedStatementsInferred != null) {
                this.addedStatementsInferred.shutDown();
            }
            inferredRepository = this.addedStatementsInferred = this.getNewMemorySail();
            sourceSet.forEach(this.stats::added);
        } else {
            if (this.removedStatementsInferred != null) {
                this.removedStatementsInferred.shutDown();
            }
            inferredRepository = this.removedStatementsInferred = this.getNewMemorySail();
            sourceSet.forEach(this.stats::removed);
        }
        try (SailConnection inferredConnection = inferredRepository.getConnection();){
            inferredConnection.begin((IsolationLevel)IsolationLevels.NONE);
            sourceSet.stream().peek(s -> {
                if (Thread.currentThread().isInterrupted()) {
                    throw new SailException("ShaclSailConnection was interrupted while filling inferred statement repositories");
                }
            }).filter(statement -> !otherSet.contains(statement)).forEach(statement -> {
                if (!Thread.currentThread().isInterrupted()) {
                    inferredConnection.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[]{statement.getContext()});
                }
            });
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            inferredConnection.commit();
        }
    }

    private IsolationLevel getIsolationLevel() {
        return this.currentIsolationLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close() throws SailException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            List<Future<ValidationResultIterator>> originalFutures = this.futures;
            if (originalFutures != null) {
                List<Future<ValidationResultIterator>> list = originalFutures;
                synchronized (list) {
                    for (Future<ValidationResultIterator> future : this.futures) {
                        future.cancel(true);
                    }
                    this.futures = List.of();
                }
            }
        }
        catch (Throwable throwable) {
            try {
                List<ShapeValidationContainer> originalShapeValidatorContainers = this.shapeValidatorContainers;
                if (originalShapeValidatorContainers == null) throw throwable;
                List<ShapeValidationContainer> list = originalShapeValidatorContainers;
                synchronized (list) {
                    for (ShapeValidationContainer shapeValidatorContainer : originalShapeValidatorContainers) {
                        try {
                            shapeValidatorContainer.forceClose();
                        }
                        catch (Throwable ignored) {
                            logger.debug("Throwable was ignored while closing connection", ignored);
                        }
                    }
                    this.shapeValidatorContainers = List.of();
                    throw throwable;
                }
            }
            finally {
                try {
                    this.waitForOperations();
                }
                finally {
                    try {
                        if (this.readableShapesCache != null) {
                            this.readableShapesCache.close();
                            this.readableShapesCache = null;
                        }
                    }
                    finally {
                        block123: {
                            try {
                                if (this.writableShapesCache == null) break block123;
                                try {
                                    this.writableShapesCache.purge();
                                }
                                finally {
                                    this.writableShapesCache.close();
                                    this.writableShapesCache = null;
                                }
                            }
                            finally {
                                this.innerClose();
                            }
                        }
                    }
                }
            }
        }
        try {
            List<ShapeValidationContainer> originalShapeValidatorContainers = this.shapeValidatorContainers;
            if (originalShapeValidatorContainers == null) return;
            List<ShapeValidationContainer> list = originalShapeValidatorContainers;
            synchronized (list) {
                for (ShapeValidationContainer shapeValidatorContainer : originalShapeValidatorContainers) {
                    try {
                        shapeValidatorContainer.forceClose();
                    }
                    catch (Throwable ignored) {
                        logger.debug("Throwable was ignored while closing connection", ignored);
                    }
                }
                this.shapeValidatorContainers = List.of();
                return;
            }
        }
        finally {
            try {
                this.waitForOperations();
            }
            finally {
                try {
                    if (this.readableShapesCache != null) {
                        this.readableShapesCache.close();
                        this.readableShapesCache = null;
                    }
                }
                finally {
                    block126: {
                        try {
                            if (this.writableShapesCache == null) break block126;
                            try {
                                this.writableShapesCache.purge();
                            }
                            finally {
                                this.writableShapesCache.close();
                                this.writableShapesCache = null;
                            }
                        }
                        finally {
                            this.innerClose();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerClose() {
        try {
            this.shapesRepoConnection.close();
        }
        finally {
            try {
                if (this.previousStateConnection != null) {
                    this.previousStateConnection.close();
                }
            }
            finally {
                try {
                    if (this.serializableConnection != null) {
                        this.serializableConnection.close();
                    }
                }
                finally {
                    try {
                        super.close();
                    }
                    finally {
                        try {
                            this.sail.closeConnection();
                        }
                        finally {
                            try {
                                this.cleanupShapesReadWriteLock();
                            }
                            finally {
                                try {
                                    this.cleanupReadWriteLock();
                                }
                                finally {
                                    this.cleanup();
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void waitForOperations() {
        if (this.getWrappedConnection() instanceof AbstractSailConnection) {
            AbstractSailConnection abstractSailConnection = (AbstractSailConnection)this.getWrappedConnection();
            abstractSailConnection.waitForOtherOperations(true);
            for (int i = 0; i < 50 && abstractSailConnection.hasActiveIterations(); ++i) {
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws SailException {
        if (this.closed) {
            throw new SailException("Connection is closed");
        }
        if (this.sail.isShutdown()) {
            throw new SailException("Sail is shutdown");
        }
        this.prepareHasBeenCalled = true;
        long before = 0L;
        this.flush();
        try {
            boolean useSerializableValidation;
            if (this.sail.isPerformanceLogging()) {
                before = System.currentTimeMillis();
            }
            boolean bl = useSerializableValidation = this.shouldUseSerializableValidation() && !this.isBulkValidation();
            if (this.sail.isSerializableValidation()) {
                if (useSerializableValidation) {
                    this.exclusiveSerializableValidationLock = this.sail.serializableValidationLock.getWriteLock();
                } else {
                    this.nonExclusiveSerializableValidationLock = this.sail.serializableValidationLock.getReadLock();
                }
            } else assert (!useSerializableValidation) : "ShaclSail does not have serializable validation enabled but ShaclSailConnection still attempted to use serializable validation!";
            if (!this.isValidationEnabled()) {
                logger.debug("Validation skipped because validation was disabled");
                if (this.shapeRefreshNeeded || !this.connectionListenerActive) {
                    this.writableShapesCache = this.sail.getCachedShapesForWriting();
                }
                return;
            }
            assert (!this.shapeRefreshNeeded || !this.shapesModifiedInCurrentTransaction) : "isShapeRefreshNeeded should trigger shapesModifiedInCurrentTransaction once we have loaded the modified shapes, but shapesModifiedInCurrentTransaction should be null until then";
            if (!this.shapeRefreshNeeded && !this.isBulkValidation() && this.addedStatementsSet.isEmpty() && this.removedStatementsSet.isEmpty() && this.addedStatementsInferredSet.isEmpty() && this.removedStatementsInferredSet.isEmpty()) {
                logger.debug("Nothing has changed, nothing to validate.");
                return;
            }
            List currentShapes = null;
            List shapesAfterRefresh = null;
            if (this.shapeRefreshNeeded || !this.connectionListenerActive || this.isBulkValidation()) {
                if (this.writableShapesCache == null) {
                    this.writableShapesCache = this.sail.getCachedShapesForWriting();
                }
                this.shapesModifiedInCurrentTransaction = this.shapeRefreshNeeded;
                this.shapeRefreshNeeded = false;
                shapesAfterRefresh = this.sail.getShapes((RepositoryConnection)this.shapesRepoConnection, (SailConnection)this, this.shapesGraphs);
            } else if (this.readableShapesCache == null) {
                this.readableShapesCache = this.sail.getCachedShapes();
            }
            if (this.readableShapesCache != null) {
                currentShapes = (List)this.readableShapesCache.getData();
            }
            assert (currentShapes != null || shapesAfterRefresh != null);
            assert (currentShapes == null || shapesAfterRefresh == null);
            if (this.isEmpty(currentShapes) && this.isEmpty(shapesAfterRefresh)) {
                logger.debug("Validation skipped because there are no shapes to validate");
                return;
            }
            List shapesToValidate = shapesAfterRefresh != null ? shapesAfterRefresh : currentShapes;
            this.validateLegacyCallbackInferredSupport(shapesToValidate);
            boolean requiresRdfsSubClassReasoner = this.sail.isRdfsSubClassReasoning() || this.requiresRdfsSubClassReasoner(shapesToValidate);
            this.stats.setEmptyIncludingCurrentTransaction(ConnectionHelper.isEmpty((SailConnection)this));
            this.prepareValidation(new ValidationSettings(null, this.sail.isLogValidationPlans(), false, this.sail.isPerformanceLogging()), requiresRdfsSubClassReasoner);
            ValidationReport invalidTuples = null;
            if (useSerializableValidation) {
                Object object = this.sail.singleConnectionMonitor;
                synchronized (object) {
                    if (!this.sail.usesSingleConnection()) {
                        invalidTuples = this.serializableValidation(shapesToValidate);
                    }
                }
            }
            if (invalidTuples == null) {
                invalidTuples = this.validate(shapesToValidate, this.shapesModifiedInCurrentTransaction || this.isBulkValidation());
            }
            boolean valid = invalidTuples.conforms();
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("ShaclSailConnection was interrupted while validating.");
            }
            if (this.closed) {
                throw new SailException("Connection is closed");
            }
            if (!valid) {
                throw new ShaclSailValidationException(invalidTuples);
            }
        }
        catch (InterruptedException e) {
            throw ShaclSail.convertToSailException(e);
        }
        finally {
            if (this.sail.isPerformanceLogging()) {
                logger.info("prepare() including validation (excluding flushing and super.prepare()) took {} ms", (Object)(System.currentTimeMillis() - before));
            }
            if (!Thread.currentThread().isInterrupted()) {
                this.shapesRepoConnection.prepare();
                if (this.previousStateConnection != null) {
                    this.previousStateConnection.prepare();
                }
                super.prepare();
            }
        }
    }

    private boolean isEmpty(List<ContextWithShape> shapesList) {
        if (shapesList == null) {
            return true;
        }
        for (ContextWithShape shapesWithContext : shapesList) {
            if (!shapesWithContext.hasShape()) continue;
            return false;
        }
        return true;
    }

    private boolean shouldUseSerializableValidation() {
        return this.serializableConnection != null && this.sail.isSerializableValidation() && this.currentIsolationLevel == IsolationLevels.SNAPSHOT;
    }

    private boolean isBulkValidation() {
        return this.transactionSettings.getValidationApproach() == ShaclSail.TransactionSettings.ValidationApproach.Bulk;
    }

    /*
     * Exception decompiling
     */
    private ValidationReport serializableValidation(List<ContextWithShape> shapesAfterRefresh) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void statementAdded(Statement statement) {
        this.legacyStatementAddedWithoutInferredFlagObserved = true;
        this.statementAdded(statement, false);
    }

    public void statementAdded(Statement statement, boolean inferred) {
        if (this.prepareHasBeenCalled) {
            throw new IllegalStateException("Detected changes after prepare() has been called.");
        }
        this.checkIfShapesRefreshIsNeeded(statement);
        if (inferred) {
            boolean add = this.addedStatementsInferredSet.add(statement);
            if (!add) {
                this.removedStatementsInferredSet.remove(statement);
            }
        } else {
            boolean add = this.addedStatementsSet.add(statement);
            if (!add) {
                this.removedStatementsSet.remove(statement);
            }
        }
        this.checkTransactionalValidationLimit();
    }

    public void statementRemoved(Statement statement) {
        this.legacyStatementRemovedWithoutInferredFlagObserved = true;
        this.statementRemoved(statement, false);
    }

    public void statementRemoved(Statement statement, boolean inferred) {
        if (this.prepareHasBeenCalled) {
            throw new IllegalStateException("Detected changes after prepare() has been called.");
        }
        this.checkIfShapesRefreshIsNeeded(statement);
        if (inferred) {
            boolean add = this.removedStatementsInferredSet.add(statement);
            if (!add) {
                this.addedStatementsInferredSet.remove(statement);
            }
        } else {
            boolean add = this.removedStatementsSet.add(statement);
            if (!add) {
                this.addedStatementsSet.remove(statement);
            }
        }
        this.checkTransactionalValidationLimit();
    }

    private void checkIfShapesRefreshIsNeeded(Statement statement) {
        if (!this.shapeRefreshNeeded) {
            for (IRI shapesGraph : this.shapesGraphs) {
                if (!Objects.equals(statement.getContext(), shapesGraph)) continue;
                this.markShapesRefreshNeeded();
                break;
            }
        }
    }

    private void markShapesRefreshNeeded() {
        this.shapeRefreshNeeded = true;
    }

    private Boolean inferInferredFromStatementMetadata(Statement statement) {
        try {
            Boolean inferred = this.invokeBooleanStatementMethod(statement, "isInferred");
            if (inferred != null) {
                return inferred;
            }
            Boolean explicit = this.invokeBooleanStatementMethod(statement, "isExplicit");
            if (explicit != null) {
                return explicit == false;
            }
            return null;
        }
        catch (ReflectiveOperationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to infer inferred-flag from legacy callback statement metadata.", (Throwable)e);
            }
            return null;
        }
    }

    private Boolean invokeBooleanStatementMethod(Statement statement, String methodName) throws ReflectiveOperationException {
        Method method = statement.getClass().getMethod(methodName, new Class[0]);
        Class<?> returnType = method.getReturnType();
        if (returnType != Boolean.TYPE && returnType != Boolean.class) {
            return null;
        }
        Object value = method.invoke((Object)statement, new Object[0]);
        return value == null ? null : (Boolean)value;
    }

    private void validateLegacyCallbackInferredSupport(List<ContextWithShape> shapesToValidate) {
        if (!this.legacyStatementAddedWithoutInferredFlagObserved && !this.legacyStatementRemovedWithoutInferredFlagObserved) {
            return;
        }
        boolean includeInferredStatementsEnabledByDefault = this.sail.isIncludeInferredStatements();
        boolean requiresInferredClassification = shapesToValidate.stream().filter(ContextWithShape::hasShape).map(ContextWithShape::getShape).anyMatch(shape -> !shape.usesIncludeInferredStatements(includeInferredStatementsEnabledByDefault));
        if (!requiresInferredClassification) {
            return;
        }
        String callbackDetails = this.getObservedLegacyCallbacksWithoutInferredFlag();
        String message = "Underlying Sail does not support shapes that explicitly set rsx:includeInferredStatements=false or globally configure ShaclSail#setIncludeInferredStatements(false), because it emits deprecated SailConnectionListener callbacks without inferred flags (" + callbackDetails + "). Implement statementAdded(Statement, boolean inferred) and statementRemoved(Statement, boolean inferred).";
        logger.error(message);
        throw new ShaclSailValidationException(message);
    }

    private String getObservedLegacyCallbacksWithoutInferredFlag() {
        if (this.legacyStatementAddedWithoutInferredFlagObserved && this.legacyStatementRemovedWithoutInferredFlagObserved) {
            return "statementAdded(Statement), statementRemoved(Statement)";
        }
        if (this.legacyStatementAddedWithoutInferredFlagObserved) {
            return "statementAdded(Statement)";
        }
        if (this.legacyStatementRemovedWithoutInferredFlagObserved) {
            return "statementRemoved(Statement)";
        }
        return "<none>";
    }

    private void checkTransactionalValidationLimit() {
        int changeCount = this.addedStatementsSet.size() + this.removedStatementsSet.size() + this.addedStatementsInferredSet.size() + this.removedStatementsInferredSet.size();
        if ((long)changeCount > this.sail.getTransactionalValidationLimit()) {
            if (this.shouldUseSerializableValidation()) {
                logger.debug("Transaction size limit exceeded, could not switch to bulk validation because serializable validation is enabled.");
            } else {
                logger.debug("Transaction size limit exceeded, reverting to bulk validation.");
                this.removeConnectionListener(this);
                Settings bulkValidation = this.getLocalTransactionSettings();
                bulkValidation.setValidationApproach(ShaclSail.TransactionSettings.ValidationApproach.Bulk);
                this.getTransactionSettings().applyTransactionSettings(bulkValidation);
                this.removedStatementsSet.clear();
                this.addedStatementsSet.clear();
                this.removedStatementsInferredSet.clear();
                this.addedStatementsInferredSet.clear();
            }
        }
    }

    public RdfsSubClassOfReasoner getRdfsSubClassOfReasoner() {
        return this.rdfsSubClassOfReasoner;
    }

    public CloseableIteration<? extends Statement> getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        if (this.useDefaultShapesGraph && contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals((Object)contexts[0])) {
            return ConnectionHelper.getCloseableIteration((RepositoryResult<Statement>)this.shapesRepoConnection.getStatements(subj, pred, obj, includeInferred, new Resource[0]));
        }
        return super.getStatements(subj, pred, obj, includeInferred, contexts);
    }

    public boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        if (this.useDefaultShapesGraph && contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals((Object)contexts[0])) {
            return this.shapesRepoConnection.hasStatement(subj, pred, obj, includeInferred, new Resource[0]);
        }
        return super.hasStatement(subj, pred, obj, includeInferred, contexts);
    }

    public ValidationReport revalidate() {
        if (!this.isActive()) {
            throw new IllegalStateException("No active transaction!");
        }
        try {
            return this.validate(this.sail.getShapes((RepositoryConnection)this.shapesRepoConnection, (SailConnection)this, this.shapesGraphs), true);
        }
        catch (InterruptedException e) {
            throw ShaclSail.convertToSailException(e);
        }
    }

    Settings getTransactionSettings() {
        return this.transactionSettings;
    }

    private long getTimeStamp() {
        if (this.sail.isPerformanceLogging()) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    private static /* synthetic */ void lambda$serializableValidation$21(SailConnection rec$, Resource x$0, IRI x$1, Value x$2, Resource xva$3) {
        rec$.removeStatements(x$0, x$1, x$2, new Resource[]{xva$3});
    }

    private static /* synthetic */ void lambda$serializableValidation$20(SailConnection rec$, Resource x$0, IRI x$1, Value x$2, Resource xva$3) {
        rec$.addStatement(x$0, x$1, x$2, new Resource[]{xva$3});
    }

    public static class Settings {
        private ShaclSail.TransactionSettings.ValidationApproach validationApproach;
        private Boolean cacheSelectedNodes;
        private Boolean parallelValidation;
        private IsolationLevel isolationLevel;
        private transient Settings previous = null;

        public Settings(boolean cacheSelectNodes, boolean validationEnabled, boolean parallelValidation, IsolationLevel isolationLevel) {
            this.cacheSelectedNodes = cacheSelectNodes;
            this.validationApproach = !validationEnabled ? ShaclSail.TransactionSettings.ValidationApproach.Disabled : ShaclSail.TransactionSettings.ValidationApproach.Auto;
            this.parallelValidation = parallelValidation;
            this.isolationLevel = isolationLevel;
        }

        public Settings(ShaclSailConnection connection) {
            TransactionSetting[] transactionSettingsRaw = connection.transactionSettingsRaw;
            assert (transactionSettingsRaw != null);
            ShaclSail.TransactionSettings.ValidationApproach validationApproach = null;
            Boolean cacheSelectedNodes = null;
            Boolean parallelValidation = null;
            block6: for (TransactionSetting transactionSetting : transactionSettingsRaw) {
                if (transactionSetting instanceof ShaclSail.TransactionSettings.ValidationApproach) {
                    validationApproach = (ShaclSail.TransactionSettings.ValidationApproach)transactionSetting;
                    continue;
                }
                if (!(transactionSetting instanceof ShaclSail.TransactionSettings.PerformanceHint)) continue;
                switch ((ShaclSail.TransactionSettings.PerformanceHint)transactionSetting) {
                    case ParallelValidation: {
                        parallelValidation = true;
                        continue block6;
                    }
                    case SerialValidation: {
                        parallelValidation = false;
                        continue block6;
                    }
                    case CacheDisabled: {
                        cacheSelectedNodes = false;
                        continue block6;
                    }
                    case CacheEnabled: {
                        cacheSelectedNodes = true;
                    }
                }
            }
            this.validationApproach = validationApproach;
            this.cacheSelectedNodes = cacheSelectedNodes;
            this.parallelValidation = !connection.supportsConcurrentReads() ? Boolean.valueOf(false) : parallelValidation;
        }

        private Settings(Settings settings) {
            this.validationApproach = settings.validationApproach;
            this.cacheSelectedNodes = settings.cacheSelectedNodes;
            this.parallelValidation = settings.parallelValidation;
            this.isolationLevel = settings.isolationLevel;
            this.previous = settings.previous;
        }

        public ShaclSail.TransactionSettings.ValidationApproach getValidationApproach() {
            return this.validationApproach;
        }

        public boolean isCacheSelectNodes() {
            return this.cacheSelectedNodes;
        }

        public boolean isParallelValidation() {
            return this.parallelValidation;
        }

        public IsolationLevel getIsolationLevel() {
            return this.isolationLevel;
        }

        static ShaclSail.TransactionSettings.ValidationApproach getMostSignificantValidationApproach(ShaclSail.TransactionSettings.ValidationApproach base, ShaclSail.TransactionSettings.ValidationApproach overriding) {
            if (base == null && overriding == null) {
                return ShaclSail.TransactionSettings.ValidationApproach.Auto;
            }
            return ShaclSail.TransactionSettings.ValidationApproach.getHighestPriority(base, overriding);
        }

        void applyTransactionSettings(Settings transactionSettingsLocal) {
            this.previous = new Settings(this);
            this.validationApproach = Settings.getMostSignificantValidationApproach(this.validationApproach, transactionSettingsLocal.validationApproach);
            if (this.validationApproach == ShaclSail.TransactionSettings.ValidationApproach.Bulk) {
                this.cacheSelectedNodes = false;
                this.parallelValidation = false;
            }
            if (transactionSettingsLocal.parallelValidation != null) {
                this.parallelValidation = transactionSettingsLocal.parallelValidation;
            }
            if (transactionSettingsLocal.cacheSelectedNodes != null) {
                this.cacheSelectedNodes = transactionSettingsLocal.cacheSelectedNodes;
            }
            assert (transactionSettingsLocal.isolationLevel == null);
        }

        public String toString() {
            return "Settings{validationApproach=" + String.valueOf((Object)this.validationApproach) + ", cacheSelectedNodes=" + this.cacheSelectedNodes + ", parallelValidation=" + this.parallelValidation + ", isolationLevel=" + String.valueOf(this.isolationLevel) + "}";
        }

        public void switchToBulkValidation() {
            ShaclSail.TransactionSettings.ValidationApproach newValidationApproach = Settings.getMostSignificantValidationApproach(this.validationApproach, ShaclSail.TransactionSettings.ValidationApproach.Bulk);
            if (newValidationApproach != this.validationApproach) {
                this.validationApproach = newValidationApproach;
                this.parallelValidation = false;
                this.cacheSelectedNodes = false;
            }
        }

        private void setValidationApproach(ShaclSail.TransactionSettings.ValidationApproach validationApproach) {
            this.validationApproach = validationApproach;
        }

        private void setCacheSelectedNodes(Boolean cacheSelectedNodes) {
            this.cacheSelectedNodes = cacheSelectedNodes;
        }

        private void setParallelValidation(Boolean parallelValidation) {
            this.parallelValidation = parallelValidation;
        }

        private void setIsolationLevel(IsolationLevel isolationLevel) {
            this.isolationLevel = isolationLevel;
        }
    }
}

