/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.IterationWrapper;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailChangedEvent;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.SailReadOnlyException;
import org.eclipse.rdf4j.sail.base.SailSourceConnection;
import org.eclipse.rdf4j.sail.helpers.AbstractSail;
import org.eclipse.rdf4j.sail.helpers.DefaultSailChangedEvent;
import org.eclipse.rdf4j.sail.lmdb.LmdbStore;
import org.eclipse.rdf4j.sail.lmdb.Pool;
import org.eclipse.rdf4j.sail.lmdb.model.LmdbValue;

public class LmdbStoreConnection
extends SailSourceConnection {
    protected final LmdbStore lmdbStore;
    private volatile DefaultSailChangedEvent sailChangedEvent;
    private volatile Lock txnLock;

    protected LmdbStoreConnection(LmdbStore sail) {
        super((AbstractSail)sail, sail.getSailStore(), sail.getEvaluationStrategyFactory());
        this.lmdbStore = sail;
        this.sailChangedEvent = new DefaultSailChangedEvent((Sail)sail);
    }

    protected void startTransactionInternal() throws SailException {
        if (!this.lmdbStore.isWritable()) {
            throw new SailReadOnlyException("Unable to start transaction: data file is locked or read-only");
        }
        boolean releaseLock = true;
        try {
            if (this.txnLock == null || !this.txnLock.isActive()) {
                this.txnLock = this.lmdbStore.getTransactionLock(this.getTransactionIsolation());
                if (this.lmdbStore.isIsolationDisabled()) {
                    releaseLock = false;
                }
            }
            super.startTransactionInternal();
        }
        finally {
            if (releaseLock && this.txnLock != null && this.txnLock.isActive()) {
                this.txnLock.release();
            }
        }
    }

    protected void commitInternal() throws SailException {
        try {
            super.commitInternal();
        }
        finally {
            if (this.txnLock != null && this.txnLock.isActive()) {
                this.txnLock.release();
            }
        }
        this.lmdbStore.notifySailChanged((SailChangedEvent)this.sailChangedEvent);
        this.sailChangedEvent = new DefaultSailChangedEvent((Sail)this.lmdbStore);
    }

    protected void rollbackInternal() throws SailException {
        try {
            super.rollbackInternal();
        }
        finally {
            if (this.txnLock != null && this.txnLock.isActive()) {
                this.txnLock.release();
            }
        }
        this.sailChangedEvent = new DefaultSailChangedEvent((Sail)this.lmdbStore);
    }

    protected void addStatementInternal(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.sailChangedEvent.setStatementsAdded(true);
    }

    public boolean addInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        boolean ret = super.addInferredStatement(subj, pred, obj, contexts);
        this.sailChangedEvent.setStatementsAdded(true);
        return ret;
    }

    protected CloseableIteration<? extends BindingSet> evaluateInternal(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        return new IterationWrapper<BindingSet>(super.evaluateInternal(tupleExpr, dataset, bindings, includeInferred)){

            public BindingSet next() throws QueryEvaluationException {
                BindingSet bs = (BindingSet)super.next();
                bs.forEach(b -> LmdbStoreConnection.this.initValue(b.getValue()));
                return bs;
            }
        };
    }

    protected CloseableIteration<? extends Statement> getStatementsInternal(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        return new IterationWrapper<Statement>(super.getStatementsInternal(subj, pred, obj, includeInferred, contexts)){

            public Statement next() throws SailException {
                Statement stmt = (Statement)super.next();
                LmdbStoreConnection.this.initValue((Value)stmt.getSubject());
                LmdbStoreConnection.this.initValue((Value)stmt.getPredicate());
                LmdbStoreConnection.this.initValue(stmt.getObject());
                LmdbStoreConnection.this.initValue((Value)stmt.getContext());
                return stmt;
            }
        };
    }

    protected void initValue(Value value) {
        if (value instanceof LmdbValue) {
            ((LmdbValue)value).init();
        }
    }

    protected void removeStatementsInternal(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.sailChangedEvent.setStatementsRemoved(true);
    }

    public boolean removeInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        boolean ret = super.removeInferredStatement(subj, pred, obj, contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
        return ret;
    }

    protected void clearInternal(Resource ... contexts) throws SailException {
        super.clearInternal(contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
    }

    public void clearInferred(Resource ... contexts) throws SailException {
        super.clearInferred(contexts);
        this.sailChangedEvent.setStatementsRemoved(true);
    }

    protected void closeInternal() throws SailException {
        super.closeInternal();
        Pool.release();
    }
}

