/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction0;
import org.eclipse.collections.api.block.function.primitive.DoubleToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.FloatDoubleToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatDoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatDoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.iterator.MutableDoubleIterator;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.map.primitive.FloatDoubleMap;
import org.eclipse.collections.api.map.primitive.ImmutableFloatDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableDoubleFloatMap;
import org.eclipse.collections.api.map.primitive.MutableFloatDoubleMap;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.tuple.primitive.FloatDoublePair;
import org.eclipse.collections.impl.SynchronizedRichIterable;
import org.eclipse.collections.impl.collection.mutable.primitive.SynchronizedDoubleCollection;
import org.eclipse.collections.impl.factory.primitive.FloatDoubleMaps;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableFloatDoubleMap;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedFloatSet;

public class SynchronizedFloatDoubleMap
implements MutableFloatDoubleMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    private final MutableFloatDoubleMap map;

    public SynchronizedFloatDoubleMap(MutableFloatDoubleMap map) {
        this(map, null);
    }

    public SynchronizedFloatDoubleMap(MutableFloatDoubleMap map, Object newLock) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot create a SynchronizedFloatDoubleMap on a null map");
        }
        this.map = map;
        this.lock = newLock == null ? this : newLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(float key, double value) {
        Object object = this.lock;
        synchronized (object) {
            this.map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPair(FloatDoublePair keyValuePair) {
        Object object = this.lock;
        synchronized (object) {
            this.map.put(keyValuePair.getOne(), keyValuePair.getTwo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(FloatDoubleMap map) {
        Object object = this.lock;
        synchronized (object) {
            this.map.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateValues(FloatDoubleToDoubleFunction function) {
        Object object = this.lock;
        synchronized (object) {
            this.map.updateValues(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKey(float key) {
        Object object = this.lock;
        synchronized (object) {
            this.map.removeKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(float key) {
        Object object = this.lock;
        synchronized (object) {
            this.map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double removeKeyIfAbsent(float key, double value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.removeKeyIfAbsent(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getIfAbsentPut(float key, double value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsentPut(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getIfAbsentPut(float key, DoubleFunction0 function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsentPut(key, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getIfAbsentPutWithKey(float key, FloatToDoubleFunction function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsentPutWithKey(key, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> double getIfAbsentPutWith(float key, DoubleFunction<? super P> function, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsentPutWith(key, function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double updateValue(float key, double initialValueIfAbsent, DoubleToDoubleFunction function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.updateValue(key, initialValueIfAbsent, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get(float key) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getIfAbsent(float key, double ifAbsent) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getIfAbsent(key, ifAbsent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getOrThrow(float key) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.getOrThrow(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(float key) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(double value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachValue(DoubleProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEachValue(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachKey(FloatProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEachKey(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachKeyValue(FloatDoubleProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEachKeyValue(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyFloatIterable keysView() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.keysView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RichIterable<FloatDoublePair> keyValuesView() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedRichIterable.of(this.map.keyValuesView(), this.lock).asLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleFloatMap flipUniqueValues() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.flipUniqueValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatDoubleMap select(FloatDoublePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatDoubleMap reject(FloatDoublePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.reject(predicate);
        }
    }

    public MutableDoubleIterator doubleIterator() {
        return this.map.doubleIterator();
    }

    public void forEach(DoubleProcedure procedure) {
        this.each(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void each(DoubleProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(DoublePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anySatisfy(DoublePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allSatisfy(DoublePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noneSatisfy(DoublePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleBag select(DoublePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleBag reject(DoublePredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableBag<V> collect(DoubleToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.detectIfNone(predicate, ifNone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double sum() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double max() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.max();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double maxIfEmpty(double defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.maxIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double min() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.min();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double minIfEmpty(double defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.minIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double average() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.average();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double median() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.median();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double addToValue(float key, double toBeAdded) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.addToValue(key, toBeAdded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] toSortedArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleList toSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] toArray(double[] target) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toArray(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(double value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(double ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(DoubleIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleList toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleSet toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleBag toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyDoubleIterable asLazy() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.asLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatDoubleMap withKeyValue(float key, double value) {
        Object object = this.lock;
        synchronized (object) {
            this.map.withKeyValue(key, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatDoubleMap withoutKey(float key) {
        Object object = this.lock;
        synchronized (object) {
            this.map.withoutKey(key);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatDoubleMap withoutAllKeys(FloatIterable keys) {
        Object object = this.lock;
        synchronized (object) {
            this.map.withoutAllKeys(keys);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatDoubleMap asUnmodifiable() {
        Object object = this.lock;
        synchronized (object) {
            return new UnmodifiableFloatDoubleMap(this);
        }
    }

    public MutableFloatDoubleMap asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableFloatDoubleMap toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return FloatDoubleMaps.immutable.withAll((FloatDoubleMap)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatSet keySet() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedFloatSet.of(this.map.keySet(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleCollection values() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedDoubleCollection.of(this.map.values(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object otherMap) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.equals(otherMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.map.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.map.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.map.appendString(appendable, start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.map.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RichIterable<DoubleIterable> chunk(int size) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.chunk(size);
        }
    }
}

