/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy.logs;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.actf.model.internal.flash.proxy.ProxyPlugin;
import org.eclipse.actf.model.internal.flash.proxy.logs.ProxyLogRecord;
import org.eclipse.actf.model.internal.flash.proxy.ui.views.ProxyLogView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyLogHandler
extends ConsoleHandler {
    private static List<ProxyLogRecord> logRecordList = new ArrayList<ProxyLogRecord>();
    private static int maxRecordCount = 1000;
    private static Handler handler = null;
    private static Logger logger = LogManager.getLogManager().getLogger("");
    private static Display display = ProxyPlugin.getDefault().getWorkbench().getDisplay();
    private static Level logLevel = Level.INFO;

    public static void configure() {
        Handler[] handlerArray = logger.getHandlers();
        int n = 0;
        while (n < handlerArray.length) {
            if (handlerArray[n] instanceof ConsoleHandler) {
                logger.removeHandler(handlerArray[n]);
            }
            ++n;
        }
        if (handler == null) {
            handler = new ProxyLogHandler();
        }
        logger.addHandler(handler);
        ProxyLogHandler.setLogLevel(logLevel);
    }

    public static void removeHandler() {
        if (handler != null) {
            Logger logger = LogManager.getLogManager().getLogger("");
            logger.removeHandler(handler);
        }
    }

    public static Handler getHandler() {
        return handler;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void publish(LogRecord var1_1) {
        if (this.isLoggable(var1_1) && !ProxyLogHandler.display.isDisposed()) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            ProxyLogHandler.logRecordList.remove(0);
lbl5:
            // 2 sources

            ** while (ProxyLogHandler.logRecordList.size() >= ProxyLogHandler.maxRecordCount)
        }
lbl6:
        // 1 sources

        ProxyLogHandler.logRecordList.add(new ProxyLogRecord(var1_1));
        ProxyLogHandler.display.asyncExec(new Runnable(){

            public void run() {
                IViewPart iViewPart;
                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (iWorkbenchWindow == null) {
                    return;
                }
                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                if (iWorkbenchPage != null && (iViewPart = iWorkbenchPage.findView(ProxyLogView.ID)) instanceof ProxyLogView) {
                    ((ProxyLogView)iViewPart).refresh();
                }
            }
        });
    }

    public static List<ProxyLogRecord> getLogs() {
        return logRecordList;
    }

    public static void clear() {
        logRecordList.clear();
    }

    public static void setLogLevel(Level level) {
        logLevel = level;
        if (handler != null) {
            handler.setLevel(logLevel);
            logger.setLevel(logLevel);
        }
    }

    public static void resetLogLevel() {
        ProxyLogHandler.setLogLevel(logLevel);
    }

    public static void setMaxLogCount(int n) {
        maxRecordCount = n;
    }

    public static int getMaxLogCount() {
        return maxRecordCount;
    }
}

