/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;

public class SocketTimeoutRetryOutputStream
extends OutputStream {
    private final OutputStream outputStream;

    public static void write(OutputStream outputStream, byte[] byArray) throws IOException {
        while (true) {
            try {
                outputStream.write(byArray);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public static void write(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        while (true) {
            try {
                outputStream.write(byArray, n, n2);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public static void write(OutputStream outputStream, int n) throws IOException {
        while (true) {
            try {
                outputStream.write(n);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public void close() throws IOException {
        while (true) {
            try {
                this.outputStream.close();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public void flush() throws IOException {
        while (true) {
            try {
                this.outputStream.flush();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public void write(byte[] byArray) throws IOException {
        SocketTimeoutRetryOutputStream.write(this.outputStream, byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        SocketTimeoutRetryOutputStream.write(this.outputStream, byArray, n, n2);
    }

    public void write(int n) throws IOException {
        SocketTimeoutRetryOutputStream.write(this.outputStream, n);
    }

    SocketTimeoutRetryOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }
}

