/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.ui.script.util;

import java.io.File;
import org.eclipse.birt.report.debug.internal.ui.script.editor.DebugJsEditor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ScriptDebugUtil {
    private static final char fgSeparator = File.separatorChar;
    private static final String[] fgCandidateJavaFiles = new String[]{"javaw", "javaw.exe", "java", "java.exe", "j9w", "j9w.exe", "j9", "j9.exe"};
    private static final String[] fgCandidateJavaLocations = new String[]{"bin" + fgSeparator, "jre" + fgSeparator + "bin" + fgSeparator};

    public static IResource getDefaultResource() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static File findJavaExecutable(File vmInstallLocation) {
        int i = 0;
        while (i < fgCandidateJavaFiles.length) {
            int j = 0;
            while (j < fgCandidateJavaLocations.length) {
                File javaFile = new File(vmInstallLocation, String.valueOf(fgCandidateJavaLocations[j]) + fgCandidateJavaFiles[i]);
                if (javaFile.isFile()) {
                    return javaFile;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static IJavaProject getJavaProject(String projectName) throws CoreException {
        if (projectName == null || projectName.trim().length() < 1) {
            return null;
        }
        IJavaProject javaProject = ScriptDebugUtil.getJavaModel().getJavaProject(projectName);
        return javaProject;
    }

    private static IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }

    public static String expandLibraryName(String source) {
        if (source == null || source.length() == 0) {
            return "";
        }
        if (source.indexOf("$ws$") != -1) {
            source = source.replaceAll("\\$ws\\$", "ws/" + TargetPlatform.getWS());
        }
        if (source.indexOf("$os$") != -1) {
            source = source.replaceAll("\\$os\\$", "os/" + TargetPlatform.getOS());
        }
        if (source.indexOf("$nl$") != -1) {
            source = source.replaceAll("\\$nl\\$", "nl/" + TargetPlatform.getNL());
        }
        if (source.indexOf("$arch$") != -1) {
            source = source.replaceAll("\\$arch\\$", "arch/" + TargetPlatform.getOSArch());
        }
        return source;
    }

    public static IPath getPath(IPluginModelBase model, String libraryName) {
        IResource resource = model.getUnderlyingResource();
        if (resource != null) {
            IResource jarFile = resource.getProject().findMember(libraryName);
            return jarFile != null ? jarFile.getFullPath() : null;
        }
        File file = new File(model.getInstallLocation(), libraryName);
        return file.exists() ? new Path(file.getAbsolutePath()) : null;
    }

    public static String getPlugInFile(String id) {
        IPluginModelBase model = PluginRegistry.findModel((String)id);
        if (model == null) {
            return null;
        }
        File file = new File(model.getInstallLocation());
        if (file.isFile()) {
            return file.getAbsolutePath();
        }
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        int i = 0;
        while (i < libraries.length) {
            String name;
            String expandedName;
            IPath path;
            if (!"resource".equals(libraries[i].getType()) && (path = ScriptDebugUtil.getPath(model = (IPluginModelBase)libraries[i].getModel(), expandedName = ScriptDebugUtil.expandLibraryName(name = libraries[i].getName()))) != null && !path.toFile().isDirectory()) {
                return path.toFile().getAbsolutePath();
            }
            ++i;
        }
        return null;
    }

    public static String getOutputFolder(IJavaProject project) {
        if (project == null) {
            return null;
        }
        IPath path = project.readOutputLocation();
        String curPath = path.toOSString();
        String directPath = project.getProject().getLocation().toOSString();
        int index = directPath.lastIndexOf(File.separator);
        String absPath = String.valueOf(directPath.substring(0, index)) + curPath;
        return absPath;
    }

    public static DebugJsEditor getActiveJsEditor() {
        IEditorPart editor;
        IWorkbenchPage pg;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (pg = window.getActivePage()) != null && (editor = pg.getActiveEditor()) != null && editor instanceof DebugJsEditor) {
            return (DebugJsEditor)editor;
        }
        return null;
    }

    public static String getSubstitutedString(String text) throws CoreException {
        if (text == null) {
            return "";
        }
        IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
        return mgr.performStringSubstitution(text);
    }

    public static IRegion findWord(IDocument document, int offset) {
        if (document == null) {
            return null;
        }
        int start = -2;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {}
        if (start >= -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }
}

