/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.helpers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.bpel.validator.helpers.GetOpt;
import org.eclipse.bpel.validator.helpers.JavaScriptSource;
import org.eclipse.bpel.validator.helpers.LocationCapturingDOMParser;
import org.eclipse.bpel.validator.helpers.ModelQueryImpl;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.Problem;
import org.eclipse.bpel.validator.model.RuleFactory;
import org.eclipse.bpel.validator.model.Runner;
import org.eclipse.bpel.validator.wsdl.Factory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CmdValidator {
    protected static PrintStream OUT = System.out;
    protected static final IProblem[] EMPTY_RESULT = new IProblem[0];
    protected Runner fRunner = null;
    static String[] EMPTY = new String[0];
    static Set<String> KEY_SET = CmdValidator.keys(IProblem.class);

    public CmdValidator() {
        RuleFactory.INSTANCE.registerFactory(org.eclipse.bpel.validator.rules.Factory.INSTANCE);
        RuleFactory.INSTANCE.registerFactory(org.eclipse.bpel.validator.vprop.Factory.INSTANCE);
        RuleFactory.INSTANCE.registerFactory(org.eclipse.bpel.validator.plt.Factory.INSTANCE);
        RuleFactory.INSTANCE.registerFactory(Factory.INSTANCE);
        RuleFactory.INSTANCE.registerFactory(org.eclipse.bpel.validator.xpath.Factory.INSTANCE);
        RuleFactory.INSTANCE.registerFactory(org.eclipse.bpel.validator.unsupported.Factory.INSTANCE);
    }

    public IProblem[] validate(File file) {
        Element elm = null;
        try {
            LocationCapturingDOMParser parser = new LocationCapturingDOMParser();
            parser.parse(file.toString());
            elm = parser.getDocument().getDocumentElement();
        }
        catch (Exception ex) {
            OUT.printf("Error: Cannot read BPEL Process in %1$s", file);
            ex.printStackTrace(OUT);
            return EMPTY_RESULT;
        }
        if (elm == null) {
            OUT.printf("Error: Cannot read BPEL Process in %1$s", file);
            return EMPTY_RESULT;
        }
        INode node = ModelQueryImpl.getModelQuery().adapt(elm, INode.class, 0);
        this.fRunner = new Runner(ModelQueryImpl.getModelQuery(), node);
        return this.fRunner.run();
    }

    public IProblem[] validate(URL source) {
        Element elm = null;
        try {
            LocationCapturingDOMParser parser = new LocationCapturingDOMParser();
            InputSource is = new InputSource();
            is.setPublicId(source.toString());
            is.setSystemId(source.toString());
            is.setByteStream(source.openStream());
            parser.parse(is);
            elm = parser.getDocument().getDocumentElement();
        }
        catch (Exception ex) {
            OUT.printf("Error: Cannot read BPEL Process in %1$s", source);
            ex.printStackTrace(OUT);
            return EMPTY_RESULT;
        }
        if (elm == null) {
            OUT.printf("Error: Cannot read BPEL Process in %1$s", source);
            return EMPTY_RESULT;
        }
        INode node = ModelQueryImpl.getModelQuery().adapt(elm, INode.class, 0);
        this.fRunner = new Runner(ModelQueryImpl.getModelQuery(), node);
        return this.fRunner.run();
    }

    public void log(IProblem[] problems, PrintStream ps) {
        ps.printf("<problems count=\"%1$d\">\n", problems.length);
        if (this.fRunner != null) {
            TreeSet<ARule> saChecks = new TreeSet<ARule>(new Comparator<ARule>(){

                @Override
                public int compare(ARule o1, ARule o2) {
                    return o1.sa() - o2.sa();
                }
            });
            saChecks.addAll(this.fRunner.getSAChecks());
            ps.printf(" <sa-cases>", new Object[0]);
            for (ARule a : saChecks) {
                ps.printf("%1$d,", a.sa());
            }
            ps.printf("0</sa-cases>\n", new Object[0]);
        }
        IProblem[] iProblemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            Map<String, Object> map = problem.getAttributes();
            ps.println(" <problem>");
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object value = entry.getValue();
                if (value == null) continue;
                String v = this.toSafeXML(value);
                if (value == null || "null".equals(v)) {
                    v = this.toSafeXML(value.toString());
                }
                ps.printf("  <%1$s>%2$s</%1$s>\n", entry.getKey(), v);
            }
            ps.println(" </problem>\n");
            ++n2;
        }
        ps.println("</problems>");
    }

    protected void logStats(IProblem[] list, PrintStream ps) {
        int error = 0;
        int warning = 0;
        int info = 0;
        int unknown = 0;
        IProblem[] iProblemArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem n3 = iProblemArray[n2];
            switch (n3.getAttribute("severity", -1)) {
                case 2: {
                    ++error;
                    break;
                }
                case 1: {
                    ++warning;
                    break;
                }
                case 0: {
                    ++info;
                    break;
                }
                default: {
                    ++unknown;
                }
            }
            ++n2;
        }
        ps.printf("%d errors, %d warnings, %d information\n", error, warning, info);
    }

    protected String toSafeXML(Object value) {
        if (value instanceof String) {
            return this.toSafeXML((String)value);
        }
        return this.toSafeXML(JavaScriptSource.getInstance().toSource(value));
    }

    protected String toSafeXML(String s) {
        if (s.indexOf("&") >= 0) {
            s = s.replaceAll("\\&", "&amp;");
        }
        if (s.indexOf("<") >= 0) {
            s = s.replaceAll("\\<", "&lt;");
        }
        if (s.indexOf(">") >= 0) {
            s = s.replaceAll("\\>", "&gt;");
        }
        return s;
    }

    public void run(String ... list) throws Exception {
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            File aFile = new File(a);
            OUT.printf("Validating %1$s ...\n", aFile);
            IProblem[] problems = this.validate(aFile);
            this.logStats(problems, OUT);
            if (problems.length != 0) {
                block19: {
                    PrintStream ps;
                    File log;
                    block17: {
                        log = new File(aFile + ".out.xml");
                        OUT.printf(" - error list as XML to %1$s\n", log);
                        ps = null;
                        try {
                            try {
                                ps = new PrintStream(log);
                                this.log(problems, ps);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                if (ps != null) {
                                    ps.close();
                                }
                                break block17;
                            }
                        }
                        catch (Throwable throwable) {
                            if (ps != null) {
                                ps.close();
                            }
                            throw throwable;
                        }
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    log = new File(aFile + ".log");
                    OUT.printf(" - log (xml source + errors) to %1$s\n", log);
                    ps = null;
                    try {
                        try {
                            ps = new PrintStream(log);
                            this.errorListing(new FileInputStream(aFile), problems, ps);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            if (ps != null) {
                                ps.close();
                            }
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        if (ps != null) {
                            ps.close();
                        }
                        throw throwable;
                    }
                    if (ps != null) {
                        ps.close();
                    }
                }
                OUT.println();
            }
            ++n2;
        }
    }

    public void run(GetOpt opt) throws Exception {
        this.run(opt.parameters().toArray(EMPTY));
    }

    public static void main(String[] argv) throws Exception {
        CmdValidator builder = new CmdValidator();
        GetOpt opt = new GetOpt("-h", argv);
        builder.run(opt);
    }

    public void errorListing(InputStream is, IProblem[] problems, PrintStream ps) throws Exception {
        String nextLine;
        Arrays.sort(problems, new Comparator<IProblem>(){

            @Override
            public int compare(IProblem o1, IProblem o2) {
                return o1.getAttribute("lineNumber", 0) - o2.getAttribute("lineNumber", 0);
            }
        });
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        int lineNo = 1;
        int index = 0;
        while ((nextLine = br.readLine()) != null) {
            ps.printf("%5d: %s\n", lineNo, nextLine);
            while (index < problems.length) {
                IProblem p = problems[index];
                int problemLineNo = p.getAttribute("lineNumber", -1);
                if (problemLineNo > lineNo) break;
                ps.printf("%s: %s\n", this.severityOf(p), p.getAttribute("message", "? Unknown ?"));
                ps.printf(" meta: rule=%s, sa=%s, msg.id=%s\n", p.getAttribute("ruleName"), p.getAttribute("staticAnalysisCode"), p.getAttribute("message.id"));
                String fix = p.getAttribute("fixMessage", null);
                if (fix != null) {
                    ps.printf("  fix: %s\n", fix);
                }
                ps.println();
                ++index;
            }
            ++lineNo;
        }
        br.close();
        ps.println();
        ps.println();
        this.logStats(problems, ps);
    }

    public String severityOf(IProblem problem) {
        int severity = problem.getAttribute("severity", -1);
        switch (severity) {
            case 2: {
                return "error";
            }
            case 0: {
                return "info";
            }
            case 1: {
                return "warning";
            }
        }
        return "error";
    }

    public static IProblem[] readMessages(File aFile) throws Exception {
        return CmdValidator.readMessages(new FileInputStream(aFile), aFile.getPath());
    }

    public static IProblem[] readMessages(InputStream is, String id) throws Exception {
        LocationCapturingDOMParser parser = new LocationCapturingDOMParser();
        InputSource inputSource = new InputSource();
        inputSource.setByteStream(is);
        inputSource.setPublicId(id);
        inputSource.setSystemId(id);
        parser.parse(inputSource);
        Document doc = parser.getDocument();
        Element elm = doc.getDocumentElement();
        if (!"problems".equals(elm.getTagName())) {
            return EMPTY_RESULT;
        }
        LinkedList<IProblem> list = new LinkedList<IProblem>();
        NodeList nl = elm.getElementsByTagName("problem");
        int i = 0;
        int j = nl.getLength();
        while (i < j) {
            Element e = (Element)nl.item(i);
            list.add(CmdValidator.Element2Problem(e));
            ++i;
        }
        return list.toArray(EMPTY_RESULT);
    }

    static IProblem Element2Problem(Element e) {
        Problem p = new Problem();
        Node n = e.getFirstChild();
        while (n != null) {
            Element ne;
            String key;
            if (n instanceof Element && KEY_SET.contains(key = (ne = (Element)n).getTagName())) {
                p.setAttribute(key, ne.getTextContent());
            }
            n = n.getNextSibling();
        }
        return p;
    }

    static Set<String> keys(Class<?> klazz) {
        HashSet<String> set = new HashSet<String>();
        Field[] fieldArray = klazz.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            int modifies = f.getModifiers();
            String name = f.getName();
            if (name.equals(name.toUpperCase()) && !false && f.getType() == String.class) {
                try {
                    String value = (String)f.get(null);
                    set.add(value);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return set;
    }
}

