/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.astwriter;

import org.eclipse.cdt.core.dom.ast.IASTAlignmentSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTAttribute;
import org.eclipse.cdt.core.dom.ast.IASTAttributeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTToken;
import org.eclipse.cdt.core.dom.ast.IASTTokenList;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAttribute;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAttributeList;
import org.eclipse.cdt.core.dom.ast.gnu.IGCCASTAttributeList;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.NodeWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.Scribe;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class AttributeWriter
extends NodeWriter {
    public AttributeWriter(Scribe scribe, ASTWriterVisitor visitor, NodeCommentMap commentMap) {
        super(scribe, visitor, commentMap);
    }

    public void writeAttributeSpecifier(IASTAttributeSpecifier attribute) {
        if (attribute instanceof ICPPASTAttributeList) {
            this.writeAttributeSpecifier((ICPPASTAttributeList)attribute);
        } else if (attribute instanceof IGCCASTAttributeList) {
            this.writeGCCAttributeSpecifier((IGCCASTAttributeList)attribute);
        } else if (attribute instanceof IASTAlignmentSpecifier) {
            this.writeAlignmentSpecifier((IASTAlignmentSpecifier)((Object)attribute));
        }
    }

    private void writeAlignmentSpecifier(IASTAlignmentSpecifier specifier) {
        this.scribe.print("alignas");
        this.scribe.print("(");
        if (specifier.getExpression() != null) {
            specifier.getExpression().accept(this.visitor);
        } else if (specifier.getTypeId() != null) {
            specifier.getTypeId().accept(this.visitor);
        }
        this.scribe.print(")");
    }

    private void writeGCCAttributeSpecifier(IGCCASTAttributeList specifier) {
        this.scribe.print("__attribute__");
        this.scribe.print("(");
        this.scribe.print("(");
        IASTAttribute[] innerAttributes = specifier.getAttributes();
        int i = 0;
        while (i < innerAttributes.length) {
            IASTAttribute innerAttribute = innerAttributes[i];
            if (innerAttribute instanceof ICPPASTAttribute) {
                this.writeAttribute((ICPPASTAttribute)innerAttribute);
            } else {
                this.writeAttribute(innerAttribute);
            }
            if (i < innerAttributes.length - 1) {
                this.scribe.print(',');
                this.scribe.printSpace();
            }
            ++i;
        }
        this.scribe.print(")");
        this.scribe.print(")");
    }

    private void writeAttributeSpecifier(ICPPASTAttributeList specifier) {
        this.scribe.print("[");
        this.scribe.print("[");
        IASTAttribute[] innerAttributes = specifier.getAttributes();
        int i = 0;
        while (i < innerAttributes.length) {
            IASTAttribute innerAttribute = innerAttributes[i];
            this.writeAttribute((ICPPASTAttribute)innerAttribute);
            if (i < innerAttributes.length - 1) {
                this.scribe.print(',');
                this.scribe.printSpace();
            }
            ++i;
        }
        this.scribe.print("]");
        this.scribe.print("]");
    }

    private void writeAttribute(IASTAttribute attribute) {
        this.scribe.print(attribute.getName());
        IASTToken argumentClause = attribute.getArgumentClause();
        if (argumentClause != null) {
            this.scribe.print("(");
            this.printTokens(argumentClause);
            this.scribe.print(")");
        }
    }

    private void writeAttributeScope(ICPPASTAttribute attribute) {
        char[] scope = attribute.getScope();
        if (scope != null) {
            this.scribe.print(scope);
            this.scribe.print("::");
        }
    }

    private void writeAttributeVarArgs(ICPPASTAttribute attribute) {
        if (attribute.hasPackExpansion()) {
            this.scribe.printSpace();
            this.scribe.print("...");
        }
    }

    private void writeAttribute(ICPPASTAttribute attribute) {
        this.writeAttributeScope(attribute);
        this.writeAttribute((IASTAttribute)attribute);
        this.writeAttributeVarArgs(attribute);
    }

    protected void printTokens(IASTToken token) {
        if (token instanceof IASTTokenList) {
            IASTToken[] iASTTokenArray = ((IASTTokenList)token).getTokens();
            int n = iASTTokenArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTToken innerToken = iASTTokenArray[n2];
                this.printTokens(innerToken);
                ++n2;
            }
        } else {
            char[] tokenCharImage = token.getTokenCharImage();
            this.scribe.print(tokenCharImage);
        }
    }
}

