/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOUndoDetector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOUndoDetectorImpl
implements CDOUndoDetector {
    @Override
    public boolean detectUndo(CDOTransaction transaction, CDORevision cleanRevision, CDORevision currentRevision, CDOFeatureDelta featureDelta) {
        InternalCDORevision currentInternalRevision;
        InternalCDORevision cleanInternalRevision;
        EStructuralFeature feature = featureDelta.getFeature();
        if (this.ignore(feature, cleanInternalRevision = (InternalCDORevision)cleanRevision, currentInternalRevision = (InternalCDORevision)currentRevision)) {
            return false;
        }
        if (feature == CDOContainerFeatureDelta.CONTAINER_FEATURE) {
            return this.detectUndoContainer(transaction, cleanInternalRevision, currentInternalRevision);
        }
        Object cleanValue = cleanInternalRevision.getValue(feature);
        Object currentValue = currentInternalRevision.getValue(feature);
        if (feature instanceof EReference) {
            if (feature.isMany()) {
                int currentSize;
                if (feature.isUnsettable()) {
                    if (cleanValue == null) {
                        return currentValue == null;
                    }
                    if (currentValue == null) {
                        return false;
                    }
                }
                List cleanList = (List)cleanValue;
                List currentList = (List)currentValue;
                int cleanSize = CDOUndoDetectorImpl.size(cleanList);
                if (cleanSize != (currentSize = CDOUndoDetectorImpl.size(currentList))) {
                    return false;
                }
                if (cleanSize != 0) {
                    Iterator cleanIterator = cleanList.iterator();
                    Iterator currentIterator = currentList.iterator();
                    while (cleanIterator.hasNext()) {
                        Object currentID;
                        Object cleanID = cleanIterator.next();
                        if (CDOUndoDetectorImpl.equalReference(transaction, cleanID, currentID = currentIterator.next())) continue;
                        return false;
                    }
                }
                return true;
            }
            return CDOUndoDetectorImpl.equalReference(transaction, cleanValue, currentValue);
        }
        return ObjectUtil.equals((Object)cleanValue, (Object)currentValue);
    }

    @Deprecated
    protected boolean detectUndoContainer(InternalCDORevision cleanRevision, InternalCDORevision currentRevision) {
        throw new UnsupportedOperationException();
    }

    protected boolean detectUndoContainer(CDOTransaction transaction, InternalCDORevision cleanRevision, InternalCDORevision currentRevision) {
        Object currentContainerID;
        int currentContainingFeatureID;
        CDOID currentResourceID;
        CDOID cleanResourceID = cleanRevision.getResourceID();
        if (cleanResourceID != (currentResourceID = currentRevision.getResourceID())) {
            return false;
        }
        int cleanContainingFeatureID = cleanRevision.getContainingFeatureID();
        if (cleanContainingFeatureID != (currentContainingFeatureID = currentRevision.getContainingFeatureID())) {
            return false;
        }
        Object cleanContainerID = cleanRevision.getContainerID();
        return CDOUndoDetectorImpl.equalReference(transaction, cleanContainerID, currentContainerID = currentRevision.getContainerID());
    }

    protected boolean ignore(EStructuralFeature feature, InternalCDORevision cleanRevision, InternalCDORevision currentRevision) {
        return feature.isMany() && !cleanRevision.isUnchunked() && !currentRevision.isUnchunked();
    }

    private static boolean equalReference(CDOTransaction transaction, Object cleanValue, Object currentValue) {
        CDOID id;
        if (currentValue instanceof EObject && cleanValue instanceof CDOIDExternal && (id = ((CDOIDProvider)transaction).provideCDOID(currentValue)) != null) {
            currentValue = id;
        }
        return cleanValue == currentValue;
    }

    private static int size(List<?> list) {
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public static final class NoFeatures
    implements CDOUndoDetector {
        public boolean detectUndo(CDOTransaction transaction, CDORevision cleanRevision, CDORevision currentRevision, CDOFeatureDelta featureDelta) {
            return false;
        }
    }

    public static final class SingleValuedFeatures
    extends CDOUndoDetectorImpl {
        protected boolean ignore(EStructuralFeature feature, InternalCDORevision cleanRevision, InternalCDORevision currentRevision) {
            if (feature.isMany()) {
                return false;
            }
            return super.ignore(feature, cleanRevision, currentRevision);
        }
    }
}

