/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable;

import java.util.List;
import net.sourceforge.nattable.config.CellConfigAttributes;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.layer.config.DefaultColumnHeaderStyleConfiguration;
import net.sourceforge.nattable.painter.cell.BackgroundPainter;
import net.sourceforge.nattable.painter.cell.ICellPainter;
import net.sourceforge.nattable.sort.painter.SortableHeaderTextPainter;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.ColorUtils;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.DefaultSizeUtils;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.NatTableWidget;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.HeaderImagePainter;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.HorizontalPainterWrapper;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.painter.CustomizedCellPainter;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.painter.cell.decorator.LightColumnBorderDecorator;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable.painter.cell.decorator.LightCornerBorderDecorator;
import org.eclipse.jface.viewers.ILabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyledColumnHeaderConfiguration
extends DefaultColumnHeaderStyleConfiguration {
    private final NatTableWidget.BodyLayerStack bodyLayer;
    private final List<Column> columnDescriptions;
    private final ICustomizedLabelProvider labelProvider;
    private final NatTableWidget natTableWidget;
    private final ICellPainter painter;

    public StyledColumnHeaderConfiguration(NatTableWidget.BodyLayerStack bodyLayer, List<Column> columnDescriptions, ICustomizedLabelProvider labelProvider, NatTableWidget natTableWidget) {
        this.font = DefaultSizeUtils.getHeaderFont();
        this.bodyLayer = bodyLayer;
        this.columnDescriptions = columnDescriptions;
        this.labelProvider = labelProvider;
        this.natTableWidget = natTableWidget;
        this.bgColor = ColorUtils.getHeaderBackgoundColor();
        this.painter = this.createCellPainter();
    }

    public void configureRegistry(IConfigRegistry configRegistry) {
        super.configureRegistry(configRegistry);
        BackgroundPainter bgPainter = new BackgroundPainter();
        LightCornerBorderDecorator cornerDecorator = new LightCornerBorderDecorator((ICellPainter)bgPainter);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)cornerDecorator, "NORMAL", "CORNER");
        this.addNormalModeStyling(configRegistry);
        this.addSelectedModeStyling(configRegistry);
    }

    private void addSelectedModeStyling(IConfigRegistry configRegistry) {
        SortableHeaderTextPainter selectedHeaderPainter = new SortableHeaderTextPainter(this.painter, false);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)selectedHeaderPainter, "SELECT", "COLUMN_HEADER");
    }

    private ICellPainter createCellPainter() {
        CustomizedCellPainter txtPainter = new CustomizedCellPainter(this.labelProvider, this.natTableWidget);
        HeaderImagePainter headerImagePainter = new HeaderImagePainter(this.bodyLayer, this.columnDescriptions, (ILabelProvider)this.labelProvider);
        ICellPainter[] cellPainters = new ICellPainter[]{headerImagePainter, txtPainter};
        HorizontalPainterWrapper hPainter = new HorizontalPainterWrapper(cellPainters);
        BackgroundPainter backgndPainter = new BackgroundPainter((ICellPainter)hPainter);
        return new LightColumnBorderDecorator((ICellPainter)backgndPainter);
    }

    private void addNormalModeStyling(IConfigRegistry configurationRegistry) {
        SortableHeaderTextPainter headerPainter = new SortableHeaderTextPainter(this.painter, false);
        configurationRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)headerPainter, "NORMAL", "COLUMN_HEADER");
        configurationRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)headerPainter, "NORMAL", "SORT_DOWN");
        configurationRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)headerPainter, "NORMAL", "SORT_UP");
    }
}

