/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.query.core.java.internal;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.gmt.modisco.infra.common.core.internal.resource.MoDiscoResourceSet;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.query.JavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.gmt.modisco.infra.query.ModelQuerySet;
import org.eclipse.gmt.modisco.infra.query.QueryPackage;
import org.eclipse.gmt.modisco.infra.query.core.AbstractModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.IModelQueryFactory;
import org.eclipse.gmt.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.gmt.modisco.infra.query.core.exception.BundleClassPathException;
import org.eclipse.gmt.modisco.infra.query.core.exception.ExecutionEnvironmentException;
import org.eclipse.gmt.modisco.infra.query.core.exception.MissingBundleException;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryException;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.core.exception.ProjectDisabledException;
import org.eclipse.gmt.modisco.infra.query.core.internal.Activator;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.java.internal.JavaModelQueryAdapter;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class JavaModelQueryFactory
implements IModelQueryFactory {
    private static final long DELAY = 1000L;
    private static IResourceChangeListener changeListener = null;
    private static HashMap<IProject, Bundle> bundleMap = new HashMap();
    private static HashMap<IProject, Long> disabledProjects = new HashMap();
    private static HashMap<IProject, ModelQueryException> disabledProjectsCause = new HashMap();

    public JavaModelQueryFactory() {
        if (changeListener == null) {
            changeListener = JavaModelQueryFactory.initChangeListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractModelQuery create(ModelQuery modelQuery, Bundle bundle) throws ModelQueryException {
        if (!(modelQuery instanceof JavaModelQuery)) {
            throw new ModelQueryException("Wrong kind of ModelQuery: " + modelQuery.getClass().getSimpleName() + " found, " + JavaModelQuery.class.getSimpleName() + " expected.");
        }
        AbstractModelQuery javaModelQueryInst = null;
        IProject project = null;
        try {
            Bundle localBundle;
            JavaModelQuery javaModelQuery = (JavaModelQuery)modelQuery;
            if (javaModelQuery.getModelQuerySet() == null) {
                throw new IllegalStateException("JavaModelQuery '" + javaModelQuery.getName() + " 'is not in any query set");
            }
            if (bundle == null) {
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                String querySetName = modelQuery.getModelQuerySet().getName();
                URI uri = ModelQuerySetCatalog.getSingleton().getURI(querySetName);
                if (uri == null) {
                    throw new IllegalStateException("QuerySet not found: " + querySetName);
                }
                Path querySetPath = new Path(uri.toPlatformString(true));
                IResource file = ws.getRoot().findMember((IPath)querySetPath);
                if (file == null) {
                    throw new IllegalStateException("QuerySet file not found: " + querySetPath.toString());
                }
                project = file.getProject();
                localBundle = bundleMap.get(project);
                this.checkProjectEnabled(project);
                if (localBundle == null) {
                    localBundle = Activator.getDefault().installBundle(project);
                    this.loadMetamodelsFromPluginXml(project, localBundle);
                    bundleMap.put(project, localBundle);
                    ModelQuerySet oldModelQuerySet = javaModelQuery.getModelQuerySet();
                    if (oldModelQuerySet == null) {
                        throw new IllegalStateException("JavaModelQuery '" + javaModelQuery.getName() + " 'is not in any query set");
                    }
                    ModelQuerySet modelQuerySet = ModelQuerySetCatalog.getSingleton().getModelQuerySet(querySetName);
                    if (modelQuerySet == null) {
                        throw new IllegalStateException("Couln't find a QuerySet named '" + querySetName + "'");
                    }
                    if ((javaModelQuery = (JavaModelQuery)modelQuerySet.getQuery(javaModelQuery.getName())) == null) {
                        throw new IllegalStateException("Couldn't reload the JavaModelQuery");
                    }
                }
                this.checkBundleClassPath(project, localBundle);
                this.checkRequiredExecutionEnvironment(localBundle);
                this.checkDependencies(localBundle);
            } else {
                localBundle = bundle;
            }
            String className = javaModelQuery.getImplementationClassName();
            if (className == null || className.length() == 0) {
                throw new ModelQueryExecutionException("implementationClassName is empty");
            }
            Class javaModelQueryClass = localBundle.loadClass(className);
            if (!IJavaModelQuery.class.isAssignableFrom(javaModelQueryClass)) {
                throw new Exception(String.valueOf(className) + " does not implement " + IJavaModelQuery.class.getSimpleName() + ".");
            }
            javaModelQueryInst = this.createJavaModelQueryImpl(javaModelQuery, javaModelQueryClass);
            javaModelQueryInst.setCheckResult(bundle != null);
        }
        catch (ExecutionEnvironmentException e) {
            if (project != null) {
                HashMap<IProject, Long> javaModelQuery = disabledProjects;
                synchronized (javaModelQuery) {
                    disabledProjects.put(project, new Long(System.currentTimeMillis()));
                }
            }
            throw e;
        }
        catch (MissingBundleException e) {
            if (project != null) {
                HashMap<IProject, Long> javaModelQuery = disabledProjects;
                synchronized (javaModelQuery) {
                    disabledProjects.put(project, new Long(System.currentTimeMillis()));
                }
            }
            throw e;
        }
        catch (BundleClassPathException e) {
            if (project != null) {
                HashMap<IProject, Long> javaModelQuery = disabledProjects;
                synchronized (javaModelQuery) {
                    disabledProjects.put(project, new Long(System.currentTimeMillis()));
                }
            }
            throw e;
        }
        catch (ProjectDisabledException e) {
            throw e;
        }
        catch (Exception e) {
            ModelQueryException mqe = new ModelQueryException("Failed to load the model query: " + modelQuery.getModelQuerySet().getName() + "::" + modelQuery.getName(), e);
            MoDiscoLogger.logError((Throwable)mqe, (Plugin)Activator.getDefault());
            throw mqe;
        }
        return javaModelQueryInst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkProjectEnabled(IProject project) throws ProjectDisabledException {
        HashMap<IProject, Long> hashMap = disabledProjects;
        synchronized (hashMap) {
            Long timestamp = disabledProjects.get(project);
            if (timestamp != null) {
                long sinceLastTry = System.currentTimeMillis() - timestamp;
                if (sinceLastTry < 1000L) {
                    throw new ProjectDisabledException(disabledProjectsCause.get(project));
                }
                disabledProjectsCause.remove(project);
                disabledProjects.remove(project);
            }
        }
    }

    private void checkDependencies(Bundle localBundle) throws BundleException, MissingBundleException {
        ManifestElement[] manifestElements;
        String dependencies = (String)localBundle.getHeaders().get("Require-Bundle");
        ManifestElement[] manifestElementArray = manifestElements = ManifestElement.parseHeader((String)"Require-Bundle", (String)dependencies);
        int n = manifestElements.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement manifestElement = manifestElementArray[n2];
            String bundleName = manifestElement.getValue();
            if (Platform.getBundle((String)bundleName) == null) {
                throw new MissingBundleException(bundleName);
            }
            ++n2;
        }
    }

    private void checkRequiredExecutionEnvironment(Bundle localBundle) throws ExecutionEnvironmentException {
        String requiredExecEnv = (String)localBundle.getHeaders().get("Bundle-RequiredExecutionEnvironment");
        Properties p = System.getProperties();
        String availableExecEnv = (String)p.get("org.osgi.framework.executionenvironment");
        if (!availableExecEnv.contains(requiredExecEnv)) {
            throw new ExecutionEnvironmentException(requiredExecEnv, availableExecEnv);
        }
    }

    private void checkBundleClassPath(IProject project, Bundle localBundle) throws BundleClassPathException {
        boolean found = false;
        IPath outputLocation = null;
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                outputLocation = javaProject.getOutputLocation();
                Object header = localBundle.getHeaders().get("Bundle-ClassPath");
                if (header instanceof String) {
                    String[] bundleClassPathElements;
                    String bundleClasspath = (String)header;
                    String[] stringArray = bundleClassPathElements = bundleClasspath.split(",");
                    int n = bundleClassPathElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String bundleClassPathEntry = stringArray[n2];
                        if (project.getFullPath().append(bundleClassPathEntry.trim()).equals((Object)outputLocation)) {
                            found = true;
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (String)"Error checking bundle classpath", (Plugin)Activator.getDefault());
            return;
        }
        if (!found) {
            throw new BundleClassPathException(project, outputLocation, localBundle);
        }
    }

    private AbstractModelQuery createJavaModelQueryImpl(JavaModelQuery javaModelQuery, Class<?> javaModelQueryClass) throws InstantiationException, IllegalAccessException {
        IJavaModelQuery javaModelQueryInst = (IJavaModelQuery)javaModelQueryClass.newInstance();
        JavaModelQueryAdapter adapter = new JavaModelQueryAdapter((ModelQuery)javaModelQuery, javaModelQueryInst);
        return adapter;
    }

    @Override
    public EClass getManagedModelQueryType() {
        return QueryPackage.eINSTANCE.getJavaModelQuery();
    }

    static HashMap<IProject, Bundle> getBundleMap() {
        return bundleMap;
    }

    private static IResourceChangeListener initChangeListener() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IResourceChangeListener listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event != null) {
                    this.checkDelta(event.getDelta());
                }
            }

            private void checkDelta(IResourceDelta delta) {
                if (delta != null) {
                    IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
                    int n = iResourceDeltaArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResourceDelta subdelta = iResourceDeltaArray[n2];
                        this.checkDelta(subdelta);
                        ++n2;
                    }
                    IResource resource = delta.getResource();
                    if (resource != null && "class".equals(resource.getFileExtension())) {
                        IProject project = resource.getProject();
                        Set<IProject> listened = JavaModelQueryFactory.getBundleMap().keySet();
                        if (listened.contains(project) && project.getLocation() != null) {
                            JavaModelQueryFactory.getBundleMap().remove(project);
                        }
                    }
                }
            }
        };
        workspace.addResourceChangeListener(listener);
        return listener;
    }

    void loadMetamodelsFromPluginXml(IProject project, Bundle bundle) {
        IPluginExtension[] extensions;
        String generatedPackageExtensionPoint = String.valueOf(EcorePlugin.getPlugin().getSymbolicName()) + "." + "generated_package";
        IPluginModelBase pluginModel = PluginRegistry.findModel((IProject)project);
        IPluginExtension[] iPluginExtensionArray = extensions = pluginModel.getExtensions().getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension pluginExtension = iPluginExtensionArray[n2];
            if (generatedPackageExtensionPoint.equals(pluginExtension.getPoint())) {
                IPluginObject[] children;
                IPluginObject[] iPluginObjectArray = children = pluginExtension.getChildren();
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPluginObject child = iPluginObjectArray[n4];
                    if (child instanceof IPluginElement) {
                        IPluginElement pluginElement = (IPluginElement)child;
                        IPluginAttribute[] attributes = pluginElement.getAttributes();
                        String uri = null;
                        String className = null;
                        IPluginAttribute[] iPluginAttributeArray = attributes;
                        int n5 = attributes.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IPluginAttribute pluginAttribute = iPluginAttributeArray[n6];
                            if ("class".equalsIgnoreCase(pluginAttribute.getName())) {
                                className = pluginAttribute.getValue();
                            } else if ("uri".equalsIgnoreCase(pluginAttribute.getName())) {
                                uri = pluginAttribute.getValue();
                            }
                            ++n6;
                        }
                        if (className == null || uri == null) {
                            MoDiscoLogger.logError((String)"Error in extension generated_package: couldn't hotload metamodel", (Plugin)Activator.getDefault());
                        }
                        this.loadEPackage(bundle, uri, className);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void loadEPackage(Bundle bundle, String uri, String className) {
        try {
            Class ePackageClass = bundle.loadClass(className);
            Field instanceField = ePackageClass.getField("eINSTANCE");
            EPackage ePackage = (EPackage)instanceField.get(null);
            EPackage.Registry.INSTANCE.put((Object)ePackage.getNsURI(), (Object)ePackage);
            MoDiscoResourceSet.getResourceSetSingleton().aResourceHasBeenLoaded(ePackage.eResource());
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (String)("Failed to load an EPackage: " + uri), (Plugin)Activator.getDefault());
        }
    }
}

