/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.adapter;

import java.awt.Rectangle;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITableComponent;
import org.eclipse.jubula.rc.swt.components.ISWTTableComponent;
import org.eclipse.jubula.rc.swt.listener.TableSelectionTracker;
import org.eclipse.jubula.rc.swt.tester.adapter.ControlAdapter;
import org.eclipse.jubula.rc.swt.tester.util.CAPUtil;
import org.eclipse.jubula.rc.swt.utils.SwtPointUtil;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableAdapter
extends ControlAdapter
implements ITableComponent,
ISWTTableComponent {
    private static AutServerLogger log = new AutServerLogger(TableAdapter.class);
    private Table m_table;

    public TableAdapter(Object objectToAdapt) {
        super(objectToAdapt);
        this.m_table = (Table)objectToAdapt;
    }

    public int getColumnCount() {
        return (Integer)this.getEventThreadQueuer().invokeAndWait("getColumnCount", (IRunnable)new IRunnable<Integer>(){

            public Integer run() {
                return TableAdapter.this.m_table.getColumnCount();
            }
        });
    }

    public int getRowCount() {
        return (Integer)this.getEventThreadQueuer().invokeAndWait("getRowCount", (IRunnable)new IRunnable<Integer>(){

            public Integer run() {
                return TableAdapter.this.m_table.getItemCount();
            }
        });
    }

    public String getCellText(final int row, final int column) {
        return (String)this.getEventThreadQueuer().invokeAndWait("getCellText", (IRunnable)new IRunnable<String>(){

            public String run() {
                TableItem item = TableAdapter.this.m_table.getItem(row);
                String value = CAPUtil.getWidgetText((Widget)item, "TEST_TESTABLE_TEXT_" + column, item.getText(column));
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Getting cell text:");
                    log.debug((Object)("Row, col: " + row + ", " + column));
                    log.debug((Object)("Value: " + value));
                }
                return value;
            }
        });
    }

    public String getColumnHeaderText(final int colIdx) {
        return (String)this.getEventThreadQueuer().invokeAndWait("getColumnName", (IRunnable)new IRunnable<String>(){

            public String run() {
                TableColumn column = TableAdapter.this.m_table.getColumn(colIdx);
                return CAPUtil.getWidgetText((Widget)column, column.getText());
            }
        });
    }

    public String getRowText(final int rowIdx) {
        return (String)this.getEventThreadQueuer().invokeAndWait("getRowText", (IRunnable)new IRunnable<String>(){

            public String run() {
                TableItem row = TableAdapter.this.m_table.getItem(rowIdx);
                return CAPUtil.getWidgetText((Widget)row, row.getText());
            }
        });
    }

    public Rectangle getBounds() {
        return (Rectangle)this.getEventThreadQueuer().invokeAndWait("getBounds", (IRunnable)new IRunnable<Rectangle>(){

            public Rectangle run() throws StepExecutionException {
                org.eclipse.swt.graphics.Rectangle rect = TableAdapter.this.m_table.getBounds();
                return new Rectangle(rect.x, rect.y, rect.width, rect.height);
            }
        });
    }

    public Rectangle getHeaderBounds(final int col) {
        return (Rectangle)this.getEventThreadQueuer().invokeAndWait("getHeaderBounds", (IRunnable)new IRunnable<Rectangle>(){

            public Rectangle run() throws StepExecutionException {
                org.eclipse.swt.graphics.Rectangle rect = TableAdapter.this.m_table.getItem(0).getBounds(col);
                rect.y = ((TableAdapter)TableAdapter.this).m_table.getClientArea().y;
                return new Rectangle(rect.x, rect.y, rect.width, rect.height);
            }
        });
    }

    public Cell getSelectedCell() throws StepExecutionException {
        return (Cell)this.getEventThreadQueuer().invokeAndWait("getSelectedSell", (IRunnable)new IRunnable<Cell>(){

            public Cell run() throws StepExecutionException {
                return TableSelectionTracker.getInstance().getSelectedCell(TableAdapter.this.m_table);
            }
        });
    }

    public boolean isHeaderVisible() {
        return (Boolean)this.getEventThreadQueuer().invokeAndWait("isHeaderVisible", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() {
                return TableAdapter.this.m_table.getHeaderVisible();
            }
        });
    }

    public boolean isCellEditable(int row, int col) {
        Control cellEditor = (Control)this.activateEditor(new Cell(row, col));
        return this.invokeIsEditable(cellEditor);
    }

    public boolean hasCellSelection() {
        TableItem[] selItems = (TableItem[])this.getEventThreadQueuer().invokeAndWait("hasCellSelection", (IRunnable)new IRunnable<TableItem[]>(){

            public TableItem[] run() {
                return TableAdapter.this.m_table.getSelection();
            }
        });
        return selItems.length > 0;
    }

    public Rectangle scrollCellToVisible(final int row, final int col) throws StepExecutionException {
        final Table table = this.m_table;
        this.getEventThreadQueuer().invokeAndWait("scrollCellToVisible", (IRunnable)new IRunnable<Void>(){

            public Void run() {
                if (table.getColumnCount() > 0 || col > 0) {
                    table.showColumn(table.getColumn(col));
                }
                table.showItem(table.getItem(row));
                return null;
            }
        });
        this.checkRowColBounds(row, col);
        final org.eclipse.swt.graphics.Rectangle cBoundsRelToParent = SwtPointUtil.toSwtRectangle(this.getCellBounds(row, col, true));
        this.getEventThreadQueuer().invokeAndWait("getCellBoundsRelativeToParent", (IRunnable)new IRunnable<Void>(){

            public Void run() {
                Point cOriginRelToParent = table.getDisplay().map((Control)table, (Control)table.getParent(), new Point(cBoundsRelToParent.x, cBoundsRelToParent.y));
                cBoundsRelToParent.x = cOriginRelToParent.x;
                cBoundsRelToParent.y = cOriginRelToParent.y;
                return null;
            }
        });
        Control parent = (Control)this.getEventThreadQueuer().invokeAndWait("getParent", (IRunnable)new IRunnable<Control>(){

            public Control run() {
                return table.getParent();
            }
        });
        this.getRobot().scrollToVisible((Object)parent, (Object)cBoundsRelToParent);
        return this.getVisibleBounds(this.getCellBounds(row, col, true));
    }

    private void checkBounds(int value, int count) {
        if (value < 0 || value >= count) {
            throw new StepExecutionException("Invalid row/column: " + value, EventFactory.createActionError((String)"TestErrorEvent.InvalidIndexOrHeader"));
        }
    }

    protected void checkRowColBounds(int row, int column) throws StepExecutionException {
        this.checkBounds(row, this.getRowCount());
        int colCount = this.getColumnCount();
        if (colCount > 0 || column > 0) {
            this.checkBounds(column, colCount);
        }
    }

    private Rectangle getVisibleBounds(Rectangle cellBounds) {
        org.eclipse.swt.graphics.Rectangle r = (org.eclipse.swt.graphics.Rectangle)this.getEventThreadQueuer().invokeAndWait("getVisibleCellBounds: " + cellBounds, (IRunnable)new IRunnable<org.eclipse.swt.graphics.Rectangle>(){

            public org.eclipse.swt.graphics.Rectangle run() {
                return TableAdapter.this.m_table.getClientArea();
            }
        });
        Rectangle visibleTableBounds = new Rectangle(r.x, r.y, r.width, r.height);
        Rectangle visibleCellBounds = visibleTableBounds.intersection(cellBounds);
        return visibleCellBounds;
    }

    private boolean invokeIsEditable(final Control cellEditor) {
        return (Boolean)this.getEventThreadQueuer().invokeAndWait("getSelectedCell", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() {
                if (cellEditor == null || cellEditor instanceof TableCursor || cellEditor == TableAdapter.this.m_table) {
                    return false;
                }
                if ((cellEditor.getStyle() & 8) == 0) {
                    return true;
                }
                return false;
            }
        });
    }

    public Object activateEditor(Cell cell) {
        Rectangle rect = this.scrollCellToVisible(cell.getRow(), cell.getCol());
        Control editor = SwtUtils.getEditor((Widget)this.m_table, SwtPointUtil.toSwtRectangle(rect), this.getRobot());
        if (!this.invokeIsEditable(editor)) {
            org.eclipse.swt.graphics.Rectangle cellBounds = new org.eclipse.swt.graphics.Rectangle(rect.x, rect.y, rect.width, rect.height);
            ClickOptions co = ClickOptions.create().setClickCount(2);
            Table clickTarget = editor == null || editor instanceof TableCursor ? this.m_table : editor;
            this.getRobot().click((Object)clickTarget, (Object)cellBounds, co);
            editor = SwtUtils.getEditor((Widget)this.m_table, SwtPointUtil.toSwtRectangle(rect), this.getRobot());
        }
        return editor;
    }

    public String getText() {
        Cell selectedCell = this.getSelectedCell();
        return this.getCellText(selectedCell.getRow(), selectedCell.getCol());
    }

    public Object getTableHeader() {
        return this.m_table;
    }

    public String getPropertyValueOfCell(final String name, final Object cell) {
        return (String)this.getEventThreadQueuer().invokeAndWait("getPropertyValueOfCell", (IRunnable)new IRunnable<String>(){

            public String run() {
                return TableAdapter.this.getRobot().getPropertyValue(cell, name);
            }
        });
    }

    public boolean doesRowExist(final int rowInd) {
        return (Boolean)this.getEventThreadQueuer().invokeAndWait("doesRowExist", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() throws StepExecutionException {
                if (rowInd >= 0 && rowInd < TableAdapter.this.m_table.getItemCount()) {
                    return true;
                }
                return false;
            }
        });
    }

    public int getTopIndex() {
        return (Integer)this.getEventThreadQueuer().invokeAndWait("getTopIndex", (IRunnable)new IRunnable<Integer>(){

            public Integer run() throws StepExecutionException {
                return TableAdapter.this.m_table.getTopIndex();
            }
        });
    }

    public boolean isChecked(final int row) {
        return (Boolean)this.getEventThreadQueuer().invokeAndWait("isChecked", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() throws StepExecutionException {
                return TableAdapter.this.m_table.getItem(row).getChecked();
            }
        });
    }

    public int getSelectionIndex() {
        return (Integer)this.getEventThreadQueuer().invokeAndWait("getSelectionIndex", (IRunnable)new IRunnable<Integer>(){

            public Integer run() throws StepExecutionException {
                return TableAdapter.this.m_table.getSelectionIndex();
            }
        });
    }

    public Rectangle getCellBounds(final int row, final int col, final boolean restr) {
        return (Rectangle)this.getEventThreadQueuer().invokeAndWait("getCellBounds", (IRunnable)new IRunnable<Rectangle>(){

            public Rectangle run() throws StepExecutionException {
                TableItem ti = TableAdapter.this.m_table.getItem(row);
                int column = TableAdapter.this.m_table.getColumnCount() > 0 || col > 0 ? col : 0;
                org.eclipse.swt.graphics.Rectangle cellbound = ti.getBounds(column);
                if (!restr) {
                    return SwtPointUtil.toAwtRectangle(cellbound);
                }
                org.eclipse.swt.graphics.Rectangle calculatedBounds = new org.eclipse.swt.graphics.Rectangle(cellbound.x, cellbound.y, cellbound.width, cellbound.height);
                String text = CAPUtil.getWidgetText((Widget)ti, "TEST_TESTABLE_TEXT_" + column, ti.getText(column));
                Image image = ti.getImage(column);
                if (text != null && text.length() != 0) {
                    GC gc = new GC((Drawable)TableAdapter.this.m_table);
                    int charWidth = 0;
                    try {
                        FontMetrics fm = gc.getFontMetrics();
                        charWidth = fm.getAverageCharWidth();
                    }
                    finally {
                        gc.dispose();
                    }
                    calculatedBounds.width = text.length() * charWidth;
                    if (image != null) {
                        calculatedBounds.width += image.getBounds().width;
                    }
                } else if (image != null) {
                    calculatedBounds.width = image.getBounds().width;
                }
                if (column > 0) {
                    TableColumn tc = TableAdapter.this.m_table.getColumn(column);
                    int alignment = tc.getAlignment();
                    if (alignment == 0x1000000) {
                        calculatedBounds.x = (int)((double)calculatedBounds.x + ((double)tc.getWidth() / 2.0 - (double)calculatedBounds.width / 2.0));
                    }
                    if (alignment == 131072) {
                        calculatedBounds.x += tc.getWidth() - calculatedBounds.width;
                    }
                }
                return SwtPointUtil.toAwtRectangle(cellbound.intersection(calculatedBounds));
            }
        });
    }

    public Item[] getColumnItems() {
        return this.m_table.getColumns();
    }
}

