/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.delegate;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicInvocationDelegate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationException;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.delegate.InvocationBehavior;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.pivot.internal.delegate.ValidationBehavior;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.Query;
import org.eclipse.ocl.pivot.utilities.SemanticException;

public class OCLInvocationDelegate
extends BasicInvocationDelegate {
    protected final OCLDelegateDomain delegateDomain;
    private Operation operation;
    private ExpressionInOCL query;

    public OCLInvocationDelegate(@NonNull OCLDelegateDomain delegateDomain, @NonNull EOperation operation) {
        super(operation);
        this.delegateDomain = delegateDomain;
    }

    public Object dynamicInvoke(InternalEObject target, EList<?> arguments) throws InvocationTargetException {
        try {
            OCL ocl = this.delegateDomain.getOCL();
            MetamodelManager metamodelManager = ocl.getMetamodelManager();
            ExpressionInOCL query2 = this.query;
            if (query2 == null) {
                Operation operation2 = this.operation;
                NamedElement namedElement = this.delegateDomain.getPivot(NamedElement.class, (EObject)ClassUtil.nonNullEMF(this.eOperation));
                if (namedElement instanceof Operation) {
                    operation2 = this.operation = (Operation)namedElement;
                    query2 = this.query = InvocationBehavior.INSTANCE.getQueryOrThrow(metamodelManager, operation2);
                    InvocationBehavior.INSTANCE.validate(operation2);
                } else if (namedElement instanceof Constraint) {
                    Constraint constraint = (Constraint)namedElement;
                    query2 = this.query = ValidationBehavior.INSTANCE.getQueryOrThrow(metamodelManager, constraint);
                    ValidationBehavior.INSTANCE.validate(constraint);
                } else {
                    if (namedElement != null) {
                        throw new OCLDelegateException(new SemanticException("Unsupported InvocationDelegate for a " + namedElement.eClass().getName()));
                    }
                    throw new OCLDelegateException(new SemanticException("Unsupported InvocationDelegate for a null"));
                }
            }
            return this.evaluate(ocl, query2, target, (List<?>)arguments);
        }
        catch (EvaluationException e) {
            throw new OCLDelegateException(new EvaluationException(e, PivotMessagesInternal.EvaluationResultIsInvalid_ERROR_, this.operation));
        }
    }

    protected Object evaluate(@NonNull OCL ocl, @NonNull ExpressionInOCL query2, InternalEObject target, List<?> arguments) {
        IdResolver idResolver = ocl.getIdResolver();
        Query query = ocl.createQuery(query2);
        EvaluationEnvironment env = query.getEvaluationEnvironment(target);
        Object object = target;
        Object value = idResolver.boxedValueOf(target);
        env.add(ClassUtil.nonNullModel(query2.getOwnedContext()), value);
        List<Variable> parms = query2.getOwnedParameters();
        if (!parms.isEmpty()) {
            int i = 0;
            while (i < parms.size()) {
                object = arguments.get(i);
                value = idResolver.boxedValueOf(object);
                env.add(ClassUtil.nonNullModel(parms.get(i)), value);
                ++i;
            }
        }
        Object ecoreResult = query.evaluateEcore(this.eOperation.getEType().getInstanceClass(), target);
        return ecoreResult;
    }

    public @NonNull Operation getOperation() {
        Operation operation2 = this.operation;
        if (operation2 == null) {
            NamedElement pivot = this.delegateDomain.getPivot(NamedElement.class, (EObject)ClassUtil.nonNullEMF(this.eOperation));
            if (pivot instanceof Operation) {
                operation2 = this.operation = (Operation)pivot;
            }
            if (operation2 == null) {
                throw new OCLDelegateException(new SemanticException("No pivot property for " + this.eOperation));
            }
        }
        return operation2;
    }

    public @NonNull ExpressionInOCL getQueryOrThrow(@NonNull MetamodelManager metamodelManager, @NonNull Constraint constraint) {
        LanguageExpression specification = constraint.getOwnedSpecification();
        if (specification == null) {
            throw new OCLDelegateException(new SemanticException(PivotMessagesInternal.MissingSpecificationBody_ERROR_, constraint.getContext(), "\u00abbody\u00bb"));
        }
        try {
            return ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)metamodelManager.getEnvironmentFactory()).parseSpecification(specification);
        }
        catch (ParserException e) {
            throw new OCLDelegateException(e);
        }
    }

    public String toString() {
        if (this.operation != null) {
            return "<" + this.delegateDomain.getURI() + ":invocation> " + this.operation;
        }
        String name = String.valueOf(this.eOperation.getEContainingClass().getEPackage().getName()) + "::" + this.eOperation.getEContainingClass().getName() + "." + this.eOperation.getName();
        return "<" + this.delegateDomain.getURI() + ":invocation> " + name;
    }
}

