/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.TemplateParameters;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.MapTypeId;
import org.eclipse.ocl.pivot.ids.TemplateableId;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.values.BagImpl;
import org.eclipse.ocl.pivot.internal.values.BagValueImpl;
import org.eclipse.ocl.pivot.internal.values.BigIntegerValueImpl;
import org.eclipse.ocl.pivot.internal.values.CollectionValueImpl;
import org.eclipse.ocl.pivot.internal.values.IntIntegerValueImpl;
import org.eclipse.ocl.pivot.internal.values.IntegerRangeImpl;
import org.eclipse.ocl.pivot.internal.values.JavaObjectValueImpl;
import org.eclipse.ocl.pivot.internal.values.LongIntegerValueImpl;
import org.eclipse.ocl.pivot.internal.values.MapEntryImpl;
import org.eclipse.ocl.pivot.internal.values.MapValueImpl;
import org.eclipse.ocl.pivot.internal.values.NullValueImpl;
import org.eclipse.ocl.pivot.internal.values.OrderedSetImpl;
import org.eclipse.ocl.pivot.internal.values.RangeSequenceValueImpl;
import org.eclipse.ocl.pivot.internal.values.RealValueImpl;
import org.eclipse.ocl.pivot.internal.values.SetValueImpl;
import org.eclipse.ocl.pivot.internal.values.SparseOrderedSetValueImpl;
import org.eclipse.ocl.pivot.internal.values.SparseSequenceValueImpl;
import org.eclipse.ocl.pivot.internal.values.TupleValueImpl;
import org.eclipse.ocl.pivot.internal.values.UnlimitedValueImpl;
import org.eclipse.ocl.pivot.library.UnsupportedOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.messages.StatusCodes;
import org.eclipse.ocl.pivot.types.AbstractInheritance;
import org.eclipse.ocl.pivot.types.ParameterTypesImpl;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.values.Bag;
import org.eclipse.ocl.pivot.values.BagValue;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.IntegerRange;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.MapEntry;
import org.eclipse.ocl.pivot.values.MapValue;
import org.eclipse.ocl.pivot.values.NullValue;
import org.eclipse.ocl.pivot.values.NumberValue;
import org.eclipse.ocl.pivot.values.ObjectValue;
import org.eclipse.ocl.pivot.values.OrderedCollectionValue;
import org.eclipse.ocl.pivot.values.OrderedSetValue;
import org.eclipse.ocl.pivot.values.RealValue;
import org.eclipse.ocl.pivot.values.SequenceValue;
import org.eclipse.ocl.pivot.values.SetValue;
import org.eclipse.ocl.pivot.values.TupleValue;
import org.eclipse.ocl.pivot.values.UniqueCollectionValue;
import org.eclipse.ocl.pivot.values.Unlimited;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;
import org.eclipse.ocl.pivot.values.UnlimitedValue;
import org.eclipse.ocl.pivot.values.Value;
import org.eclipse.ocl.pivot.values.ValuesPackage;

public abstract class ValueUtil {
    private static final @NonNull String METAMODEL_NAME_PREFIX = "$metamodel$::";
    public static final @NonNull String NULL_STRING = "null";
    private static final int NEGATIVE_INTEGERS = 256;
    private static final int POSITIVE_INTEGERS = 1025;
    private static final @Nullable IntegerValue @NonNull [] INTEGER_VALUES = new IntegerValue[1281];
    public static @NonNull Bag<?> EMPTY_BAG = new BagImpl();
    public static final @NonNull Set<Object> EMPTY_SET = Collections.emptySet();
    public static final @NonNull BigInteger INTEGER_MAX_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final @NonNull BigInteger INTEGER_MIN_VALUE = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final @NonNull BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    public static final @NonNull BigInteger LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private static final String maxLongValue = Long.toString(Long.MAX_VALUE);
    private static final int maxLongSize = maxLongValue.length();
    public static final @NonNull Boolean FALSE_VALUE = Boolean.FALSE;
    public static final @NonNull InvalidValueException INVALID_VALUE = new InvalidValueException("invalid", new Object[0]);
    public static final @NonNull NullValue NULL_VALUE = new NullValueImpl();
    public static final @NonNull IntegerValue ONE_VALUE = ValueUtil.integerValueOf(1);
    public static final @NonNull UnlimitedNaturalValue UNLIMITED_ONE_VALUE = (UnlimitedNaturalValue)((Object)ONE_VALUE);
    public static final @NonNull Boolean TRUE_VALUE = Boolean.TRUE;
    public static final @NonNull UnlimitedValue UNLIMITED_VALUE = new UnlimitedValueImpl();
    public static final @NonNull IntegerValue ZERO_VALUE = ValueUtil.integerValueOf(0);
    private static boolean allStaticsInitialized = false;

    public static @NonNull BagValue asBagValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asBagValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Bag", ValueUtil.getTypeName(value));
    }

    public static @NonNull Boolean asBoolean(@Nullable Object value) {
        if (value == Boolean.TRUE) {
            return TRUE_VALUE;
        }
        if (value == Boolean.FALSE) {
            return FALSE_VALUE;
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Boolean", ValueUtil.getTypeName(value));
    }

    public static @NonNull Class asClass(@Nullable Object value) {
        if (value instanceof Class) {
            return (Class)value;
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Class", ValueUtil.getTypeName(value));
    }

    public static @NonNull CollectionType asCollectionType(@Nullable Object value) {
        if (value instanceof CollectionType) {
            return (CollectionType)value;
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "CollectionType", ValueUtil.getTypeName(value));
    }

    public static @NonNull CollectionValue asCollectionValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asCollectionValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Collection", ValueUtil.getTypeName(value));
    }

    public static @NonNull Integer asInteger(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asInteger();
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Integer", ValueUtil.getTypeName(value));
    }

    public static @NonNull IntegerValue asIntegerValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asIntegerValue();
        }
        if (value instanceof Number) {
            if (value instanceof BigInteger) {
                return ValueUtil.integerValueOf((BigInteger)value);
            }
            return ValueUtil.integerValueOf(((Number)value).longValue());
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Integer", ValueUtil.getTypeName(value));
    }

    public static @NonNull MapType asMapType(@Nullable Object value) {
        if (value instanceof MapType) {
            return (MapType)value;
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "MapType", ValueUtil.getTypeName(value));
    }

    public static @NonNull MapValue asMapValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asMapValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Map", ValueUtil.getTypeName(value));
    }

    @Deprecated
    public static @NonNull EObject asNavigableObject(@Nullable Object value, @NonNull Object navigation, @Nullable Evaluator evaluator) {
        return ValueUtil.asNavigableObject(value, navigation, evaluator != null ? ValueUtil.getExecutor(evaluator) : null);
    }

    public static @NonNull EObject asNavigableObject(@Nullable Object value, @NonNull Object navigation, @Nullable Executor executor) {
        Object unboxedValue;
        if (value instanceof Value) {
            return ((Value)value).asNavigableObject();
        }
        if (value instanceof EObject) {
            return (EObject)value;
        }
        if (value == null) {
            if (navigation instanceof ElementId) {
                throw new InvalidValueException(PivotMessages.NullNavigation, "source", ValueUtil.getElementIdName((ElementId)navigation));
            }
            String qualifiedName = NameUtil.qualifiedNameFor(navigation);
            int index = qualifiedName.indexOf("::");
            if (index > 0) {
                qualifiedName = qualifiedName.substring(index + 2);
            }
            throw new InvalidValueException(PivotMessages.NullNavigation, "source", qualifiedName);
        }
        if (executor != null && value instanceof ElementId && (unboxedValue = executor.getIdResolver().unboxedValueOf(value)) instanceof EObject) {
            return (EObject)unboxedValue;
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "NavigableObject", ValueUtil.getTypeName(value));
    }

    public static @Nullable Object asObject(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asObject();
        }
        return value;
    }

    public static @NonNull OrderedCollectionValue asOrderedCollectionValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asOrderedCollectionValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "OrderedCollection", ValueUtil.getTypeName(value));
    }

    public static @NonNull OrderedSetValue asOrderedSetValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asOrderedSetValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "OrderedSet", ValueUtil.getTypeName(value));
    }

    public static @NonNull RealValue asRealValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asRealValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Real", ValueUtil.getTypeName(value));
    }

    public static @NonNull SequenceValue asSequenceValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asSequenceValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Sequence", ValueUtil.getTypeName(value));
    }

    public static @NonNull SetValue asSetValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asSetValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Set", ValueUtil.getTypeName(value));
    }

    public static @NonNull String asString(@Nullable Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "String", ValueUtil.getTypeName(value));
    }

    public static @NonNull TupleValue asTupleValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asTupleValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Tuple", ValueUtil.getTypeName(value));
    }

    public static @NonNull Type asType(@Nullable Object value) {
        if (value instanceof Type) {
            return (Type)value;
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Type", ValueUtil.getTypeName(value));
    }

    public static @NonNull UniqueCollectionValue asUniqueCollectionValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asUniqueCollectionValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "UniqueCollection", ValueUtil.getTypeName(value));
    }

    public static @NonNull UnlimitedNaturalValue asUnlimitedNaturalValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asUnlimitedNaturalValue();
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "UnlimitedNatural", ValueUtil.getTypeName(value));
    }

    public static Object asValue(Object value) {
        if (value != null) {
            return value;
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "OclAny", ValueUtil.getTypeName(value));
    }

    public static @NonNull BigDecimal bigDecimalValueOf(@NonNull Object anObject) {
        if (anObject instanceof BigDecimal) {
            return (BigDecimal)anObject;
        }
        if (anObject instanceof Number) {
            return BigDecimal.valueOf(((Number)anObject).doubleValue());
        }
        if (anObject instanceof Character) {
            return BigDecimal.valueOf(((Character)anObject).charValue());
        }
        throw new InvalidValueException(PivotMessages.InvalidReal, anObject);
    }

    public static @NonNull BigInteger bigIntegerValueOf(@NonNull Object anObject) {
        if (anObject instanceof BigInteger) {
            return (BigInteger)anObject;
        }
        if (anObject instanceof Number) {
            return BigInteger.valueOf(((Number)anObject).longValue());
        }
        if (anObject instanceof Character) {
            return BigInteger.valueOf(((Character)anObject).charValue());
        }
        throw new InvalidValueException(PivotMessages.InvalidInteger, anObject);
    }

    public static byte byteValueOf(@Nullable Object anObject) {
        if (anObject instanceof Number) {
            return ((Number)anObject).byteValue();
        }
        throw new InvalidValueException(PivotMessages.InvalidInteger, anObject);
    }

    public static @NonNull Character characterValueOf(@NonNull Object anObject) {
        if (anObject instanceof Character) {
            return (Character)anObject;
        }
        if (anObject instanceof Number) {
            return Character.valueOf((char)((Number)anObject).longValue());
        }
        throw new InvalidValueException(PivotMessages.InvalidCharacter, anObject);
    }

    public static int computeCollectionHashCode(boolean isOrdered, boolean isUnique, @NonNull Iterable<?> elements) {
        long hash;
        long l = hash = isUnique ? 0x5555555555555555L : 0x7777777777777777L;
        if (isOrdered) {
            for (Object element : elements) {
                hash *= 5L;
                if (element == null) continue;
                hash += (long)element.hashCode();
            }
        } else {
            for (Object element : elements) {
                if (element == null) continue;
                hash += (long)element.hashCode();
            }
        }
        int hashCode = (int)hash;
        if (hashCode == 0 && (hashCode = (int)(hash >> 32)) == 0) {
            hashCode = -1737075662;
        }
        return hashCode;
    }

    public static @NonNull BagValue.Accumulator createBagAccumulatorValue(@NonNull CollectionTypeId collectedId) {
        return new BagValueImpl.Accumulator(collectedId);
    }

    public static @NonNull BagValue createBagOfEach(@NonNull CollectionTypeId typeId, Object ... boxedValues) {
        return new BagValueImpl(typeId, BagValueImpl.createBagOfEach(boxedValues));
    }

    public static @NonNull BagValue createBagRange(@NonNull CollectionTypeId typeId, Object ... values) {
        BagImpl<Object> allValues = new BagImpl<Object>();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value instanceof IntegerRange) {
                allValues.addAll((IntegerRange)value);
            } else {
                allValues.add(value);
            }
            ++n2;
        }
        return new BagValueImpl(typeId, (Bag<? extends Object>)allValues);
    }

    public static @NonNull BagValue createBagValue(@NonNull CollectionTypeId typeId, @NonNull Bag<? extends Object> boxedValues) {
        return new BagValueImpl(typeId, boxedValues);
    }

    public static @NonNull CollectionValue.Accumulator createCollectionAccumulatorValue(@NonNull CollectionTypeId collectedId) {
        CollectionTypeId collectionId = collectedId.getGeneralizedId();
        if (collectionId == TypeId.BAG) {
            return new BagValueImpl.Accumulator(collectedId);
        }
        if (collectionId == TypeId.ORDERED_SET) {
            return new SparseOrderedSetValueImpl.Accumulator(collectedId);
        }
        if (collectionId == TypeId.SEQUENCE) {
            return new SparseSequenceValueImpl.Accumulator(collectedId);
        }
        return new SetValueImpl.Accumulator(collectedId);
    }

    public static @NonNull InvalidValueException createInvalidValue(@NonNull Throwable e) {
        if (e instanceof InvalidValueException) {
            return (InvalidValueException)e;
        }
        return new InvalidValueException(e);
    }

    public static @NonNull InvalidValueException createInvalidValue(@NonNull Exception e) {
        if (e instanceof InvalidValueException) {
            return (InvalidValueException)e;
        }
        return new InvalidValueException(e);
    }

    public static @NonNull MapValue createMapOfEach(@NonNull MapTypeId typeId, MapEntry ... mapEntries) {
        return MapValueImpl.createMapValueOfEach(typeId, mapEntries);
    }

    public static @NonNull MapEntry createMapEntry(@NonNull Object key, @NonNull Object value) {
        return new MapEntryImpl(key, value);
    }

    public static @NonNull MapValue createMapValue(@NonNull TypeId keyTypeId, @NonNull TypeId valueTypeId, @NonNull Map<Object, Object> boxedValues) {
        return new MapValueImpl(TypeId.MAP.getSpecializedId(keyTypeId, valueTypeId), boxedValues);
    }

    public static @NonNull ObjectValue createObjectValue(@NonNull TypeId typeId, @NonNull Object object) {
        return new JavaObjectValueImpl(typeId, object);
    }

    public static @NonNull OrderedSetValue.Accumulator createOrderedSetAccumulatorValue(@NonNull CollectionTypeId collectedId) {
        return new SparseOrderedSetValueImpl.Accumulator(collectedId);
    }

    public static @NonNull OrderedSetValue createOrderedSetOfEach(@NonNull CollectionTypeId typeId, Object ... boxedValues) {
        return new SparseOrderedSetValueImpl(typeId, SparseOrderedSetValueImpl.createOrderedSetOfEach(boxedValues));
    }

    public static @NonNull OrderedSetValue createOrderedSetRange(@NonNull CollectionTypeId typeId, Object ... values) {
        OrderedSetImpl<Object> allValues = new OrderedSetImpl<Object>();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value instanceof IntegerRange) {
                allValues.addAll((IntegerRange)value);
            } else {
                allValues.add(value);
            }
            ++n2;
        }
        return new SparseOrderedSetValueImpl(typeId, allValues);
    }

    public static @NonNull OrderedSetValue createOrderedSetValue(@NonNull CollectionTypeId typeId, @NonNull Collection<? extends Object> boxedValues) {
        return new SparseOrderedSetValueImpl(typeId, boxedValues);
    }

    public static @NonNull IntegerRange createRange(@NonNull IntegerValue firstInteger, @NonNull IntegerValue lastInteger) {
        return new IntegerRangeImpl(firstInteger, lastInteger);
    }

    public static @NonNull SequenceValue.Accumulator createSequenceAccumulatorValue(@NonNull CollectionTypeId collectedId) {
        return new SparseSequenceValueImpl.Accumulator(collectedId);
    }

    public static @NonNull SequenceValue createSequenceOfEach(@NonNull CollectionTypeId typeId, Object ... boxedValues) {
        return new SparseSequenceValueImpl(typeId, SparseSequenceValueImpl.createSequenceOfEach(boxedValues));
    }

    public static @NonNull SequenceValue createSequenceRange(@NonNull CollectionTypeId typeId, @NonNull IntegerRange range) {
        return new RangeSequenceValueImpl(typeId, range);
    }

    public static @NonNull SequenceValue createSequenceRange(@NonNull CollectionTypeId typeId, Object ... values) {
        ArrayList<Object> allValues = new ArrayList<Object>();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value instanceof IntegerRange) {
                allValues.addAll((IntegerRange)value);
            } else {
                allValues.add(value);
            }
            ++n2;
        }
        return new SparseSequenceValueImpl(typeId, (List<? extends Object>)allValues);
    }

    public static @NonNull SequenceValue createSequenceValue(@NonNull CollectionTypeId typeId, @NonNull List<? extends Object> boxedValues) {
        return new SparseSequenceValueImpl(typeId, boxedValues);
    }

    public static @NonNull SetValue.Accumulator createSetAccumulatorValue(@NonNull CollectionTypeId collectedId) {
        return new SetValueImpl.Accumulator(collectedId);
    }

    public static @NonNull SetValue createSetOfEach(@NonNull CollectionTypeId typeId, Object ... boxedValues) {
        return new SetValueImpl(typeId, SetValueImpl.createSetOfEach(boxedValues));
    }

    public static @NonNull SetValue createSetRange(@NonNull CollectionTypeId typeId, Object ... values) {
        HashSet<Object> allValues = new HashSet<Object>();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value instanceof IntegerRange) {
                allValues.addAll((IntegerRange)value);
            } else {
                allValues.add(value);
            }
            ++n2;
        }
        return new SetValueImpl(typeId, allValues);
    }

    public static @NonNull SetValue createSetValue(@NonNull CollectionTypeId typeId, @NonNull Collection<? extends Object> boxedValues) {
        return new SetValueImpl(typeId, boxedValues);
    }

    public static @NonNull TupleValue createTupleValue(@NonNull TupleTypeId typeId, @NonNull Map<@NonNull ? extends TuplePartId, @Nullable Object> values) {
        return new TupleValueImpl(typeId, values);
    }

    public static @NonNull TupleValue createTupleOfEach(@NonNull TupleTypeId typeId, Object ... values) {
        return new TupleValueImpl(typeId, values);
    }

    public static double doubleValueOf(@Nullable Object anObject) {
        if (anObject instanceof Number) {
            return ((Number)anObject).doubleValue();
        }
        throw new InvalidValueException(PivotMessages.InvalidReal, anObject);
    }

    public static float floatValueOf(@Nullable Object anObject) {
        if (anObject instanceof Number) {
            return ((Number)anObject).floatValue();
        }
        throw new InvalidValueException(PivotMessages.InvalidReal, anObject);
    }

    public static @NonNull String getElementIdName(@NonNull ElementId elementId) {
        String name = elementId.toString();
        if (name.startsWith(METAMODEL_NAME_PREFIX)) {
            name = name.substring(METAMODEL_NAME_PREFIX.length());
        }
        return name;
    }

    @Deprecated
    public static @NonNull Executor getExecutor(@NonNull Evaluator evaluator) {
        if (evaluator instanceof Executor) {
            return (Executor)evaluator;
        }
        return ((EvaluationVisitor.EvaluationVisitorExtension)evaluator).getExecutor();
    }

    public static String getTypeName(@Nullable Object value) {
        if (value instanceof Boolean) {
            return "Boolean";
        }
        if (value instanceof String) {
            return "String";
        }
        if (value instanceof Value) {
            return ((Value)value).getTypeId().getDisplayName();
        }
        if (value == null) {
            return "OclVoid";
        }
        return "Object";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean initAllStatics() {
        if (allStaticsInitialized) return false;
        java.lang.Class<ValueUtil> clazz = ValueUtil.class;
        synchronized (ValueUtil.class) {
            block4: {
                if (allStaticsInitialized) break block4;
                allStaticsInitialized = true;
                ParameterTypesImpl.EMPTY_LIST.getClass();
                TemplateParameters.EMPTY_LIST.getClass();
                ModelManager.NULL.getClass();
                TemplateableId.NULL_TEMPLATEABLE_ID_ARRAY.getClass();
                TypeId.INTEGER.getClass();
                AbstractInheritance.initStatics();
                UnsupportedOperation.INSTANCE.getClass();
                PivotMessages.InvalidOperation.getClass();
                new StatusCodes();
                AbstractInheritance.initStatics();
                StringUtil.createNumberFromString("0");
                StandaloneProjectMap.initStatics();
                LabelUtil.SUBSTITUTION_LABEL_PROVIDER.getClass();
                ValuesPackage.eINSTANCE.getClass();
                CollectionValueImpl.initStatics();
                RealValueImpl.initStatics();
                // ** MonitorExit[var0] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return false;
        }
    }

    public static int intValueOf(@Nullable Object anObject) {
        if (anObject instanceof Number) {
            return ((Number)anObject).intValue();
        }
        throw new InvalidValueException(PivotMessages.InvalidInteger, anObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull IntegerValue integerValueOf(int value) {
        if (value > -256 && value < 1025) {
            int index = value + 256;
            IntegerValue integerValue = INTEGER_VALUES[index];
            if (integerValue != null) {
                return integerValue;
            }
            IntegerValue[] integerValueArray = INTEGER_VALUES;
            synchronized (INTEGER_VALUES) {
                integerValue = INTEGER_VALUES[index];
                if (integerValue != null) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return integerValue;
                }
                ValueUtil.INTEGER_VALUES[index] = new IntIntegerValueImpl(value);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return ValueUtil.INTEGER_VALUES[index];
            }
        }
        return new IntIntegerValueImpl(value);
    }

    public static @NonNull IntegerValue integerValueOf(long value) {
        if (Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE) {
            return ValueUtil.integerValueOf((int)value);
        }
        return new LongIntegerValueImpl(value);
    }

    public static @NonNull IntegerValue integerValueOf(@Nullable BigInteger value) {
        if (value == null) {
            throw new InvalidValueException(PivotMessages.InvalidInteger, value);
        }
        if (value.signum() >= 0) {
            if (value.compareTo(INTEGER_MAX_VALUE) <= 0) {
                return new IntIntegerValueImpl(value.intValue());
            }
            if (value.compareTo(LONG_MAX_VALUE) <= 0) {
                return new LongIntegerValueImpl(value.longValue());
            }
        } else {
            if (value.compareTo(INTEGER_MIN_VALUE) >= 0) {
                return new IntIntegerValueImpl(value.intValue());
            }
            if (value.compareTo(LONG_MIN_VALUE) >= 0) {
                return new LongIntegerValueImpl(value.longValue());
            }
        }
        return new BigIntegerValueImpl(value);
    }

    public static @NonNull IntegerValue integerValueOf(@Nullable Object aValue) {
        if (aValue instanceof BigInteger) {
            return ValueUtil.integerValueOf((BigInteger)aValue);
        }
        if (aValue instanceof Number) {
            return ValueUtil.integerValueOf(((Number)aValue).longValue());
        }
        if (aValue instanceof Character) {
            return ValueUtil.integerValueOf(((Character)aValue).charValue());
        }
        if (aValue instanceof IntegerValue) {
            return (IntegerValue)aValue;
        }
        throw new InvalidValueException(PivotMessages.InvalidInteger, aValue);
    }

    public static @NonNull IntegerValue integerValueOf(@NonNull String aValue) {
        try {
            int len = aValue.length();
            if (len < maxLongSize || len == maxLongSize && maxLongValue.compareTo(aValue) >= 0) {
                @NonNull BigInteger result = BigInteger.valueOf(Long.parseLong(aValue));
                return ValueUtil.integerValueOf(result);
            }
            return ValueUtil.integerValueOf(new BigInteger(aValue));
        }
        catch (NumberFormatException e) {
            throw new InvalidValueException(e, PivotMessages.InvalidInteger, aValue);
        }
    }

    public static boolean isBoxed(@Nullable Object object) {
        if (object instanceof NullValue) {
            return false;
        }
        if (object instanceof EnumerationLiteral) {
            return false;
        }
        if (object instanceof EEnumLiteral) {
            return false;
        }
        if (object instanceof Enumerator) {
            return false;
        }
        if (object instanceof Number && !(object instanceof RealValue) && !(object instanceof UnlimitedNaturalValue)) {
            return false;
        }
        return !(object instanceof Iterable) || object instanceof CollectionValue;
    }

    public static @Nullable CollectionValue isCollectionValue(@Nullable Object value) {
        if (value instanceof CollectionValue && !(value instanceof NullValue)) {
            return (CollectionValue)value;
        }
        return null;
    }

    public static boolean isEcore(Object object) {
        if (object instanceof NullValue) {
            return false;
        }
        if (object instanceof ElementId) {
            return false;
        }
        if (object instanceof RealValue) {
            return false;
        }
        if (object instanceof CollectionValue) {
            return false;
        }
        return !(object instanceof Collection) || object instanceof List;
    }

    public static boolean isIntegerNumber(@NonNull Number aNumber) {
        return aNumber instanceof BigInteger || aNumber instanceof Long || aNumber instanceof Integer || aNumber instanceof Short || aNumber instanceof Byte;
    }

    public static IntegerValue isIntegerValue(@Nullable Object value) {
        if (value instanceof IntegerValue && !(value instanceof NullValue)) {
            return (IntegerValue)value;
        }
        return null;
    }

    public static boolean isRealNumber(@NonNull Number aNumber) {
        return aNumber instanceof BigDecimal || aNumber instanceof Double || aNumber instanceof Float;
    }

    public static boolean isUnboxed(Object object) {
        if (object instanceof NullValue) {
            return false;
        }
        if (object instanceof ElementId) {
            return false;
        }
        if (object instanceof RealValue) {
            return false;
        }
        return !(object instanceof CollectionValue);
    }

    public static boolean isUnlimited(@Nullable Object value) {
        return value instanceof UnlimitedValue && !(value instanceof NullValue);
    }

    public static long longValueOf(@Nullable Object anObject) {
        if (anObject instanceof Number) {
            return ((Number)anObject).intValue();
        }
        throw new InvalidValueException(PivotMessages.InvalidInteger, anObject);
    }

    public static @NonNull NumberValue numberValueOf(@NonNull Number aNumber) {
        if (aNumber instanceof RealValue) {
            return (RealValue)((Object)aNumber);
        }
        if (aNumber instanceof BigDecimal) {
            return new RealValueImpl((BigDecimal)aNumber);
        }
        return ValueUtil.integerValueOf(aNumber);
    }

    public static @NonNull String oclToString(@NonNull Object value) {
        @NonNull String result = value.toString();
        return result;
    }

    public static @NonNull RealValue realValueOf(double value) {
        return new RealValueImpl(value);
    }

    public static @NonNull RealValue realValueOf(@Nullable BigDecimal value) {
        if (value != null) {
            return new RealValueImpl(value);
        }
        throw new InvalidValueException(PivotMessages.InvalidReal, value);
    }

    public static @NonNull RealValue realValueOf(@Nullable IntegerValue integerValue) {
        if (integerValue == null) {
            throw new InvalidValueException(PivotMessages.InvalidInteger, integerValue);
        }
        try {
            return ValueUtil.realValueOf(integerValue.bigDecimalValue());
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(e, PivotMessages.InvalidInteger, integerValue);
        }
    }

    public static @NonNull RealValue realValueOf(@Nullable Number aNumber) {
        if (aNumber instanceof RealValue) {
            return (RealValue)((Object)aNumber);
        }
        if (aNumber instanceof BigDecimal) {
            return new RealValueImpl((BigDecimal)aNumber);
        }
        if (aNumber instanceof BigInteger) {
            return new RealValueImpl(new BigDecimal((BigInteger)aNumber));
        }
        if (aNumber != null) {
            return new RealValueImpl(aNumber.doubleValue());
        }
        throw new InvalidValueException(PivotMessages.InvalidReal, aNumber);
    }

    public static @NonNull RealValue realValueOf(@NonNull String aValue) {
        try {
            return new RealValueImpl(new BigDecimal(aValue.trim()));
        }
        catch (NumberFormatException e) {
            throw new InvalidValueException(e, PivotMessages.InvalidReal, aValue);
        }
    }

    public static short shortValueOf(@Nullable Object anObject) {
        if (anObject instanceof Number) {
            return ((Number)anObject).shortValue();
        }
        throw new InvalidValueException(PivotMessages.InvalidInteger, anObject);
    }

    public static @NonNull String stringValueOf(@Nullable Object aValue) {
        String stringValue = null;
        if (aValue == null) {
            stringValue = NULL_STRING;
        } else if (aValue instanceof Value) {
            stringValue = ((Value)aValue).toString();
        } else if (aValue instanceof String) {
            stringValue = "'" + StringUtil.convertToOCLString((String)aValue) + "'";
        } else if (aValue instanceof EObject && !(aValue instanceof Element) && !(aValue instanceof EEnumLiteral)) {
            stringValue = LabelUtil.getLabel(aValue);
        } else {
            if (aValue.getClass().isArray()) {
                throw new UnsupportedOperationException();
            }
            if (aValue instanceof Iterable) {
                throw new UnsupportedOperationException();
            }
            stringValue = String.valueOf(aValue);
        }
        return stringValue != null ? stringValue : "<<null>>";
    }

    public static boolean throwBooleanInvalidValueException(@NonNull String string) {
        throw new InvalidValueException(string, new Object[0]);
    }

    public static @NonNull Object throwInvalidValueException() {
        throw new InvalidValueException("invalid", new Object[0]);
    }

    public static int throwUnsupportedCompareTo(@Nullable Object left, @Nullable Object right) {
        throw new InvalidValueException(PivotMessages.UnsupportedCompareTo, left != null ? left.getClass().getName() : NULL_STRING, right != null ? right.getClass().getName() : NULL_STRING);
    }

    public static void toString(@Nullable Object value, @NonNull StringBuilder s, int sizeLimit) {
        if (value instanceof Value) {
            ((Value)value).toString(s, sizeLimit);
        } else if (value instanceof String) {
            s.append("'");
            ValueUtil.toStringWithLimit(s, (String)value, sizeLimit);
            s.append("'");
        } else if (value != null) {
            ValueUtil.toStringWithLimit(s, value.toString(), sizeLimit);
        } else {
            ValueUtil.toStringWithLimit(s, NULL_STRING, sizeLimit);
        }
    }

    private static void toStringWithLimit(@NonNull StringBuilder s, String string, int sizeLimit) {
        int available;
        int length = string.length();
        if (length <= (available = sizeLimit - (length + 1))) {
            s.append(string);
        } else {
            if (available > 0) {
                s.append(string.substring(0, available));
            }
            s.append("...");
        }
    }

    public static <T> @NonNull Iterable<T> typedIterable(java.lang.Class<T> elementClass, @NonNull CollectionValue collectionValue) {
        return collectionValue;
    }

    public static @NonNull UnlimitedNaturalValue unlimitedNaturalValueOf(@Nullable BigInteger value) {
        return (UnlimitedNaturalValue)((Object)ValueUtil.integerValueOf(value));
    }

    public static @NonNull UnlimitedNaturalValue unlimitedNaturalValueOf(int value) {
        return (UnlimitedNaturalValue)((Object)ValueUtil.integerValueOf(value));
    }

    public static @NonNull UnlimitedNaturalValue unlimitedNaturalValueOf(long value) {
        return (UnlimitedNaturalValue)((Object)ValueUtil.integerValueOf(value));
    }

    public static @NonNull UnlimitedNaturalValue unlimitedNaturalValueOf(@Nullable Object aValue) {
        if (aValue instanceof BigInteger) {
            return new BigIntegerValueImpl((BigInteger)aValue);
        }
        if (aValue instanceof Unlimited) {
            return UNLIMITED_VALUE;
        }
        if (aValue instanceof Number) {
            return ValueUtil.unlimitedNaturalValueOf(((Number)aValue).longValue());
        }
        if (aValue instanceof Character) {
            return ValueUtil.unlimitedNaturalValueOf(((Character)aValue).charValue());
        }
        if (aValue instanceof UnlimitedNaturalValue) {
            return (UnlimitedNaturalValue)aValue;
        }
        throw new InvalidValueException(PivotMessages.InvalidInteger, aValue);
    }

    public static @NonNull UnlimitedNaturalValue unlimitedNaturalValueOf(@NonNull String aValue) {
        try {
            int len = aValue.length();
            if (len == 1 && "*".equals(aValue)) {
                return UNLIMITED_VALUE;
            }
            if (len < maxLongSize || len == maxLongSize && maxLongValue.compareTo(aValue) >= 0) {
                @NonNull BigInteger result = BigInteger.valueOf(Long.parseLong(aValue));
                return ValueUtil.unlimitedNaturalValueOf(result);
            }
            return ValueUtil.unlimitedNaturalValueOf(new BigInteger(aValue));
        }
        catch (NumberFormatException e) {
            throw new InvalidValueException(e, PivotMessages.InvalidInteger, aValue);
        }
    }
}

