/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.launching.launcher.LaunchPluginValidator;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.launching.launcher.ProductValidationOperation;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.widgets.Shell;

public class ProductValidateAction
extends Action {
    IProduct fProduct;

    public ProductValidateAction(IProduct product) {
        super(PDEUIMessages.ProductValidateAction_validate, 1);
        this.setImageDescriptor(PDEPluginImages.DESC_VALIDATE_TOOL);
        this.fProduct = product;
    }

    public void run() {
        HashSet<IPluginModelBase> launchPlugins = new HashSet<IPluginModelBase>();
        if (this.fProduct.useFeatures()) {
            IFeatureModel[] features;
            IFeatureModel[] iFeatureModelArray = features = this.getUniqueFeatures();
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                IFeatureModel feature = iFeatureModelArray[n2];
                this.addFeaturePlugins(feature.getFeature(), launchPlugins);
                ++n2;
            }
        } else {
            IProductPlugin[] plugins;
            IProductPlugin[] iProductPluginArray = plugins = this.fProduct.getPlugins();
            int n = plugins.length;
            int n3 = 0;
            while (n3 < n) {
                IPluginModelBase model;
                IProductPlugin plugin = iProductPluginArray[n3];
                String id = plugin.getId();
                if (id != null && (model = PluginRegistry.findModel((String)id)) != null && !launchPlugins.contains(model) && TargetPlatformHelper.matchesCurrentEnvironment((IPluginModelBase)model)) {
                    launchPlugins.add(model);
                }
                ++n3;
            }
        }
        try {
            IPluginModelBase[] models = launchPlugins.toArray(new IPluginModelBase[launchPlugins.size()]);
            ProductValidationOperation operation = new ProductValidationOperation(models);
            LaunchPluginValidator.runValidationOperation((LaunchValidationOperation)operation, (IProgressMonitor)new NullProgressMonitor());
            if (!operation.hasErrors()) {
                MessageDialog.open((int)2, (Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.PluginStatusDialog_pluginValidation, (String)PDEUIMessages.AbstractLauncherToolbar_noProblems, (int)0, (String[])new String[]{IDialogConstants.CLOSE_LABEL});
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void addFeaturePlugins(IFeature feature, Set<IPluginModelBase> launchPlugins) {
        IFeaturePlugin[] plugins;
        IFeaturePlugin[] iFeaturePluginArray = plugins = feature.getPlugins();
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            IFeaturePlugin plugin = iFeaturePluginArray[n2];
            String id = plugin.getId();
            String version = plugin.getVersion();
            if (id != null && version != null) {
                IPluginModelBase model = PluginRegistry.findModel((String)id, (String)version, (int)1, null);
                if (model == null) {
                    model = PluginRegistry.findModel((String)id);
                }
                if (model != null && !launchPlugins.contains(model) && TargetPlatformHelper.matchesCurrentEnvironment((IPluginModelBase)model)) {
                    launchPlugins.add(model);
                }
            }
            ++n2;
        }
    }

    private IFeatureModel[] getUniqueFeatures() {
        IProductFeature[] features;
        ArrayList<IFeatureModel> list = new ArrayList<IFeatureModel>();
        IProductFeature[] iProductFeatureArray = features = this.fProduct.getFeatures();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            IProductFeature feature = iProductFeatureArray[n2];
            String id = feature.getId();
            String version = feature.getVersion();
            this.addFeatureAndChildren(id, version, list);
            ++n2;
        }
        return list.toArray(new IFeatureModel[list.size()]);
    }

    private void addFeatureAndChildren(String id, String version, List<IFeatureModel> list) {
        IFeatureChild[] children;
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        IFeatureModel model = manager.findFeatureModel(id, version);
        if (model == null || list.contains(model)) {
            return;
        }
        list.add(model);
        IFeatureChild[] iFeatureChildArray = children = model.getFeature().getIncludedFeatures();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureChild child = iFeatureChildArray[n2];
            this.addFeatureAndChildren(child.getId(), child.getVersion(), list);
            ++n2;
        }
    }
}

